/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SBPTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackOpenPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BlockToolSwapPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.network.EntityToolSwapPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.network.InventoryInteractionPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.network.UpgradeTogglePayload;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;

public class KeybindHandler {
    private static final int KEY_B = 66;
    private static final int KEY_C = 67;
    private static final int KEY_Z = 90;
    private static final int KEY_X = 88;
    private static final int KEY_UNKNOWN = -1;
    private static final int MIDDLE_BUTTON = 2;
    private static final int CHEST_SLOT_INDEX = 38;
    private static final int OFFHAND_SLOT_INDEX = 40;
    private static final String KEYBIND_SOPHISTICATEDBACKPACKS_CATEGORY = "keybind.sophisticatedbackpacks.category";
    public static final KeyMapping BACKPACK_TOGGLE_UPGRADE_5 = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_5"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM.getOrCreate(-1), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping BACKPACK_TOGGLE_UPGRADE_4 = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_4"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM.getOrCreate(-1), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping BACKPACK_TOGGLE_UPGRADE_3 = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_3"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM.getOrCreate(-1), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping BACKPACK_TOGGLE_UPGRADE_2 = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_2"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.ALT, InputConstants.Type.KEYSYM.getOrCreate(88), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping BACKPACK_TOGGLE_UPGRADE_1 = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("toggle_upgrade_1"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.ALT, InputConstants.Type.KEYSYM.getOrCreate(90), "keybind.sophisticatedbackpacks.category");
    public static final Map<Integer, KeyMapping> UPGRADE_SLOT_TOGGLE_KEYBINDS = Map.of(0, BACKPACK_TOGGLE_UPGRADE_1, 1, BACKPACK_TOGGLE_UPGRADE_2, 2, BACKPACK_TOGGLE_UPGRADE_3, 3, BACKPACK_TOGGLE_UPGRADE_4, 4, BACKPACK_TOGGLE_UPGRADE_5);
    public static final KeyMapping SORT_KEYBIND = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("sort"), (IKeyConflictContext)BackpackGuiKeyConflictContext.INSTANCE, InputConstants.Type.MOUSE.getOrCreate(2), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping TOOL_SWAP_KEYBIND = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("tool_swap"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.getOrCreate(-1), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping INVENTORY_INTERACTION_KEYBIND = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("inventory_interaction"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.getOrCreate(67), "keybind.sophisticatedbackpacks.category");
    public static final KeyMapping BACKPACK_OPEN_KEYBIND = new KeyMapping(SBPTranslationHelper.INSTANCE.translKeybind("open_backpack"), (IKeyConflictContext)BackpackKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM.getOrCreate(66), "keybind.sophisticatedbackpacks.category");

    private KeybindHandler() {
    }

    public static void register() {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(EventPriority.HIGH, KeybindHandler::handleKeyInputEvent);
        eventBus.addListener(EventPriority.HIGH, KeybindHandler::handleGuiMouseKeyPress);
        eventBus.addListener(EventPriority.HIGH, KeybindHandler::handleGuiKeyPress);
    }

    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(BACKPACK_OPEN_KEYBIND);
        event.register(INVENTORY_INTERACTION_KEYBIND);
        event.register(TOOL_SWAP_KEYBIND);
        event.register(SORT_KEYBIND);
        UPGRADE_SLOT_TOGGLE_KEYBINDS.forEach((slot, keybind) -> event.register(keybind));
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        InputConstants.Key key = InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode());
        if (SORT_KEYBIND.isActiveAndMatches(key) && KeybindHandler.tryCallSort(event.getScreen()) || BACKPACK_OPEN_KEYBIND.isActiveAndMatches(key) && KeybindHandler.sendBackpackOpenOrCloseMessage()) {
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        InputConstants.Key input = InputConstants.Type.MOUSE.getOrCreate(event.getButton());
        if (SORT_KEYBIND.isActiveAndMatches(input) && KeybindHandler.tryCallSort(event.getScreen()) || BACKPACK_OPEN_KEYBIND.isActiveAndMatches(input) && KeybindHandler.sendBackpackOpenOrCloseMessage()) {
            event.setCanceled(true);
        }
    }

    public static void handleKeyInputEvent(ClientTickEvent.Post event) {
        if (BACKPACK_OPEN_KEYBIND.consumeClick()) {
            KeybindHandler.sendBackpackOpenOrCloseMessage();
        } else if (INVENTORY_INTERACTION_KEYBIND.consumeClick()) {
            KeybindHandler.sendInteractWithInventoryMessage();
        } else if (TOOL_SWAP_KEYBIND.consumeClick()) {
            KeybindHandler.sendToolSwapMessage();
        } else {
            for (Map.Entry<Integer, KeyMapping> slotKeybind : UPGRADE_SLOT_TOGGLE_KEYBINDS.entrySet()) {
                if (!slotKeybind.getValue().consumeClick()) continue;
                PacketDistributor.sendToServer((CustomPacketPayload)new UpgradeTogglePayload(slotKeybind.getKey()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private static boolean tryCallSort(Screen gui) {
        AbstractContainerMenu abstractContainerMenu;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && (abstractContainerMenu = mc.player.containerMenu) instanceof BackpackContainer) {
            double mouseY;
            MouseHandler mh;
            double mouseX;
            BackpackScreen screen;
            Slot selectedSlot;
            BackpackContainer container = (BackpackContainer)abstractContainerMenu;
            if (gui instanceof BackpackScreen && ((selectedSlot = (screen = (BackpackScreen)gui).findSlot(mouseX = (mh = mc.mouseHandler).xpos() * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth(), mouseY = mh.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight())) == null || container.isNotPlayersInventorySlot(selectedSlot.index))) {
                container.sort();
                return true;
            }
        }
        return false;
    }

    private static void sendToolSwapMessage() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.hitResult == null) {
            return;
        }
        if (player.getMainHandItem().getItem() instanceof BackpackItem) {
            player.displayClientMessage((Component)Component.translatable((String)"gui.sophisticatedbackpacks.status.unable_to_swap_tool_for_backpack"), true);
            return;
        }
        HitResult rayTrace = mc.hitResult;
        if (rayTrace.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockRayTraceResult = (BlockHitResult)rayTrace;
            BlockPos pos = blockRayTraceResult.getBlockPos();
            PacketDistributor.sendToServer((CustomPacketPayload)new BlockToolSwapPayload(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (rayTrace.getType() == HitResult.Type.ENTITY) {
            EntityHitResult entityRayTraceResult = (EntityHitResult)rayTrace;
            PacketDistributor.sendToServer((CustomPacketPayload)new EntityToolSwapPayload(entityRayTraceResult.getEntity().getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void sendInteractWithInventoryMessage() {
        Minecraft mc = Minecraft.getInstance();
        HitResult rayTrace = mc.hitResult;
        if (rayTrace == null || rayTrace.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockraytraceresult = (BlockHitResult)rayTrace;
        BlockPos pos = blockraytraceresult.getBlockPos();
        if (Boolean.FALSE.equals(CapabilityHelper.getFromItemHandler((Level)mc.level, (BlockPos)pos, itemHandler -> true, (Object)false))) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new InventoryInteractionPayload(pos, blockraytraceresult.getDirection()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static boolean sendBackpackOpenOrCloseMessage() {
        if (!KeyConflictContext.GUI.isActive()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new BackpackOpenPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return false;
        }
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen) {
            Optional<String> handlerName;
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            Slot slot = containerScreen.getSlotUnderMouse();
            if (slot != null && slot.container instanceof Inventory && (handlerName = KeybindHandler.getPlayerInventoryHandlerName(slot.getSlotIndex())).isPresent() && slot.getItem().getItem() instanceof BackpackItem) {
                PacketDistributor.sendToServer((CustomPacketPayload)new BackpackOpenPayload(slot.getSlotIndex(), "", handlerName.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
            if (screen instanceof BackpackScreen && slot != null && slot.getItem().getItem() instanceof BackpackItem && slot.getItem().getCount() == 1) {
                PacketDistributor.sendToServer((CustomPacketPayload)new BackpackOpenPayload(slot.index), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        return false;
    }

    private static Optional<String> getPlayerInventoryHandlerName(int slotIndex) {
        if (slotIndex == 38) {
            return Optional.of("armor");
        }
        if (slotIndex == 40) {
            return Optional.of("offhand");
        }
        if (slotIndex >= 0 && slotIndex < 36) {
            return Optional.of("main");
        }
        return Optional.empty();
    }

    private static class BackpackGuiKeyConflictContext
    implements IKeyConflictContext {
        public static final BackpackGuiKeyConflictContext INSTANCE = new BackpackGuiKeyConflictContext();

        private BackpackGuiKeyConflictContext() {
        }

        public boolean isActive() {
            return KeyConflictContext.GUI.isActive() && Minecraft.getInstance().screen instanceof BackpackScreen;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }

    private static class BackpackKeyConflictContext
    implements IKeyConflictContext {
        public static final BackpackKeyConflictContext INSTANCE = new BackpackKeyConflictContext();

        private BackpackKeyConflictContext() {
        }

        public boolean isActive() {
            return !KeyConflictContext.GUI.isActive() || Minecraft.getInstance().screen instanceof AbstractContainerScreen;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }
}

