/*
 * Decompiled with CFR 0.152.
 */
package snownee.autochefsdelight.mixin;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.autochefsdelight.util.DummyRecipeInput;
import snownee.autochefsdelight.util.RecipeMatcher;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;

@Mixin(value={CookingPotRecipe.class})
public abstract class CookingPotRecipeMixin {
    @Shadow(remap=false)
    @Final
    private NonNullList<Ingredient> inputItems;

    @Inject(method={"matches(Lnet/neoforged/neoforge/items/wrapper/RecipeWrapper;Lnet/minecraft/world/level/Level;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void matches(RecipeWrapper inv, Level level, CallbackInfoReturnable<Boolean> ci) {
        int[] amount;
        List<Object> inputs;
        if (inv instanceof DummyRecipeInput) {
            DummyRecipeInput ctx = (DummyRecipeInput)inv;
            if (ctx.itemCount < this.inputItems.size()) {
                ci.setReturnValue((Object)false);
                return;
            }
            inputs = ctx.filteredInputs;
            amount = ctx.amount;
        } else {
            inputs = Lists.newArrayListWithExpectedSize((int)6);
            int itemCount = 0;
            for (int slotOffset = 0; slotOffset < 6; ++slotOffset) {
                ItemStack itemStack = inv.getItem(slotOffset);
                if (itemStack.isEmpty()) continue;
                inputs.add(itemStack);
                itemCount += itemStack.getCount();
            }
            if (itemCount < this.inputItems.size()) {
                ci.setReturnValue((Object)false);
                return;
            }
            amount = new int[inputs.size()];
            for (int i = 0; i < amount.length; ++i) {
                amount[i] = ((ItemStack)inputs.get(i)).getCount();
            }
        }
        Optional<RecipeMatcher<Object>> match = RecipeMatcher.findMatches(inputs, this.inputItems, amount);
        if (inv instanceof DummyRecipeInput) {
            DummyRecipeInput ctx = (DummyRecipeInput)inv;
            ctx.matchSetter.accept(match.orElse(null));
        }
        ci.setReturnValue((Object)match.isPresent());
    }
}

