/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.config;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftbxmodcompat.FTBXModCompat;
import java.util.function.BooleanSupplier;

public interface FTBXModConfig {
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbxmodcompat");
    public static final EnumValue<StageSelector> STAGE_SELECTOR = (EnumValue)CONFIG.addEnum("stage_selector", NameMap.of((Object)((Object)StageSelector.DEFAULT), (Object[])StageSelector.values()).create()).comment(new String[]{"Select the game stages implementation to use", "DEFAULT: use KubeJS, Game Stages, vanilla in preference order, depending on mod availability"});
    public static final EnumValue<PermSelector> PERMISSION_SELECTOR = (EnumValue)CONFIG.addEnum("permission_selector", NameMap.of((Object)((Object)PermSelector.DEFAULT), (Object[])PermSelector.values()).create()).comment(new String[]{"Select the permissions implementation to use", "DEFAULT: use FTB Ranks then Luckperms in preference order, depending on mod availability"});
    public static final BooleanValue ONLY_SHOW_KNOWN_WAYSTONES = (BooleanValue)CONFIG.addBoolean("only_show_known_waystones", true).comment(new String[]{"Only show waystones that have been discovered"});

    public static enum StageSelector {
        DEFAULT(() -> true),
        VANILLA(() -> true),
        KUBEJS(() -> FTBXModCompat.isKubeJSLoaded),
        GAMESTAGES(() -> FTBXModCompat.isGameStagesLoaded);

        private final BooleanSupplier usable;

        private StageSelector(BooleanSupplier usable) {
            this.usable = usable;
        }

        public boolean isUsable() {
            return this.usable.getAsBoolean();
        }
    }

    public static enum PermSelector {
        DEFAULT(() -> true),
        FTB_RANKS(() -> FTBXModCompat.isFTBRanksLoaded),
        LUCKPERMS(() -> FTBXModCompat.isLuckPermsLoaded);

        private final BooleanSupplier usable;

        private PermSelector(BooleanSupplier usable) {
            this.usable = usable;
        }

        public boolean isUsable() {
            return this.usable.getAsBoolean();
        }
    }
}

