/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.util;

import com.mrbysco.heads.registry.HeadTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HeadUtil {
    public static ItemStack getStackForEntity(LivingEntity livingEntity, DamageSource damageSource, int lootLevel) {
        if (livingEntity.isBaby()) {
            return ItemStack.EMPTY;
        }
        HeadTypes headType = HeadTypes.getMatchingHead(livingEntity);
        if (headType != null) {
            boolean regularDrop;
            Creeper creeper;
            Entity source = damageSource.getDirectEntity();
            ItemStack headStack = new ItemStack((ItemLike)headType.getHeadItem());
            double dropRate = headType.getDropRate() + (double)lootLevel * 0.01;
            boolean creeperDrop = headType.canDropFromCreeperExplosion() && source instanceof Creeper && (creeper = (Creeper)source).canDropMobsSkull();
            boolean bl = regularDrop = source instanceof Player && (dropRate >= 1.0 || dropRate > 0.0 && (dropRate == 1.0 || livingEntity.getRandom().nextDouble() <= dropRate));
            if (creeperDrop || regularDrop) {
                return headStack;
            }
        }
        return ItemStack.EMPTY;
    }
}

