/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.registry;

import com.mrbysco.heads.config.HeadConfig;
import com.mrbysco.heads.registry.HeadsRegistry;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum HeadTypes implements SkullBlock.Type
{
    AXOLOTL_BLUE(entity -> entity.getType() == EntityType.AXOLOTL && ((Axolotl)entity).getVariant() == Axolotl.Variant.BLUE, (Supplier<Double>)HeadConfig.COMMON.axolotl.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.axolotl.enableCreeperDrop),
    AXOLOTL_CYAN(entity -> entity.getType() == EntityType.AXOLOTL && ((Axolotl)entity).getVariant() == Axolotl.Variant.CYAN, (Supplier<Double>)HeadConfig.COMMON.axolotl.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.axolotl.enableCreeperDrop),
    AXOLOTL_GOLD(entity -> entity.getType() == EntityType.AXOLOTL && ((Axolotl)entity).getVariant() == Axolotl.Variant.GOLD, (Supplier<Double>)HeadConfig.COMMON.axolotl.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.axolotl.enableCreeperDrop),
    AXOLOTL_LUCY(entity -> entity.getType() == EntityType.AXOLOTL && ((Axolotl)entity).getVariant() == Axolotl.Variant.LUCY, (Supplier<Double>)HeadConfig.COMMON.axolotl.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.axolotl.enableCreeperDrop),
    AXOLOTL_WILD(entity -> entity.getType() == EntityType.AXOLOTL && ((Axolotl)entity).getVariant() == Axolotl.Variant.WILD, (Supplier<Double>)HeadConfig.COMMON.axolotl.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.axolotl.enableCreeperDrop),
    BAT(entity -> entity.getType() == EntityType.BAT, (Supplier<Double>)HeadConfig.COMMON.bat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.bat.enableCreeperDrop),
    BEE(entity -> entity.getType() == EntityType.BEE, (Supplier<Double>)HeadConfig.COMMON.bee.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.bee.enableCreeperDrop),
    BLAZE(entity -> entity.getType() == EntityType.BLAZE, (Supplier<Double>)HeadConfig.COMMON.blaze.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.blaze.enableCreeperDrop),
    CAT_ALL_BLACK(entity -> entity.getType() == EntityType.CAT && BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)((CatVariant)((Cat)entity).getVariant().value())).orElse(null) == CatVariant.ALL_BLACK, (Supplier<Double>)HeadConfig.COMMON.cat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cat.enableCreeperDrop),
    CAT_BLACK(entity -> entity.getType() == EntityType.CAT && BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)((CatVariant)((Cat)entity).getVariant().value())).orElse(null) == CatVariant.BLACK, (Supplier<Double>)HeadConfig.COMMON.cat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cat.enableCreeperDrop),
    CAT_BRITISH_SHORTHAIR(entity -> entity.getType() == EntityType.CAT && BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)((CatVariant)((Cat)entity).getVariant().value())).orElse(null) == CatVariant.BRITISH_SHORTHAIR, (Supplier<Double>)HeadConfig.COMMON.cat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cat.enableCreeperDrop),
    CAT_CALICO(entity -> entity.getType() == EntityType.CAT && BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)((CatVariant)((Cat)entity).getVariant().value())).orElse(null) == CatVariant.CALICO, (Supplier<Double>)HeadConfig.COMMON.cat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cat.enableCreeperDrop),
    CAT_JELLIE(entity -> entity.getType() == EntityType.CAT && BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)((CatVariant)((Cat)entity).getVariant().value())).orElse(null) == CatVariant.JELLIE, (Supplier<Double>)HeadConfig.COMMON.cat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cat.enableCreeperDrop),
    CAT_PERSIAN(entity -> entity.getType() == EntityType.CAT && BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)((CatVariant)((Cat)entity).getVariant().value())).orElse(null) == CatVariant.PERSIAN, (Supplier<Double>)HeadConfig.COMMON.cat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cat.enableCreeperDrop),
    CAT_RAGDOLL(entity -> entity.getType() == EntityType.CAT && BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)((CatVariant)((Cat)entity).getVariant().value())).orElse(null) == CatVariant.RAGDOLL, (Supplier<Double>)HeadConfig.COMMON.cat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cat.enableCreeperDrop),
    CAT_RED(entity -> entity.getType() == EntityType.CAT && BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)((CatVariant)((Cat)entity).getVariant().value())).orElse(null) == CatVariant.RED, (Supplier<Double>)HeadConfig.COMMON.cat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cat.enableCreeperDrop),
    CAT_SIAMESE(entity -> entity.getType() == EntityType.CAT && BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)((CatVariant)((Cat)entity).getVariant().value())).orElse(null) == CatVariant.SIAMESE, (Supplier<Double>)HeadConfig.COMMON.cat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cat.enableCreeperDrop),
    CAT_TABBY(entity -> entity.getType() == EntityType.CAT && BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)((CatVariant)((Cat)entity).getVariant().value())).orElse(null) == CatVariant.TABBY, (Supplier<Double>)HeadConfig.COMMON.cat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cat.enableCreeperDrop),
    CAT_WHITE(entity -> entity.getType() == EntityType.CAT && BuiltInRegistries.CAT_VARIANT.getResourceKey((Object)((CatVariant)((Cat)entity).getVariant().value())).orElse(null) == CatVariant.WHITE, (Supplier<Double>)HeadConfig.COMMON.cat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cat.enableCreeperDrop),
    CAVE_SPIDER(entity -> entity.getType() == EntityType.CAVE_SPIDER, (Supplier<Double>)HeadConfig.COMMON.caveSpider.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.caveSpider.enableCreeperDrop),
    CHICKEN(entity -> entity.getType() == EntityType.CHICKEN, (Supplier<Double>)HeadConfig.COMMON.chicken.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.chicken.enableCreeperDrop),
    COD(entity -> entity.getType() == EntityType.COD, (Supplier<Double>)HeadConfig.COMMON.cod.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cod.enableCreeperDrop),
    COW(entity -> entity.getType() == EntityType.COW, (Supplier<Double>)HeadConfig.COMMON.cow.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.cow.enableCreeperDrop),
    DOLPHIN(entity -> entity.getType() == EntityType.DOLPHIN, (Supplier<Double>)HeadConfig.COMMON.dolphin.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.dolphin.enableCreeperDrop),
    DONKEY(entity -> entity.getType() == EntityType.DONKEY, (Supplier<Double>)HeadConfig.COMMON.donkey.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.donkey.enableCreeperDrop),
    DROWNED(entity -> entity.getType() == EntityType.DROWNED, (Supplier<Double>)HeadConfig.COMMON.drowned.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.drowned.enableCreeperDrop),
    ENDERMAN(entity -> entity.getType() == EntityType.ENDERMAN, (Supplier<Double>)HeadConfig.COMMON.enderman.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.enderman.enableCreeperDrop),
    ENDERMITE(entity -> entity.getType() == EntityType.ENDERMITE, (Supplier<Double>)HeadConfig.COMMON.endermite.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.endermite.enableCreeperDrop),
    EVOKER(entity -> entity.getType() == EntityType.EVOKER, (Supplier<Double>)HeadConfig.COMMON.evoker.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.evoker.enableCreeperDrop),
    FOX(entity -> entity.getType() == EntityType.FOX && ((Fox)entity).getVariant() == Fox.Type.RED, (Supplier<Double>)HeadConfig.COMMON.fox.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.fox.enableCreeperDrop),
    FOX_SNOW(entity -> entity.getType() == EntityType.FOX && ((Fox)entity).getVariant() == Fox.Type.SNOW, (Supplier<Double>)HeadConfig.COMMON.fox.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.fox.enableCreeperDrop),
    GHAST(entity -> entity.getType() == EntityType.GHAST, (Supplier<Double>)HeadConfig.COMMON.ghast.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.ghast.enableCreeperDrop),
    GLOW_SQUID(entity -> entity.getType() == EntityType.GLOW_SQUID, (Supplier<Double>)HeadConfig.COMMON.glowSquid.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.glowSquid.enableCreeperDrop),
    GOAT(entity -> entity.getType() == EntityType.GOAT, (Supplier<Double>)HeadConfig.COMMON.goat.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.goat.enableCreeperDrop),
    HOGLIN(entity -> entity.getType() == EntityType.HOGLIN, (Supplier<Double>)HeadConfig.COMMON.hoglin.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.hoglin.enableCreeperDrop),
    HORSE_BLACK(entity -> entity.getType() == EntityType.HORSE && ((Horse)entity).getVariant() == Variant.BLACK, (Supplier<Double>)HeadConfig.COMMON.horse.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.horse.enableCreeperDrop),
    HORSE_BROWN(entity -> entity.getType() == EntityType.HORSE && ((Horse)entity).getVariant() == Variant.BROWN, (Supplier<Double>)HeadConfig.COMMON.horse.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.horse.enableCreeperDrop),
    HORSE_CHESTNUT(entity -> entity.getType() == EntityType.HORSE && ((Horse)entity).getVariant() == Variant.CHESTNUT, (Supplier<Double>)HeadConfig.COMMON.horse.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.horse.enableCreeperDrop),
    HORSE_CREAMY(entity -> entity.getType() == EntityType.HORSE && ((Horse)entity).getVariant() == Variant.CREAMY, (Supplier<Double>)HeadConfig.COMMON.horse.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.horse.enableCreeperDrop),
    HORSE_DARKBROWN(entity -> entity.getType() == EntityType.HORSE && ((Horse)entity).getVariant() == Variant.DARK_BROWN, (Supplier<Double>)HeadConfig.COMMON.horse.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.horse.enableCreeperDrop),
    HORSE_GRAY(entity -> entity.getType() == EntityType.HORSE && ((Horse)entity).getVariant() == Variant.GRAY, (Supplier<Double>)HeadConfig.COMMON.horse.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.horse.enableCreeperDrop),
    HORSE_SKELETON(entity -> entity.getType() == EntityType.SKELETON_HORSE, (Supplier<Double>)HeadConfig.COMMON.horseSkeleton.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.horseSkeleton.enableCreeperDrop),
    HORSE_UNDEAD(entity -> entity.getType() == EntityType.ZOMBIE_HORSE, (Supplier<Double>)HeadConfig.COMMON.horseUndead.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.horseUndead.enableCreeperDrop),
    HORSE_WHITE(entity -> entity.getType() == EntityType.HORSE && ((Horse)entity).getVariant() == Variant.WHITE, (Supplier<Double>)HeadConfig.COMMON.horse.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.horse.enableCreeperDrop),
    HUSK(entity -> entity.getType() == EntityType.HUSK, (Supplier<Double>)HeadConfig.COMMON.husk.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.husk.enableCreeperDrop),
    ILLUSIONER(entity -> entity.getType() == EntityType.ILLUSIONER, (Supplier<Double>)HeadConfig.COMMON.illusioner.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.illusioner.enableCreeperDrop),
    IRON_GOLEM(entity -> entity.getType() == EntityType.IRON_GOLEM, (Supplier<Double>)HeadConfig.COMMON.ironGolem.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.ironGolem.enableCreeperDrop),
    MAGMA_CUBE(entity -> entity.getType() == EntityType.MAGMA_CUBE, (Supplier<Double>)HeadConfig.COMMON.magmaCube.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.magmaCube.enableCreeperDrop),
    MULE(entity -> entity.getType() == EntityType.MULE, (Supplier<Double>)HeadConfig.COMMON.mule.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.mule.enableCreeperDrop),
    MOOSHROOM_BROWN(entity -> entity.getType() == EntityType.MOOSHROOM && ((MushroomCow)entity).getVariant() == MushroomCow.MushroomType.BROWN, (Supplier<Double>)HeadConfig.COMMON.mooshroom.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.mooshroom.enableCreeperDrop),
    MOOSHROOM_RED(entity -> entity.getType() == EntityType.MOOSHROOM && ((MushroomCow)entity).getVariant() == MushroomCow.MushroomType.RED, (Supplier<Double>)HeadConfig.COMMON.mooshroom.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.mooshroom.enableCreeperDrop),
    OCELOT(entity -> entity.getType() == EntityType.OCELOT, (Supplier<Double>)HeadConfig.COMMON.ocelot.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.ocelot.enableCreeperDrop),
    PIG(entity -> entity.getType() == EntityType.PIG, (Supplier<Double>)HeadConfig.COMMON.pig.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.pig.enableCreeperDrop),
    PIGLIN(entity -> entity.getType() == EntityType.PIGLIN, (Supplier<Double>)HeadConfig.COMMON.piglin.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.piglin.enableCreeperDrop),
    PIGLIN_BRUTE(entity -> entity.getType() == EntityType.PIGLIN_BRUTE, (Supplier<Double>)HeadConfig.COMMON.piglinBrute.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.piglinBrute.enableCreeperDrop),
    PILLAGER(entity -> entity.getType() == EntityType.PILLAGER, (Supplier<Double>)HeadConfig.COMMON.pillager.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.pillager.enableCreeperDrop),
    SALMON(entity -> entity.getType() == EntityType.SALMON, (Supplier<Double>)HeadConfig.COMMON.salmon.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.salmon.enableCreeperDrop),
    SHEEP_BLACK(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.BLACK;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_BLUE(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.BLUE;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_BROWN(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.BROWN;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_CYAN(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.CYAN;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_GRAY(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.GRAY;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_GREEN(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.GREEN;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_LIGHT_BLUE(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.LIGHT_BLUE;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_LIGHT_GRAY(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.LIGHT_GRAY;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_LIME(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.LIME;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_MAGENTA(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.MAGENTA;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_ORANGE(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.ORANGE;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_PINK(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.PINK;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_PURPLE(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.PURPLE;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_RED(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.RED;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_SHAVEN(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && (sheep = (Sheep)entity).isSheared();
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_WHITE(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.WHITE;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SHEEP_YELLOW(entity -> {
        Sheep sheep;
        return entity.getType() == EntityType.SHEEP && entity instanceof Sheep && !(sheep = (Sheep)entity).isSheared() && sheep.getColor() == DyeColor.YELLOW;
    }, (Supplier<Double>)HeadConfig.COMMON.sheep.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.sheep.enableCreeperDrop),
    SILVERFISH(entity -> entity.getType() == EntityType.SILVERFISH, (Supplier<Double>)HeadConfig.COMMON.silverfish.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.silverfish.enableCreeperDrop),
    SLIME(entity -> entity.getType() == EntityType.SLIME, (Supplier<Double>)HeadConfig.COMMON.slime.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.slime.enableCreeperDrop),
    SNOW_GOLEM(entity -> entity.getType() == EntityType.SNOW_GOLEM, (Supplier<Double>)HeadConfig.COMMON.snowGolem.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.snowGolem.enableCreeperDrop),
    SPIDER(entity -> entity.getType() == EntityType.SPIDER, (Supplier<Double>)HeadConfig.COMMON.spider.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.spider.enableCreeperDrop),
    SQUID(entity -> entity.getType() == EntityType.SQUID, (Supplier<Double>)HeadConfig.COMMON.squid.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.squid.enableCreeperDrop),
    STRAY(entity -> entity.getType() == EntityType.STRAY, (Supplier<Double>)HeadConfig.COMMON.stray.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.stray.enableCreeperDrop),
    TURTLE(entity -> entity.getType() == EntityType.TURTLE, (Supplier<Double>)HeadConfig.COMMON.turtle.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.turtle.enableCreeperDrop),
    VILLAGER(entity -> entity.getType() == EntityType.VILLAGER, (Supplier<Double>)HeadConfig.COMMON.villager.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.villager.enableCreeperDrop),
    VINDICATOR(entity -> entity.getType() == EntityType.VINDICATOR, (Supplier<Double>)HeadConfig.COMMON.vindicator.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.vindicator.enableCreeperDrop),
    WANDERING_TRADER(entity -> entity.getType() == EntityType.WANDERING_TRADER, (Supplier<Double>)HeadConfig.COMMON.wanderingTrader.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.wanderingTrader.enableCreeperDrop),
    WITCH(entity -> entity.getType() == EntityType.WITCH, (Supplier<Double>)HeadConfig.COMMON.witch.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.witch.enableCreeperDrop),
    WOLF(entity -> entity.getType() == EntityType.WOLF, (Supplier<Double>)HeadConfig.COMMON.wolf.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.wolf.enableCreeperDrop),
    ZOGLIN(entity -> entity.getType() == EntityType.ZOGLIN, (Supplier<Double>)HeadConfig.COMMON.zoglin.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.zoglin.enableCreeperDrop),
    ZOMBIE_VILLAGER(entity -> entity.getType() == EntityType.ZOMBIE_VILLAGER, (Supplier<Double>)HeadConfig.COMMON.zombieVillager.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.zombieVillager.enableCreeperDrop),
    ZOMBIFIED_PIGLIN(entity -> entity.getType() == EntityType.ZOMBIFIED_PIGLIN, (Supplier<Double>)HeadConfig.COMMON.zombifiedPiglin.dropRate, (Supplier<Boolean>)HeadConfig.COMMON.zombifiedPiglin.enableCreeperDrop);

    private final Predicate<LivingEntity> entityPredicate;
    private final Supplier<Double> dropRate;
    private final Supplier<Boolean> creeperExplosion;

    private HeadTypes(Predicate<LivingEntity> entityPredicate, Supplier<Double> dropRateSupplier, Supplier<Boolean> creeperExplosionSupplier) {
        this.entityPredicate = entityPredicate;
        this.dropRate = dropRateSupplier;
        this.creeperExplosion = creeperExplosionSupplier;
    }

    public Predicate<LivingEntity> getEntityPredicate() {
        return this.entityPredicate;
    }

    public double getDropRate() {
        return this.dropRate.get();
    }

    public boolean canDropFromCreeperExplosion() {
        return this.creeperExplosion.get();
    }

    @Nullable
    public static HeadTypes getMatchingHead(@NotNull LivingEntity livingEntity) {
        for (HeadTypes headType : HeadTypes.values()) {
            if (!headType.getEntityPredicate().test(livingEntity)) continue;
            return headType;
        }
        return null;
    }

    public Item getHeadItem() {
        return (Item)HeadsRegistry.headMap.get((Object)this).getHeadItem().get();
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

