/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.datagen.client;

import com.mrbysco.heads.registry.HeadsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class HeadLootProvider
extends LootTableProvider {
    public static final List<Item> RESISTANT = new ArrayList<Item>();

    public HeadLootProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(HeadsBlockTables::new, LootContextParamSets.BLOCK)), lookupProvider);
    }

    protected static <T extends ConditionUserBuilder<T>> T applyExplosionCondition(ItemLike itemLike, ConditionUserBuilder<T> conditionUserBuilder) {
        return (T)(!RESISTANT.contains(itemLike.asItem()) ? conditionUserBuilder.when(ExplosionCondition.survivesExplosion()) : conditionUserBuilder.unwrap());
    }

    protected static LootTable.Builder createSingleItemTable(ItemLike itemLike) {
        return LootTable.lootTable().withPool((LootPool.Builder)HeadLootProvider.applyExplosionCondition(itemLike, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike))));
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        super.validate(writableregistry, validationcontext, problemreporter$collector);
    }

    public static class HeadsBlockTables
    extends BlockLootSubProvider {
        protected HeadsBlockTables(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            HeadsRegistry.headList.forEach(headReg -> this.dropSkull((Block)headReg.getHead().get()));
        }

        private void dropSkull(Block block) {
            RESISTANT.add(block.asItem());
            this.add(block, HeadLootProvider::createSingleItemTable);
        }

        protected Iterable<Block> getKnownBlocks() {
            return HeadsRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
        }
    }
}

