/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.config;

import java.util.Locale;
import net.neoforged.neoforge.common.ModConfigSpec;

public class HeadInfo {
    public final ModConfigSpec.BooleanValue enableCreeperDrop;
    public final ModConfigSpec.DoubleValue dropRate;

    public HeadInfo(ModConfigSpec.Builder builder, String mobName, double rate) {
        String configName = this.getCamelCase(mobName);
        builder.comment(mobName + " settings").push(configName);
        this.enableCreeperDrop = builder.comment("Enable charged creeper explosion to drop a " + mobName + " head").define(configName + "EnableCreeperDrop", true);
        this.dropRate = builder.comment("Defines the drop rate for the " + mobName + " head (0 to disable) [Default: 0.025]").defineInRange(configName + "DropRate", rate, 0.0, 1.0);
        builder.pop();
    }

    private String getCamelCase(String input) {
        if (input.contains(" ")) {
            String[] words = input.split("[\\W_]+");
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < words.length; ++i) {
                Object word = words[i];
                word = i == 0 ? (((String)word).isEmpty() ? word : ((String)word).toLowerCase()) : (((String)word).isEmpty() ? word : Character.toUpperCase(((String)word).charAt(0)) + ((String)word).substring(1).toLowerCase());
                builder.append((String)word);
            }
            return builder.toString();
        }
        return input.toLowerCase(Locale.ROOT);
    }
}

