/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrbysco.heads.client.models.HeadModelBase;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class SquidSkullModel
extends HeadModelBase {
    private final boolean glow;

    public SquidSkullModel(ModelPart root, boolean glow) {
        super(root);
        this.glow = glow;
    }

    public static MeshDefinition createSquidHead() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -8.0f, -2.0f, 6.0f, 8.0f, 6.0f), PartPose.ZERO);
        return meshdefinition;
    }

    public static LayerDefinition createSkullModel() {
        MeshDefinition meshdefinition = SquidSkullModel.createSquidHead();
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    @Override
    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, int color) {
        if (this.glow) {
            super.renderToBuffer(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, color);
        } else {
            super.renderToBuffer(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, color);
        }
    }
}

