/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrbysco.heads.client.models.CowSkullModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class MooshroomSkullModel
extends CowSkullModel {
    private final BlockState mushroomState;
    private float yRot = 0.0f;

    public MooshroomSkullModel(ModelPart root, boolean red) {
        super(root);
        this.mushroomState = red ? Blocks.RED_MUSHROOM.defaultBlockState() : Blocks.BROWN_MUSHROOM.defaultBlockState();
    }

    @Override
    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, int color) {
        super.renderToBuffer(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, color);
        Minecraft minecraft = Minecraft.getInstance();
        BlockRenderDispatcher blockrenderdispatcher = minecraft.getBlockRenderer();
        poseStack.translate(0.0, -1.0, 0.05);
        poseStack.mulPose(Axis.YP.rotationDegrees(-78.0f));
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, -0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(this.yRot * ((float)Math.PI / 180)));
        blockrenderdispatcher.renderSingleBlock(this.mushroomState, poseStack, (MultiBufferSource)minecraft.renderBuffers().bufferSource(), packedLightIn, packedOverlayIn, ModelData.EMPTY, RenderType.cutout());
    }

    @Override
    public void setupAnim(float mouthAnimation, float yRot, float xRot) {
        super.setupAnim(mouthAnimation, yRot, xRot);
        this.yRot = yRot;
    }
}

