/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrbysco.heads.client.models.HeadModelBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class LayeredSkullModel
extends HeadModelBase {
    private final RenderType OUTER_LAYER;
    protected final ModelPart hat;

    public LayeredSkullModel(ModelPart root, ResourceLocation layer) {
        super(root);
        this.hat = root.getChild("hat");
        this.OUTER_LAYER = RenderType.entityCutoutNoCullZOffset((ResourceLocation)layer);
    }

    public static MeshDefinition createHumanoidHead() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -7.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.ZERO);
        return meshdefinition;
    }

    public static LayerDefinition createSkullModel() {
        MeshDefinition meshdefinition = LayeredSkullModel.createHumanoidHead();
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createSkullModel(int width, int height) {
        MeshDefinition meshdefinition = LayeredSkullModel.createHumanoidHead();
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)width, (int)height);
    }

    @Override
    public void setupAnim(float mouthAnimation, float yRot, float xRot) {
        super.setupAnim(mouthAnimation, yRot, xRot);
        this.hat.yRot = yRot * ((float)Math.PI / 180);
        this.hat.xRot = xRot * ((float)Math.PI / 180);
    }

    @Override
    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, int color) {
        super.renderToBuffer(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, color);
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        VertexConsumer cutoutConsumer = bufferSource.getBuffer(this.OUTER_LAYER);
        this.hat.render(poseStack, cutoutConsumer, packedLightIn, packedOverlayIn, color);
        bufferSource.endBatch(this.OUTER_LAYER);
    }
}

