/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.heads.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class HorseSkullModel
extends SkullModelBase {
    protected final ModelPart root;
    protected final ModelPart head;

    public HorseSkullModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head_parts");
    }

    public static MeshDefinition createHorseHead(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartPose pose = PartPose.rotation((float)0.45f, (float)0.0f, (float)0.0f);
        PartDefinition head_parts = partdefinition.addOrReplaceChild("head_parts", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition head = head_parts.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 35).addBox("neck", -2.0f, -10.0f, -1.0f, 4.0f, 12.0f, 7.0f).texOffs(0, 13).addBox(-3.0f, -15.0f, -1.0f, 6.0f, 5.0f, 7.0f, cubeDeformation), pose);
        head_parts.addOrReplaceChild("mane", CubeListBuilder.create().texOffs(56, 36).addBox(-1.0f, -15.0f, 6.0f, 2.0f, 16.0f, 2.0f, cubeDeformation), pose);
        head_parts.addOrReplaceChild("upper_mouth", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -15.0f, -6.0f, 4.0f, 5.0f, 5.0f, cubeDeformation), pose);
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(19, 16).addBox(0.55f, -17.0f, 5.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.ZERO);
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(19, 16).addBox(-2.55f, -17.0f, 5.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.ZERO);
        return meshdefinition;
    }

    public static LayerDefinition createMuleSkull() {
        MeshDefinition meshdefinition = HorseSkullModel.createHorseHead(CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.getChild("head_parts").getChild("head");
        CubeListBuilder ear = CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -5.0f, 0.0f, 2.0f, 7.0f, 1.0f);
        head.addOrReplaceChild("left_ear", ear, PartPose.offsetAndRotation((float)1.25f, (float)-16.0f, (float)3.0f, (float)0.2617994f, (float)0.0f, (float)0.2617994f));
        head.addOrReplaceChild("right_ear", ear, PartPose.offsetAndRotation((float)-1.25f, (float)-16.0f, (float)3.0f, (float)0.2617994f, (float)0.0f, (float)-0.2617994f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDonkeySkull() {
        MeshDefinition meshdefinition = HorseSkullModel.createHorseHead(CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.getChild("head_parts").getChild("head");
        CubeListBuilder ear = CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -5.0f, 0.0f, 2.0f, 7.0f, 1.0f);
        head.addOrReplaceChild("left_ear", ear, PartPose.offsetAndRotation((float)1.25f, (float)-16.0f, (float)3.0f, (float)0.2617994f, (float)0.0f, (float)0.2617994f));
        head.addOrReplaceChild("right_ear", ear, PartPose.offsetAndRotation((float)-1.25f, (float)-16.0f, (float)3.0f, (float)0.2617994f, (float)0.0f, (float)-0.2617994f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createHorseSkull() {
        MeshDefinition meshdefinition = HorseSkullModel.createHorseHead(CubeDeformation.NONE);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(float mouthAnimation, float yRot, float xRot) {
        this.head.yRot = yRot * ((float)Math.PI / 180);
        this.head.xRot = xRot * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, int color) {
        this.root.render(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, color);
    }
}

