/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.network;

import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.IInventoryPuller;
import com.buuz135.findme.network.PositionRequestMessage;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class PullItemRequestMessage
implements CustomPacketPayload {
    public static CustomPacketPayload.Type<PullItemRequestMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"findme", (String)"pull_item_request"));
    public static StreamCodec<? super RegistryFriendlyByteBuf, PullItemRequestMessage> CODEC = new StreamCodec<RegistryFriendlyByteBuf, PullItemRequestMessage>(){

        public PullItemRequestMessage decode(RegistryFriendlyByteBuf object) {
            return new PullItemRequestMessage(ItemStack.parseOptional((HolderLookup.Provider)object.registryAccess(), (CompoundTag)Objects.requireNonNull(object.readNbt())), object.readInt());
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, PullItemRequestMessage positionRequestMessage) {
            registryFriendlyByteBuf.writeNbt(positionRequestMessage.stack.save((HolderLookup.Provider)registryFriendlyByteBuf.registryAccess()));
            registryFriendlyByteBuf.writeInt(positionRequestMessage.amount);
        }
    };
    private ItemStack stack;
    private int amount;

    public PullItemRequestMessage(ItemStack stack, int amount) {
        this.stack = stack;
        this.amount = amount;
        TrackingList.trackItem(stack);
    }

    public PullItemRequestMessage() {
    }

    public static boolean compareItems(ItemStack first, ItemStack second) {
        if (FindMeMod.CONFIG.COMMON.IGNORE_ITEM_DAMAGE) {
            return ItemStack.isSameItem((ItemStack)first, (ItemStack)second);
        }
        return ItemStack.isSameItemSameComponents((ItemStack)first, (ItemStack)second);
    }

    public void handle(NetworkManager.PacketContext contextSupplier) {
        contextSupplier.queue(() -> {
            AABB box = new AABB(contextSupplier.getPlayer().blockPosition()).inflate((double)FindMeMod.CONFIG.COMMON.RADIUS_RANGE);
            int currentAmount = 0;
            for (BlockPos blockPos : PositionRequestMessage.getBlockPosInAABB(box)) {
                BlockEntity tileEntity = contextSupplier.getPlayer().level().getBlockEntity(blockPos);
                if (tileEntity != null) {
                    for (IInventoryPuller blockExtractor : FindMeMod.BLOCK_EXTRACTORS) {
                        if ((currentAmount += blockExtractor.pull(tileEntity, this.stack, this.amount - currentAmount, contextSupplier.getPlayer())) >= this.amount) break;
                    }
                }
                if (currentAmount < this.amount) continue;
                break;
            }
            if (currentAmount < this.amount) {
                Player player = contextSupplier.getPlayer();
                Level level = player.level();
                level.playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.5f, ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

