/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.SectionPos;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.SBLConstants;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class EntityRetrievalUtil {
    @Nullable
    public static <T extends Entity> T getNearest(Vec3 origin, List<T> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        double dist = Double.MAX_VALUE;
        Entity closest = null;
        for (Entity entity : entities) {
            double entityDist = entity.distanceToSqr(origin);
            if (!(entityDist < dist)) continue;
            dist = entityDist;
            closest = entity;
        }
        return (T)closest;
    }

    public static <T> Optional<T> getNearestEntity(Entity origin, double radius) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius);
    }

    public static <T> Optional<T> getNearestEntity(Entity origin, double radiusX, double radiusY, double radiusZ) {
        return Optional.ofNullable(EntityRetrievalUtil.getNearestEntity(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), origin.position(), (? extends Entity entity) -> entity != origin));
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Level level, Vec3 origin, double radius) {
        return EntityRetrievalUtil.getNearestEntity(level, origin, radius, radius, radius);
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getNearestEntity(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin);
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Level level, AABB bounds, Vec3 origin) {
        return EntityRetrievalUtil.getNearestEntity(level, bounds, origin, Entity.class);
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Entity origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius, minimumClass);
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Entity origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.getNearestEntity(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), origin.position(), minimumClass, (T entity) -> entity != origin);
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Level level, Vec3 origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.getNearestEntity(level, origin, radius, radius, radius, minimumClass);
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.getNearestEntity(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin, minimumClass);
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Level level, AABB bounds, Vec3 origin, Class<T> minimumClass) {
        return EntityRetrievalUtil.getNearestEntity(level, bounds, origin, minimumClass, (T entity) -> true);
    }

    public static <T extends Entity> T getNearestEntity(Entity origin, double radius, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius, predicate);
    }

    public static <T extends Entity> T getNearestEntity(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), origin.position(), ((Predicate<Entity>)entity -> entity != origin).and(predicate));
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Level level, Vec3 origin, double radius, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.getNearestEntity(level, origin, radius, radius, radius, predicate);
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Predicate<Entity> predicate) {
        return Optional.ofNullable(EntityRetrievalUtil.getNearestEntity(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin, predicate));
    }

    @Nullable
    public static <T extends Entity> T getNearestEntity(Level level, AABB bounds, Vec3 origin, Predicate<? extends Entity> predicate) {
        return (T)((Entity)EntityRetrievalUtil.getNearestEntity(level, bounds, origin, Entity.class, predicate).orElse(null));
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Entity origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius, minimumClass, predicate);
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Entity origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), origin.position(), minimumClass, ((Predicate<Entity>)entity -> entity != origin).and(predicate));
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Level level, Vec3 origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getNearestEntity(level, AABB.ofSize((Vec3)origin, (double)radius, (double)radius, (double)radius), origin, minimumClass, predicate);
    }

    public static <T extends Entity> Optional<T> getNearestEntity(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getNearestEntity(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin, minimumClass, predicate);
    }

    @Nullable
    public static <T extends Entity> Optional<T> getNearestEntity(Level level, AABB bounds, Vec3 origin, Class<T> minimumClass, Predicate<T> predicate) {
        MutableDouble dist = new MutableDouble(Double.MAX_VALUE);
        MutableObject closest = new MutableObject(null);
        EntityTypeTest<Entity, T> typeTest = EntityRetrievalUtil.makeLazyTypeTest(minimumClass);
        level.getEntities().get(typeTest, bounds, entity -> {
            double entityDist;
            if (predicate.test(entity) && (entityDist = entity.distanceToSqr(origin)) < dist.doubleValue()) {
                dist.setValue(entityDist);
                closest.setValue(entity);
            }
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
        return Optional.ofNullable((Entity)closest.getValue());
    }

    public static <T extends Player> T getNearestPlayer(Entity origin, double radius) {
        return EntityRetrievalUtil.getNearestPlayer(origin, radius, radius, radius);
    }

    public static <T extends Player> T getNearestPlayer(Entity origin, double radiusX, double radiusY, double radiusZ) {
        return (T)EntityRetrievalUtil.getNearestPlayer(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), origin.position(), (Player entity) -> entity != origin);
    }

    public static <T extends Player> T getNearestPlayer(Level level, Vec3 origin, double radius) {
        return EntityRetrievalUtil.getNearestPlayer(level, origin, radius, radius, radius);
    }

    public static <T extends Player> T getNearestPlayer(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getNearestPlayer(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin);
    }

    public static <T extends Player> T getNearestPlayer(Level level, AABB area, Vec3 origin) {
        return (T)EntityRetrievalUtil.getNearestPlayer(level, area, origin, (Player pl) -> true);
    }

    public static Player getNearestPlayer(Entity origin, double radius, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin, radius, radius, radius, predicate);
    }

    public static Player getNearestPlayer(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), origin.position(), ((Predicate<Player>)entity -> entity != origin).and(predicate));
    }

    public static <T extends Player> T getNearestPlayer(Level level, Vec3 origin, double radius, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(level, origin, radius, radius, radius, predicate);
    }

    public static <T extends Player> T getNearestPlayer(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Predicate<Player> predicate) {
        return (T)EntityRetrievalUtil.getNearestPlayer(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin, predicate);
    }

    @Nullable
    public static Player getNearestPlayer(Level level, AABB bounds, Vec3 origin, Predicate<Player> predicate) {
        double dist = Double.MAX_VALUE;
        Player closest = null;
        for (Player player : level.players()) {
            double playerDist;
            if (!bounds.contains(player.position()) || !predicate.test(player) || !((playerDist = player.distanceToSqr(origin)) < dist)) continue;
            dist = playerDist;
            closest = player;
        }
        return closest;
    }

    public static List<Player> getPlayers(Entity origin, double radius) {
        return EntityRetrievalUtil.getPlayers(origin, radius, radius, radius);
    }

    public static List<Player> getPlayers(Entity origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getPlayers(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), (Player entity) -> entity != origin);
    }

    public static <T extends Player> List<T> getPlayers(Level level, Vec3 origin, double radius) {
        return EntityRetrievalUtil.getPlayers(level, origin, radius, radius, radius);
    }

    public static <T extends Player> List<T> getPlayers(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getPlayers(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ));
    }

    public static <T extends Player> List<T> getPlayers(Level level, Vec3 from, Vec3 to) {
        return EntityRetrievalUtil.getPlayers(level, new AABB(from, to));
    }

    public static List<Player> getPlayers(Level level, AABB area) {
        return EntityRetrievalUtil.getPlayers(level, area, (Player pl) -> true);
    }

    public static List<Player> getPlayers(Entity origin, double radius, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getPlayers(origin, radius, radius, radius, predicate);
    }

    public static List<Player> getPlayers(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getPlayers(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), ((Predicate<Player>)entity -> entity != origin).and(predicate));
    }

    public static <T extends Player> List<T> getPlayers(Level level, Vec3 origin, double radius, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getPlayers(level, origin, radius, radius, radius, predicate);
    }

    public static <T extends Player> List<T> getPlayers(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getPlayers(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), predicate);
    }

    public static <T extends Player> List<T> getPlayers(Level level, Vec3 from, Vec3 to, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getPlayers(level, new AABB(from, to), predicate);
    }

    public static List<Player> getPlayers(Level level, AABB bounds, Predicate<Player> predicate) {
        ObjectArrayList players = new ObjectArrayList();
        for (Player player : level.players()) {
            if (!bounds.contains(player.position()) || !predicate.test(player)) continue;
            players.add(player);
        }
        return players;
    }

    public static <T> List<T> getEntities(Entity origin, double radius) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius);
    }

    public static <T> List<T> getEntities(Entity origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getEntities(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), (? extends Entity entity) -> entity != origin);
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 origin, double radius) {
        return EntityRetrievalUtil.getEntities(level, AABB.ofSize((Vec3)origin, (double)radius, (double)radius, (double)radius));
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getEntities(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ));
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 from, Vec3 to) {
        return EntityRetrievalUtil.getEntities(level, new AABB(from, to));
    }

    public static <T extends Entity> List<T> getEntities(Level level, AABB area) {
        return EntityRetrievalUtil.getEntities(level, area, Entity.class);
    }

    public static <T extends Entity> List<T> getEntities(Entity origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius, minimumClass);
    }

    public static <T extends Entity> List<T> getEntities(Entity origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), minimumClass, (T entity) -> entity != origin);
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(level, AABB.ofSize((Vec3)origin, (double)radius, (double)radius, (double)radius), minimumClass);
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), minimumClass);
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 from, Vec3 to, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(level, new AABB(from, to), minimumClass);
    }

    public static <T extends Entity> List<T> getEntities(Level level, AABB bounds, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(level, bounds, minimumClass, (T entity) -> true);
    }

    public static <T> List<T> getEntities(Entity origin, double radius, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius, predicate);
    }

    public static <T> List<T> getEntities(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getEntities(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), ((Predicate<Entity>)entity -> entity != origin).and(predicate));
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 origin, double radius, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.getEntities(level, AABB.ofSize((Vec3)origin, (double)radius, (double)radius, (double)radius), predicate);
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.getEntities(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), predicate);
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 from, Vec3 to, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.getEntities(level, new AABB(from, to), predicate);
    }

    public static <T extends Entity> List<T> getEntities(Level level, AABB area, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getEntities(level, area, Entity.class, predicate);
    }

    public static <T extends Entity> List<T> getEntities(Entity origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius, minimumClass, predicate);
    }

    public static <T extends Entity> List<T> getEntities(Entity origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getEntities(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), minimumClass, ((Predicate<Entity>)entity -> entity != origin).and(predicate));
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getEntities(level, AABB.ofSize((Vec3)origin, (double)radius, (double)radius, (double)radius), minimumClass, predicate);
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getEntities(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), minimumClass, predicate);
    }

    public static <T extends Entity> List<T> getEntities(Level level, Vec3 from, Vec3 to, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getEntities(level, new AABB(from, to), minimumClass, predicate);
    }

    public static <T extends Entity> List<T> getEntities(Level level, AABB bounds, Class<T> minimumClass, Predicate<T> predicate) {
        ObjectArrayList foundEntities = new ObjectArrayList();
        EntityTypeTest<Entity, T> typeTest = EntityRetrievalUtil.makeLazyTypeTest(minimumClass);
        level.getEntities().get(typeTest, bounds, arg_0 -> EntityRetrievalUtil.lambda$getEntities$17(predicate, (List)foundEntities, arg_0));
        Pair<Collection<? extends Entity>, Function<Entity, ? extends Entity>> partEntities = SBLConstants.SBL_LOADER.getPartEntities(level);
        for (Entity part : (Collection)partEntities.getFirst()) {
            Entity entity = (Entity)typeTest.tryCast((Object)((Entity)((Function)partEntities.getSecond()).apply(part)));
            if (entity == null || !part.getBoundingBox().intersects(bounds) || !predicate.test(entity)) continue;
            foundEntities.add(entity);
        }
        return foundEntities;
    }

    public static <T extends Player> Optional<T> findPlayer(Entity origin, double radius, Predicate<Player> predicate) {
        return EntityRetrievalUtil.findPlayer(origin, radius, radius, radius, predicate);
    }

    public static <T extends Player> Optional<T> findPlayer(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<Player> predicate) {
        return EntityRetrievalUtil.findPlayer(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), ((Predicate<Player>)entity -> entity != origin).and(predicate));
    }

    public static <T extends Player> Optional<T> findPlayer(Level level, Vec3 origin, double radius, Predicate<Player> predicate) {
        return EntityRetrievalUtil.findPlayer(level, AABB.ofSize((Vec3)origin, (double)radius, (double)radius, (double)radius), predicate);
    }

    public static <T extends Player> Optional<T> findPlayer(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Predicate<Player> predicate) {
        return EntityRetrievalUtil.findPlayer(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), predicate);
    }

    public static <T extends Player> Optional<T> findPlayer(Level level, Vec3 from, Vec3 to, Predicate<Player> predicate) {
        return EntityRetrievalUtil.findPlayer(level, new AABB(from, to), predicate);
    }

    public static <T extends Player> Optional<T> findPlayer(Level level, AABB bounds, Predicate<Player> predicate) {
        for (Player player : level.players()) {
            if (!bounds.contains(player.position()) || !predicate.test(player)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public static <T extends Entity> Optional<T> findEntity(Entity origin, double radius, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.findEntity(origin, radius, radius, radius, predicate);
    }

    public static <T extends Entity> Optional<T> findEntity(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.findEntity(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), ((Predicate<Entity>)entity -> entity != origin).and(predicate));
    }

    public static <T extends Entity> Optional<T> findEntity(Level level, Vec3 origin, double radius, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.findEntity(level, AABB.ofSize((Vec3)origin, (double)radius, (double)radius, (double)radius), predicate);
    }

    public static <T extends Entity> Optional<T> findEntity(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.findEntity(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), predicate);
    }

    public static <T extends Entity> Optional<T> findEntity(Level level, Vec3 from, Vec3 to, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.findEntity(level, new AABB(from, to), predicate);
    }

    public static <T extends Entity> Optional<T> findEntity(Level level, AABB bounds, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.findEntity(level, bounds, Entity.class, predicate);
    }

    public static <T extends Entity> Optional<T> findEntity(Entity origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.findEntity(origin, radius, radius, radius, minimumClass, predicate);
    }

    public static <T extends Entity> Optional<T> findEntity(Entity origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.findEntity(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), minimumClass, ((Predicate<Entity>)entity -> entity != origin).and(predicate));
    }

    public static <T extends Entity> Optional<T> findEntity(Level level, Vec3 origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.findEntity(level, AABB.ofSize((Vec3)origin, (double)radius, (double)radius, (double)radius), minimumClass, predicate);
    }

    public static <T extends Entity> Optional<T> findEntity(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.findEntity(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), minimumClass, predicate);
    }

    public static <T extends Entity> Optional<T> findEntity(Level level, Vec3 from, Vec3 to, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.findEntity(level, new AABB(from, to), minimumClass, predicate);
    }

    public static <T extends Entity> Optional<T> findEntity(Level level, AABB bounds, Class<T> minimumClass, Predicate<T> predicate) {
        AtomicReference<Object> foundEntity = new AtomicReference<Object>(null);
        EntityTypeTest<Entity, T> typeTest = EntityRetrievalUtil.makeLazyTypeTest(minimumClass);
        level.getEntities().get(typeTest, bounds, entity -> {
            if (predicate.test((Entity)entity)) {
                foundEntity.set(entity);
                return AbortableIterationConsumer.Continuation.ABORT;
            }
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
        if (foundEntity.get() == null) {
            Pair<Collection<? extends Entity>, Function<Entity, ? extends Entity>> partEntities = SBLConstants.SBL_LOADER.getPartEntities(level);
            for (Entity part : (Collection)partEntities.getFirst()) {
                Entity entity2 = (Entity)typeTest.tryCast((Object)((Entity)((Function)partEntities.getSecond()).apply(part)));
                if (entity2 == null || !part.getBoundingBox().intersects(bounds) || !predicate.test(entity2)) continue;
                foundEntity.set(entity2);
                break;
            }
        }
        return Optional.ofNullable(foundEntity.get());
    }

    public static <T extends Entity> List<T> findEntities(Entity origin, double radius, int max, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.findEntities(origin, radius, radius, radius, max, predicate);
    }

    public static <T extends Entity> List<T> findEntities(Entity origin, double radiusX, double radiusY, double radiusZ, int max, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.findEntities(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), Entity.class, max, ((Predicate<Entity>)entity -> entity != origin).and(predicate));
    }

    public static <T extends Entity> List<T> findEntities(Level level, Vec3 origin, double radius, int max, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.findEntities(level, origin, radius, radius, radius, max, predicate);
    }

    public static <T extends Entity> List<T> findEntities(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, int max, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.findEntities(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), Entity.class, max, predicate);
    }

    public static <T extends Entity> List<T> findEntities(Level level, Vec3 from, Vec3 to, int max, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.findEntities(level, new AABB(from, to), Entity.class, max, predicate);
    }

    public static <T extends Entity> List<T> findEntities(Entity origin, double radius, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        return EntityRetrievalUtil.findEntities(origin, radius, radius, radius, minimumClass, max, predicate);
    }

    public static <T extends Entity> List<T> findEntities(Entity origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        return EntityRetrievalUtil.findEntities(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), minimumClass, max, ((Predicate<Entity>)entity -> entity != origin).and(predicate));
    }

    public static <T extends Entity> List<T> findEntities(Level level, Vec3 origin, double radius, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        return EntityRetrievalUtil.findEntities(level, AABB.ofSize((Vec3)origin, (double)radius, (double)radius, (double)radius), minimumClass, max, predicate);
    }

    public static <T extends Entity> List<T> findEntities(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        return EntityRetrievalUtil.findEntities(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), minimumClass, max, predicate);
    }

    public static <T extends Entity> List<T> findEntities(Level level, Vec3 from, Vec3 to, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        return EntityRetrievalUtil.findEntities(level, new AABB(from, to), minimumClass, max, predicate);
    }

    public static <T extends Entity> List<T> findEntities(Level level, AABB bounds, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        ObjectArrayList foundEntities = new ObjectArrayList(max);
        EntityTypeTest<Entity, T> typeTest = EntityRetrievalUtil.makeLazyTypeTest(minimumClass);
        level.getEntities().get(typeTest, bounds, arg_0 -> EntityRetrievalUtil.lambda$findEntities$24(predicate, (List)foundEntities, max, arg_0));
        if (foundEntities.size() < max) {
            Pair<Collection<? extends Entity>, Function<Entity, ? extends Entity>> partEntities = SBLConstants.SBL_LOADER.getPartEntities(level);
            for (Entity part : (Collection)partEntities.getFirst()) {
                Entity entity = (Entity)typeTest.tryCast((Object)((Entity)((Function)partEntities.getSecond()).apply(part)));
                if (entity == null || !part.getBoundingBox().intersects(bounds) || !predicate.test(entity)) continue;
                foundEntities.add(entity);
                if (foundEntities.size() < max) continue;
                break;
            }
        }
        return foundEntities;
    }

    public static Stream<Entity> streamEntities(Entity origin, double radius) {
        return EntityRetrievalUtil.streamEntities(origin, radius, radius, radius);
    }

    public static Stream<Entity> streamEntities(Entity origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.streamEntities(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), Entity.class);
    }

    public static Stream<Entity> streamEntities(Level level, Vec3 origin, double radius) {
        return EntityRetrievalUtil.streamEntities(level, origin, radius, radius, radius);
    }

    public static Stream<Entity> streamEntities(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.streamEntities(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), Entity.class);
    }

    public static Stream<Entity> streamEntities(Level level, Vec3 fromPos, Vec3 toPos) {
        return EntityRetrievalUtil.streamEntities(level, new AABB(fromPos, toPos), Entity.class);
    }

    public static <T extends Entity> Stream<T> streamEntities(Entity origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.streamEntities(origin, radius, radius, radius, minimumClass);
    }

    public static <T extends Entity> Stream<T> streamEntities(Entity origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.streamEntities(origin.level(), origin.getBoundingBox().inflate(radiusX, radiusY, radiusZ), minimumClass);
    }

    public static <T extends Entity> Stream<T> streamEntities(Level level, Vec3 origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.streamEntities(level, origin, radius, radius, radius, minimumClass);
    }

    public static <T extends Entity> Stream<T> streamEntities(Level level, Vec3 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.streamEntities(level, AABB.ofSize((Vec3)origin, (double)radiusX, (double)radiusY, (double)radiusZ), minimumClass);
    }

    public static <T extends Entity> Stream<T> streamEntities(Level level, Vec3 fromPos, Vec3 toPos, Class<T> minimumClass) {
        return EntityRetrievalUtil.streamEntities(level, new AABB(fromPos, toPos), minimumClass);
    }

    public static <T extends Entity> Stream<T> streamEntities(Level level, AABB bounds, Class<T> minimumClass) {
        level.getProfiler().incrementCounter("getEntities");
        LevelEntityGetter levelEntityGetter = level.getEntities();
        if (!(levelEntityGetter instanceof LevelEntityGetterAdapter)) {
            return (minimumClass == Entity.class ? EntityRetrievalUtil.getEntities(level, bounds, (? extends Entity entity) -> true) : EntityRetrievalUtil.getEntities(level, bounds, minimumClass, (T entity) -> true)).stream();
        }
        LevelEntityGetterAdapter entities = (LevelEntityGetterAdapter)levelEntityGetter;
        EntitySectionStorage entitySectionStorage = entities.sectionStorage;
        EntityTypeTest clazzLookup = EntityRetrievalUtil.makeLazyTypeTest(minimumClass);
        int minSectionX = SectionPos.posToSectionCoord((double)(bounds.minX - 2.0));
        int minSectionY = SectionPos.posToSectionCoord((double)(bounds.minY - 4.0));
        int minSectionZ = SectionPos.posToSectionCoord((double)(bounds.minZ - 2.0));
        int maxSectionX = SectionPos.posToSectionCoord((double)(bounds.maxX + 2.0));
        int maxSectionY = SectionPos.posToSectionCoord((double)bounds.maxY);
        int maxSectionZ = SectionPos.posToSectionCoord((double)(bounds.maxZ + 2.0));
        Pair<Collection<? extends Entity>, Function<Entity, ? extends Entity>> partEntities = SBLConstants.SBL_LOADER.getPartEntities(level);
        Stream<Entity> stream = IntStream.rangeClosed(minSectionX, maxSectionX).mapToObj(sectionX -> entitySectionStorage.sectionIds.subSet(SectionPos.asLong((int)sectionX, (int)0, (int)0), SectionPos.asLong((int)sectionX, (int)-1, (int)-1)).iterator()).mapMulti((iterator, consumer) -> consumer.accept(iterator.nextLong())).filter(sectionId -> {
            int sectionYPos = SectionPos.y((long)sectionId);
            if (sectionYPos < minSectionY || sectionYPos > maxSectionY) {
                return false;
            }
            int sectionZPos = SectionPos.z((long)sectionId);
            return sectionZPos >= minSectionZ && sectionZPos <= maxSectionZ;
        }).map(arg_0 -> ((EntitySectionStorage)entitySectionStorage).getSection(arg_0)).filter(section -> section != null && !section.isEmpty() && section.getStatus().isAccessible()).map(section -> section.storage.find(clazzLookup.getBaseClass())).filter(collection -> !collection.isEmpty()).mapMulti(Iterable::forEach).map(arg_0 -> clazzLookup.tryCast(arg_0)).filter(entity -> entity != null && entity.getBoundingBox().intersects(bounds));
        return ((Collection)partEntities.getFirst()).isEmpty() ? stream : Stream.concat(stream, ((Collection)partEntities.getFirst()).stream().map(entity -> Pair.of((Object)entity, (Object)((Entity)clazzLookup.tryCast((Object)((Entity)((Function)partEntities.getSecond()).apply(entity)))))).filter(entity -> ((Entity)entity.getFirst()).getBoundingBox().intersects(bounds)).map(Pair::getSecond));
    }

    @ApiStatus.Internal
    private static <T extends Entity> EntityTypeTest<Entity, T> makeLazyTypeTest(Class<T> forClass) {
        if (forClass != Entity.class) {
            return EntityTypeTest.forClass(forClass);
        }
        return new EntityTypeTest<Entity, Entity>(){

            @Nullable
            public Entity tryCast(Entity entity) {
                return entity;
            }

            public Class<? extends Entity> getBaseClass() {
                return Entity.class;
            }
        };
    }

    private static /* synthetic */ AbortableIterationConsumer.Continuation lambda$findEntities$24(Predicate predicate, List foundEntities, int max, Entity entity) {
        if (predicate.test(entity)) {
            foundEntities.add(entity);
            if (foundEntities.size() >= max) {
                return AbortableIterationConsumer.Continuation.ABORT;
            }
        }
        return AbortableIterationConsumer.Continuation.CONTINUE;
    }

    private static /* synthetic */ AbortableIterationConsumer.Continuation lambda$getEntities$17(Predicate predicate, List foundEntities, Entity entity) {
        if (predicate.test(entity)) {
            foundEntities.add(entity);
        }
        return AbortableIterationConsumer.Continuation.CONTINUE;
    }
}

