/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;

public class FollowEntity<E extends PathfinderMob, T extends Entity>
extends ExtendedBehaviour<E> {
    protected Function<E, T> followingEntityProvider = entity -> null;
    protected BiFunction<E, T, Double> teleportDistance = (entity, target) -> Double.MAX_VALUE;
    protected BiFunction<E, T, Double> followDistMin = (entity, target) -> 4.0;
    protected BiFunction<E, T, Float> speedMod = (entity, target) -> Float.valueOf(1.0f);
    protected float oldWaterPathMalus = 0.0f;
    protected float oldLavaPathMalus = 0.0f;

    public FollowEntity<E, T> following(Function<E, T> following) {
        this.followingEntityProvider = following;
        return this;
    }

    public FollowEntity<E, T> teleportToTargetAfter(double distance) {
        return this.teleportToTargetAfter((entity, target) -> distance);
    }

    public FollowEntity<E, T> teleportToTargetAfter(BiFunction<E, T, Double> distanceProvider) {
        this.teleportDistance = distanceProvider;
        return this;
    }

    public FollowEntity<E, T> stopFollowingWithin(double distance) {
        return this.stopFollowingWithin((entity, target) -> distance);
    }

    public FollowEntity<E, T> stopFollowingWithin(BiFunction<E, T, Double> distanceProvider) {
        this.followDistMin = distanceProvider;
        return this;
    }

    public FollowEntity<E, T> speedMod(float modifier) {
        return this.speedMod((entity, target) -> Float.valueOf(modifier));
    }

    public FollowEntity<E, T> speedMod(BiFunction<E, T, Float> modifier) {
        this.speedMod = modifier;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of();
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        if (target == null || target.isSpectator()) {
            return false;
        }
        double minDist = this.followDistMin.apply(entity, target);
        return entity.distanceToSqr(target) > minDist * minDist;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        double minDist;
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        if (target == null) {
            return false;
        }
        double dist = entity.distanceToSqr(target);
        return dist > (minDist = this.followDistMin.apply(entity, target).doubleValue()) * minDist;
    }

    @Override
    protected void start(E entity) {
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        double minDist = this.followDistMin.apply(entity, target);
        float speedMod = this.speedMod.apply(entity, target).floatValue();
        this.oldWaterPathMalus = entity.getPathfindingMalus(PathType.WATER);
        if (entity.fireImmune()) {
            this.oldLavaPathMalus = entity.getPathfindingMalus(PathType.LAVA);
            entity.setPathfindingMalus(PathType.LAVA, 0.0f);
        }
        BrainUtils.setMemory(entity, MemoryModuleType.WALK_TARGET, new WalkTarget(target, speedMod, (int)minDist));
        BrainUtils.setMemory(entity, MemoryModuleType.LOOK_TARGET, new EntityTracker(target, true));
        entity.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    @Override
    protected void stop(E entity) {
        entity.setPathfindingMalus(PathType.WATER, this.oldWaterPathMalus);
        if (entity.fireImmune()) {
            entity.setPathfindingMalus(PathType.LAVA, this.oldLavaPathMalus);
        }
        entity.getNavigation().stop();
        BrainUtils.clearMemory(entity, MemoryModuleType.WALK_TARGET);
    }

    @Override
    protected void tick(E entity) {
        Entity target = (Entity)this.followingEntityProvider.apply(entity);
        double teleportDist = this.teleportDistance.apply(entity, target);
        if (entity.distanceToSqr(target) >= teleportDist * teleportDist) {
            this.teleportToTarget(entity, target);
        }
    }

    protected void teleportToTarget(E entity, T target) {
        Level level = entity.level();
        BlockPos entityPos = target.blockPosition();
        BlockPos pos = RandomUtil.getRandomPositionWithinRange(entityPos, 5, 5, 5, 1, 1, 1, true, level, 10, (state, statePos) -> {
            PathType pathTypes = entity.getNavigation().getNodeEvaluator().getPathType(new PathfindingContext((CollisionGetter)level, (Mob)entity), statePos.getX(), statePos.getY(), statePos.getZ());
            if (pathTypes != PathType.WALKABLE) {
                return false;
            }
            return level.noCollision((Entity)entity, entity.getBoundingBox().move(Vec3.atBottomCenterOf((Vec3i)statePos).subtract(entity.position())));
        });
        if (pos != entityPos) {
            entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, entity.getYRot(), entity.getXRot());
            entity.getNavigation().stop();
            BrainUtils.clearMemory(entity, MemoryModuleType.WALK_TARGET);
        }
    }
}

