/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.attack;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.SensoryUtils;

public class LeapAtTarget<E extends Mob>
extends AnimatableMeleeAttack<E> {
    protected BiFunction<E, LivingEntity, Float> verticalJumpStrength = (entity, target) -> Float.valueOf(0.3f);
    protected BiFunction<E, LivingEntity, Float> jumpStrength = (entity, target) -> Float.valueOf(0.4f);
    protected BiFunction<E, LivingEntity, Float> moveSpeedContribution = (entity, target) -> Float.valueOf(0.2f);
    protected BiPredicate<E, LivingEntity> leapPredicate = (entity, target) -> entity.onGround() && SensoryUtils.hasLineOfSight((LivingEntity)entity, (Entity)target) && entity.distanceToSqr((Entity)target) < 64.0;

    public LeapAtTarget(int delayTicks) {
        super(delayTicks);
    }

    public LeapAtTarget<E> leapIf(BiPredicate<E, LivingEntity> predicate) {
        this.leapPredicate = predicate;
        return this;
    }

    public LeapAtTarget<E> jumpStrength(BiFunction<E, LivingEntity, Float> function) {
        this.jumpStrength = function;
        return this;
    }

    public LeapAtTarget<E> verticalJumpStrength(BiFunction<E, LivingEntity, Float> function) {
        this.verticalJumpStrength = function;
        return this;
    }

    public LeapAtTarget<E> moveSpeedContribution(BiFunction<E, LivingEntity, Float> function) {
        this.moveSpeedContribution = function;
        return this;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return this.leapPredicate.test(entity, BrainUtils.getTargetOfEntity(entity));
    }

    @Override
    protected void start(E entity) {
        super.start(entity);
        Vec3 velocity = new Vec3(this.target.getX() - entity.getX(), 0.0, this.target.getZ() - entity.getZ());
        if (velocity.lengthSqr() > 1.0E-7) {
            velocity = velocity.normalize().scale((double)this.jumpStrength.apply(entity, this.target).floatValue()).add(entity.getDeltaMovement().scale((double)this.moveSpeedContribution.apply(entity, this.target).floatValue()));
        }
        entity.setDeltaMovement(velocity.x, (double)this.verticalJumpStrength.apply(entity, this.target).floatValue(), velocity.z);
    }
}

