/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.ClientTaskQueue;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColor;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColors;
import dev.ftb.mods.ftbchunks.core.BiomeFTBC;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class MapManager
implements MapTask {
    public static final long MEMORY_PER_REGION = 0x400000L;
    private static MapManager instance;
    public final Object lock = new Object();
    private boolean invalid;
    private final UUID serverId;
    private final Path directory;
    private final Map<ResourceKey<Level>, MapDimension> dimensions;
    private boolean needsSave;
    private MapDimension pendingRegionPurge = null;
    private final Int2ObjectOpenHashMap<ResourceLocation> blockColorIndexMap;
    private final Object2IntOpenHashMap<ResourceLocation> blockColorIndexMapReverse;
    private final Int2ObjectOpenHashMap<ResourceKey<Biome>> biomeColorIndexMap;
    private final Int2ObjectOpenHashMap<BlockColor> blockIdToColCache;
    private final List<BiomeFTBC> biomesToRelease;

    private MapManager(UUID serverId, Path directory) {
        this.serverId = serverId;
        this.directory = directory;
        this.invalid = false;
        this.dimensions = new LinkedHashMap<ResourceKey<Level>, MapDimension>();
        this.needsSave = false;
        this.blockColorIndexMap = new Int2ObjectOpenHashMap();
        this.blockColorIndexMap.defaultReturnValue((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"air"));
        this.blockColorIndexMapReverse = new Object2IntOpenHashMap();
        this.blockColorIndexMapReverse.defaultReturnValue(0);
        this.biomeColorIndexMap = new Int2ObjectOpenHashMap();
        this.biomeColorIndexMap.defaultReturnValue((Object)Biomes.PLAINS);
        this.blockIdToColCache = new Int2ObjectOpenHashMap();
        this.biomesToRelease = new ArrayList<BiomeFTBC>();
        try {
            Path path;
            Path blockFile;
            Path dimFile = this.directory.resolve("dimensions.txt");
            if (Files.exists(dimFile, new LinkOption[0])) {
                for (String string : Files.readAllLines(dimFile)) {
                    String string2 = string.trim();
                    if (string2.length() < 3) continue;
                    ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryParse((String)string2));
                    this.dimensions.put((ResourceKey<Level>)key, new MapDimension(this, (ResourceKey<Level>)key, directory));
                }
            } else {
                this.needsSave = true;
            }
            if (Files.exists(blockFile = this.directory.resolve("block_map.txt"), new LinkOption[0])) {
                for (String s : Files.readAllLines(blockFile)) {
                    if ((s = s.trim()).isEmpty()) continue;
                    String[] s1 = s.split(" ", 2);
                    int i = Integer.decode(s1[0]);
                    ResourceLocation loc = ResourceLocation.tryParse((String)s1[1]);
                    this.blockColorIndexMap.put(i, (Object)loc);
                    this.blockColorIndexMapReverse.put((Object)loc, i);
                }
            } else {
                this.needsSave = true;
            }
            if (Files.exists(path = this.directory.resolve("biome_map.txt"), new LinkOption[0])) {
                for (String s : Files.readAllLines(path)) {
                    if ((s = s.trim()).isEmpty()) continue;
                    String[] s1 = s.split(" ", 2);
                    int i = Integer.decode(s1[0]);
                    ResourceLocation loc = ResourceLocation.tryParse((String)s1[1]);
                    ResourceKey key = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)loc);
                    this.biomeColorIndexMap.put(i, (Object)key);
                }
            } else {
                this.needsSave = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Optional<MapManager> getInstance() {
        return Optional.ofNullable(instance);
    }

    public static void startUp(UUID serverId) {
        MapManager.shutdown();
        Path dir = Platform.getGameFolder().resolve("local/ftbchunks/data/" + String.valueOf(serverId));
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        instance = new MapManager(serverId, dir);
    }

    public static void shutdown() {
        if (instance != null) {
            instance.saveAllRegions();
            instance.release();
            ClientTaskQueue.flushTasks();
            MapDimension.clearCurrentDimension();
            instance = null;
        }
    }

    public UUID getServerId() {
        return this.serverId;
    }

    public void saveAllRegions() {
        if (instance == null) {
            return;
        }
        for (MapDimension dimension : instance.getDimensions().values()) {
            dimension.getLoadedRegions().forEach(MapRegion::saveIfChanged);
            dimension.saveIfChanged();
        }
        if (MapManager.instance.needsSave) {
            ClientTaskQueue.queue(instance);
            MapManager.instance.needsSave = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ResourceKey<Level>, MapDimension> getDimensions() {
        Object object = this.lock;
        synchronized (object) {
            return this.dimensions;
        }
    }

    @NotNull
    public synchronized MapDimension getDimension(ResourceKey<Level> dim) {
        return this.getDimensions().computeIfAbsent(dim, dimKey -> {
            this.needsSave = true;
            return new MapDimension(this, (ResourceKey<Level>)dimKey, this.directory);
        });
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void release() {
        for (MapDimension dimension : this.getDimensions().values()) {
            dimension.release();
        }
        for (BiomeFTBC b : this.biomesToRelease) {
            b.setFTBCBiomeColorIndex(-1);
        }
        this.biomesToRelease.clear();
        this.blockIdToColCache.clear();
        this.invalid = true;
    }

    public void updateAllRegions(boolean save) {
        for (MapDimension dimension : this.getDimensions().values()) {
            for (MapRegion region : dimension.getRegions().values()) {
                region.update(save);
            }
        }
        FTBChunksClient.INSTANCE.scheduleMinimapUpdate();
    }

    @Override
    public void runMapTask() throws Exception {
        List dimensionsList = this.dimensions.keySet().stream().map(key -> key.location().toString()).collect(Collectors.toList());
        List blockColorIndexMapList = this.blockColorIndexMap.int2ObjectEntrySet().stream().sorted(Map.Entry.comparingByValue()).map(key -> String.format("#%06X %s", key.getIntKey(), key.getValue())).collect(Collectors.toList());
        List biomeColorIndexMapList = this.biomeColorIndexMap.int2ObjectEntrySet().stream().sorted(Comparator.comparing(o -> ((ResourceKey)o.getValue()).location())).map(key -> String.format("#%03X %s", key.getIntKey(), ((ResourceKey)key.getValue()).location())).collect(Collectors.toList());
        FTBChunks.EXECUTOR.execute(() -> {
            try {
                Files.write(this.directory.resolve("dimensions.txt"), (Iterable<? extends CharSequence>)dimensionsList, new OpenOption[0]);
                Files.write(this.directory.resolve("block_map.txt"), (Iterable<? extends CharSequence>)blockColorIndexMapList, new OpenOption[0]);
                Files.write(this.directory.resolve("biome_map.txt"), (Iterable<? extends CharSequence>)biomeColorIndexMapList, new OpenOption[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    public int getBlockColorIndex(ResourceLocation id) {
        int i = this.blockColorIndexMapReverse.getInt((Object)id);
        if (i == 0) {
            Random random = new Random((long)id.getNamespace().hashCode() & 0xFFFFFFFFL | ((long)id.getPath().hashCode() & 0xFFFFFFFFL) << 32);
            i = id.hashCode() & 0xFFFFFF;
            while (i == 0 || this.blockColorIndexMap.containsKey(i)) {
                i = random.nextInt() & 0xFFFFFF;
            }
            this.blockColorIndexMap.put(i, (Object)id);
            this.blockColorIndexMapReverse.put((Object)id, i);
            this.needsSave = true;
        }
        return i;
    }

    public int getBiomeColorIndex(Registry<Biome> biomes, Biome biome, Object b0) {
        BiomeFTBC b;
        BiomeFTBC biomeFTBC = b = b0 instanceof BiomeFTBC ? (BiomeFTBC)b0 : null;
        if (b == null) {
            return 0;
        }
        int i = b.getFTBCBiomeColorIndex();
        if (i == -1) {
            ResourceKey key = biomes.getResourceKey((Object)biome).orElse(null);
            if (key == null) {
                b.setFTBCBiomeColorIndex(0);
                return 0;
            }
            for (Int2ObjectMap.Entry entry : this.biomeColorIndexMap.int2ObjectEntrySet()) {
                if (entry.getValue() != key) continue;
                i = entry.getIntKey();
                b.setFTBCBiomeColorIndex(i);
                return i;
            }
            Random random = new Random((long)key.location().getNamespace().hashCode() & 0xFFFFFFFFL | ((long)key.location().getPath().hashCode() & 0xFFFFFFFFL) << 32);
            i = key.location().hashCode() & 0x7FF;
            while (i == 0 || this.biomeColorIndexMap.containsKey(i)) {
                i = random.nextInt() & 0x7FF;
            }
            this.biomeColorIndexMap.put(i, (Object)key);
            b.setFTBCBiomeColorIndex(i);
            this.needsSave = true;
            this.biomesToRelease.add(b);
        }
        return i;
    }

    public Block getBlock(int id) {
        ResourceLocation rl = (ResourceLocation)this.blockColorIndexMap.get(id & 0xFFFFFF);
        Block block = rl == null ? null : (Block)FTBChunks.BLOCK_REGISTRY.get(rl);
        return block == null ? Blocks.AIR : block;
    }

    public BlockColor getBlockColor(int id) {
        try {
            return (BlockColor)this.blockIdToColCache.computeIfAbsent(id & 0xFFFFFF, i -> ColorMapLoader.getBlockColor((ResourceLocation)this.blockColorIndexMap.get(i)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return BlockColors.ERROR;
        }
    }

    public ResourceKey<Biome> getBiomeKey(int id) {
        return (ResourceKey)this.biomeColorIndexMap.get(id & 0x7FF);
    }

    public void releaseStaleRegionData(long releaseIntervalMillis) {
        long now = System.currentTimeMillis();
        this.dimensions.values().forEach(dim -> dim.releaseStaleRegionData(now, releaseIntervalMillis));
    }

    public long estimateMemoryUsage() {
        long memory = 0L;
        for (MapDimension dim : this.dimensions.values()) {
            memory += dim.getLoadedRegions().stream().filter(MapRegion::isDataLoaded).mapToLong(region -> 0x400000L).sum();
        }
        return memory;
    }

    public void scheduleRegionPurge(MapDimension toPurge) {
        this.pendingRegionPurge = toPurge;
    }

    public void checkForRegionPurge() {
        if (this.pendingRegionPurge != null) {
            int autoRelease = (Integer)FTBChunksClientConfig.AUTORELEASE_ON_MAP_CLOSE.get();
            List<MapRegion> dataLoadedRegions = this.pendingRegionPurge.getLoadedRegions().stream().filter(MapRegion::isDataLoaded).toList();
            long nLoaded = dataLoadedRegions.size();
            if (nLoaded > (long)(autoRelease = Math.max(4, autoRelease))) {
                dataLoadedRegions.stream().sorted(Comparator.comparingLong(MapRegion::getLastDataAccess)).limit(nLoaded - (long)autoRelease).forEach(r -> r.release(false));
            }
            this.pendingRegionPurge = null;
        }
    }
}

