/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import java.util.Arrays;
import net.minecraft.util.StringRepresentable;

public enum BiomeBlendMode implements StringRepresentable
{
    NONE("none", 0, "O"),
    BLEND_3X3("blend_3x3", 1, "OOO", "OOO", "OOO"),
    BLEND_5X5("blend_5x5", 2, " OOO ", "OOOOO", "OOOOO", "OOOOO", " OOO "),
    BLEND_7X7("blend_7x7", 3, "   O   ", " OOOOO ", " OOOOO ", "OOOOOOO", " OOOOO ", " OOOOO ", "   O   "),
    BLEND_9X9("blend_9x9", 4, "   OOO   ", " OOOOOOO ", " OOOOOOO ", "OOOOOOOOO", "OOOOOOOOO", "OOOOOOOOO", " OOOOOOO ", " OOOOOOO ", "   OOO   "),
    BLEND_11X11("blend_11x11", 5, "   OOOOO   ", " OOOOOOOOO ", " OOOOOOOOO ", "OOOOOOOOOOO", "OOOOOOOOOOO", "OOOOOOOOOOO", "OOOOOOOOOOO", "OOOOOOOOOOO", " OOOOOOOOO ", " OOOOOOOOO ", "   OOOOO   "),
    BLEND_13X13("blend_13x13", 6, "    OOOOO    ", "  OOOOOOOOO  ", " OOOOOOOOOOO ", " OOOOOOOOOOO ", "OOOOOOOOOOOOO", "OOOOOOOOOOOOO", "OOOOOOOOOOOOO", "OOOOOOOOOOOOO", "OOOOOOOOOOOOO", " OOOOOOOOOOO ", " OOOOOOOOOOO ", "  OOOOOOOOO  ", "    OOOOO    "),
    BLEND_15X15("blend_15x15", 7, "    OOOOOOO    ", "  OOOOOOOOOOO  ", " OOOOOOOOOOOOO ", " OOOOOOOOOOOOO ", "OOOOOOOOOOOOOOO", "OOOOOOOOOOOOOOO", "OOOOOOOOOOOOOOO", "OOOOOOOOOOOOOOO", "OOOOOOOOOOOOOOO", "OOOOOOOOOOOOOOO", "OOOOOOOOOOOOOOO", " OOOOOOOOOOOOO ", " OOOOOOOOOOOOO ", "  OOOOOOOOOOO  ", "    OOOOOOO    ");

    public static final NameMap<BiomeBlendMode> NAME_MAP;
    private final String name;
    private final int blendRadius;
    private final int[] posX;
    private final int[] posY;
    private final int size;

    private BiomeBlendMode(String name, int blendRadius, String ... roundPattern) {
        this.name = name;
        this.blendRadius = blendRadius;
        this.size = (this.blendRadius * 2 + 1) * (this.blendRadius * 2 + 1);
        int[] posX0 = new int[this.size];
        int[] posY0 = new int[this.size];
        int n2 = 0;
        for (int y = 0; y < this.blendRadius * 2 + 1; ++y) {
            for (int x = 0; x < this.blendRadius * 2 + 1; ++x) {
                if (roundPattern[y].charAt(x) == ' ') continue;
                posX0[n2] = x - this.blendRadius;
                posY0[n2] = y - this.blendRadius;
                ++n2;
            }
        }
        this.posX = Arrays.copyOf(posX0, this.size);
        this.posY = Arrays.copyOf(posY0, this.size);
    }

    public int getBlendRadius() {
        return this.blendRadius;
    }

    public Color4I doBlending(int[][] colors, int ax, int az) {
        if (this.blendRadius == 0) {
            return Color4I.rgb((int)colors[ax][az]);
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int nColors = 0;
        for (int i = 0; i < this.size; ++i) {
            int col = colors[ax + this.blendRadius + this.posX[i]][az + this.blendRadius + this.posY[i]];
            if (col == 0) continue;
            r += col >> 16 & 0xFF;
            g += col >> 8 & 0xFF;
            b += col & 0xFF;
            ++nColors;
        }
        return nColors == 0 ? Color4I.rgb((int)colors[ax + this.blendRadius][az + this.blendRadius]) : Color4I.rgb((int)(r / nColors), (int)(g / nColors), (int)(b / nColors));
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        NAME_MAP = NameMap.of((Object)((Object)BLEND_5X5), (Object[])BiomeBlendMode.values()).baseNameKey("ftbchunks.biome_blend").create();
    }
}

