/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.gui.ChunkScreenPanel;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.ToggleableButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractThreePanelScreen;
import dev.ftb.mods.ftblibrary.ui.misc.KeyReferenceScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbteams.api.Team;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class ChunkScreen
extends AbstractThreePanelScreen<ChunkScreenPanel> {
    private final MapDimension dimension;
    private final Team openedAs;
    private ChunkScreenPanel chunkScreenPanel;
    private SimpleButton largeMapButton;

    private ChunkScreen(MapDimension dimension, Team openedAs) {
        this.dimension = dimension;
        this.openedAs = openedAs;
        this.showCloseButton(true);
        this.showScrollBar(false);
    }

    protected Panel createBottomPanel() {
        return new CustomBottomPanel();
    }

    protected int getScrollbarWidth() {
        return -1;
    }

    public boolean onInit() {
        int size = (int)((float)this.getScreen().getGuiScaledHeight() * 0.85f);
        this.setWidth(Math.min(size + 2, this.getScreen().getGuiScaledWidth() - 2));
        this.setHeight(Math.min(size + this.getTopPanelHeight() + this.getBottomPanelHeight(), this.getScreen().getGuiScaledHeight() - 2));
        return true;
    }

    public void addWidgets() {
        super.addWidgets();
        this.largeMapButton = new SimpleButton((Panel)this, (Component)Component.translatable((String)"ftbchunks.gui.large_map"), Icons.MAP, (simpleButton, mouseButton) -> LargeMapScreen.openMap());
        this.add((Widget)this.largeMapButton);
    }

    public void alignWidgets() {
        super.alignWidgets();
        this.largeMapButton.setPosAndSize(-this.getX() + 2, -this.getY() + 2, 16, 16);
    }

    public static void openChunkScreen(@Nullable Team openedAs) {
        MapDimension.getCurrent().ifPresentOrElse(mapDimension -> new ChunkScreen((MapDimension)mapDimension, openedAs).openGui(), () -> FTBChunks.LOGGER.warn("MapDimension data missing?? not opening chunk screen"));
    }

    public static void openChunkScreen() {
        ChunkScreen.openChunkScreen(null);
    }

    public ChunkScreenPanel getChunkScreen() {
        return this.chunkScreenPanel;
    }

    protected void doCancel() {
        this.closeGui();
    }

    protected void doAccept() {
    }

    protected int getTopPanelHeight() {
        return 16;
    }

    protected int getBottomPanelHeight() {
        return this.openedAs == null ? super.getBottomPanelHeight() - 8 : super.getBottomPanelHeight();
    }

    protected ChunkScreenPanel createMainPanel() {
        this.chunkScreenPanel = new ChunkScreenPanel(this);
        return this.chunkScreenPanel;
    }

    protected Panel createTopPanel() {
        return new CustomTopPanel();
    }

    public Team getOpenedAs() {
        return this.openedAs;
    }

    public MapDimension getDimension() {
        return this.dimension;
    }

    private class CustomBottomPanel
    extends Panel {
        public CustomBottomPanel() {
            super((Panel)ChunkScreen.this);
        }

        public void addWidgets() {
        }

        public void alignWidgets() {
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawPanelBackground(graphics, x, y, w, h);
            Color4I.GRAY.withAlpha(64).draw(graphics, x, y, w, 1);
            SendGeneralDataPacket.GeneralChunkData generalChunkData = FTBChunksClient.INSTANCE.getGeneralChunkData();
            int claimed = generalChunkData.claimed();
            int maxClaim = generalChunkData.maxClaimChunks();
            MutableComponent claimedComponent = Component.translatable((String)"ftbchunks.gui.claimed").append((Component)Component.literal((String)": ").append((Component)Component.literal((String)(claimed + " / " + maxClaim)).withStyle(claimed > maxClaim ? ChatFormatting.RED : (claimed == maxClaim ? ChatFormatting.YELLOW : ChatFormatting.GREEN))));
            theme.drawString(graphics, (Object)claimedComponent, x + 4, y + 4);
            int loaded = generalChunkData.loaded();
            int maxLoaded = generalChunkData.maxForceLoadChunks();
            MutableComponent forceLoadComponent = Component.translatable((String)"ftbchunks.gui.force_loaded").append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)(loaded + " / " + maxLoaded)).withStyle(loaded > maxLoaded ? ChatFormatting.RED : (loaded == maxLoaded ? ChatFormatting.YELLOW : ChatFormatting.GREEN)));
            String forceLoadText = forceLoadComponent.getString();
            int forceLoadX = x + w - theme.getStringWidth(forceLoadText) - 2;
            theme.drawString(graphics, (Object)forceLoadComponent, forceLoadX, y + 4);
            if (ChunkScreen.this.openedAs != null) {
                String openAsMessage = Component.translatable((String)"ftbchunks.gui.opened_as", (Object[])new Object[]{ChunkScreen.this.openedAs.getName()}).getString();
                int openAsX = x + w - theme.getStringWidth(openAsMessage) - 2;
                theme.drawString(graphics, (Object)openAsMessage, openAsX, y + h - theme.getFontHeight(), Color4I.WHITE, 2);
            }
        }
    }

    protected class CustomTopPanel
    extends Panel {
        private final Button closeButton;
        private final Button removeAllClaims;
        private final Button adminButton;
        private final Button mouseReferenceButton;

        public CustomTopPanel() {
            super((Panel)ChunkScreen.this);
            this.closeButton = new SimpleButton((Panel)this, (Component)Component.translatable((String)"gui.close"), Icons.CLOSE, (btn, mb) -> ChunkScreen.this.doCancel()).setForceButtonSize(false);
            this.mouseReferenceButton = new SimpleButton((Panel)this, (Component)Component.translatable((String)"ftbchunks.gui.chunk_info"), Icons.INFO, (btn, mb) -> new ChunkMouseReferenceScreen().openGui()).setForceButtonSize(false);
            this.removeAllClaims = new SimpleButton((Panel)this, (Component)Component.translatable((String)"ftbchunks.gui.unclaim_all"), Icons.BIN, (btn, mb) -> {
                if (CustomTopPanel.isShiftKeyDown()) {
                    ChunkScreen.this.chunkScreenPanel.removeAllClaims();
                } else {
                    this.getGui().openYesNo((Component)Component.translatable((String)"ftbchunks.gui.unclaim_all"), (Component)Component.translatable((String)"ftbchunks.gui.unclaim_all.description"), () -> ChunkScreen.this.chunkScreenPanel.removeAllClaims());
                }
            }).setForceButtonSize(false);
            this.adminButton = new AdminButton(this).setForceButtonSize(false);
        }

        public void addWidgets() {
            this.add((Widget)this.closeButton);
            this.add((Widget)this.removeAllClaims);
            if (!Minecraft.getInstance().isSingleplayer() && ChunkScreen.this.openedAs == null && Minecraft.getInstance().player.hasPermissions(2)) {
                this.add((Widget)this.adminButton);
            }
            this.add((Widget)this.mouseReferenceButton);
        }

        public void alignWidgets() {
            this.removeAllClaims.setPosAndSize(2, 2, 12, 12);
            this.adminButton.setPosAndSize(18, 1, 12, 12);
            this.closeButton.setPosAndSize(this.width - 16, 2, 12, 12);
            this.mouseReferenceButton.setPosAndSize(this.width - 32, 2, 12, 12);
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawPanelBackground(graphics, x, y, w, h);
            Color4I.BLACK.withAlpha(80).draw(graphics, x, y + h - 1, w, 1);
        }

        private class AdminButton
        extends ToggleableButton {
            private static final Component DISABLED = Component.translatable((String)"ftbchunks.gui.admin_mode_disabled");
            private static final Component ENABLED = Component.translatable((String)"ftbchunks.gui.admin_mode_enabled");
            private static final Component MORE_INFO = Component.translatable((String)"ftbchunks.gui.admin_mode_info").withStyle(ChatFormatting.GRAY);

            public AdminButton(CustomTopPanel customTopPanel) {
                super((Panel)customTopPanel, false, Icons.LOCK_OPEN, Icons.LOCK, (btn, newState) -> {
                    dev$ftb$mods$ftbchunks$client$gui$ChunkScreen$this.getChunkScreen().isAdminEnabled = newState;
                });
                this.setEnabledText(ENABLED);
                this.setDisabledText(DISABLED);
            }

            public void addMouseOverText(TooltipList list) {
                super.addMouseOverText(list);
                list.add(MORE_INFO);
            }
        }
    }

    private static class ChunkMouseReferenceScreen
    extends KeyReferenceScreen {
        public ChunkMouseReferenceScreen() {
            super(new String[]{"ftbchunks.gui.chunk_info.text"});
        }

        public Component getTitle() {
            return Component.translatable((String)"ftbchunks.gui.chunk_info");
        }
    }
}

