/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.client.FTBChunksClientAPI;
import dev.ftb.mods.ftbchunks.api.client.event.MapIconEvent;
import dev.ftb.mods.ftbchunks.api.client.icon.MapIcon;
import dev.ftb.mods.ftbchunks.api.client.icon.MapType;
import dev.ftb.mods.ftbchunks.api.client.icon.WaypointIcon;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapContext;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapInfoComponent;
import dev.ftb.mods.ftbchunks.api.client.waypoint.Waypoint;
import dev.ftb.mods.ftbchunks.client.ClientTaskQueue;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientAPIImpl;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.MinimapBlurMode;
import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.VisibleClientPlayers;
import dev.ftb.mods.ftbchunks.client.gui.AddWaypointOverlay;
import dev.ftb.mods.ftbchunks.client.gui.ChunkScreen;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.gui.PointerIcon;
import dev.ftb.mods.ftbchunks.client.gui.WaypointEditorScreen;
import dev.ftb.mods.ftbchunks.client.map.ChunkUpdateTask;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.UpdateChunkFromServerTask;
import dev.ftb.mods.ftbchunks.client.map.WaypointImpl;
import dev.ftb.mods.ftbchunks.client.map.WaypointManagerImpl;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.client.map.color.ColorUtils;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityIcons;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityMapIcon;
import dev.ftb.mods.ftbchunks.client.mapicon.InWorldMapIcon;
import dev.ftb.mods.ftbchunks.client.mapicon.MapIconComparator;
import dev.ftb.mods.ftbchunks.client.mapicon.TrackedPlayerMapIcon;
import dev.ftb.mods.ftbchunks.client.minimap.components.BiomeComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.DebugComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.FPSComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.GameTimeComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.PlayerPosInfoComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.RealTimeComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.ZoneInfoComponent;
import dev.ftb.mods.ftbchunks.client.neoforge.FTBChunksClientImpl;
import dev.ftb.mods.ftbchunks.data.ChunkSyncInfo;
import dev.ftb.mods.ftbchunks.net.PartialPackets;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbteams.api.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public enum FTBChunksClient {
    INSTANCE;

    public static final ResourceLocation WAYPOINT_BEAM;
    private static final ResourceLocation BUTTON_ID_MAP;
    private static final ResourceLocation BUTTON_ID_CLAIM;
    public static final ResourceLocation CIRCLE_MASK;
    public static final ResourceLocation CIRCLE_BORDER;
    public static final ResourceLocation SQUARE_MASK;
    public static final ResourceLocation SQUARE_BORDER;
    public static final ResourceLocation PLAYER;
    public static final ResourceLocation[] COMPASS;
    public KeyMapping openMapKey;
    public KeyMapping toggleMinimapKey;
    public KeyMapping openClaimManagerKey;
    public KeyMapping zoomInKey;
    public KeyMapping zoomOutKey;
    public KeyMapping addWaypointKey;
    public KeyMapping waypointManagerKey;
    private final Map<UUID, TrackedPlayerMapIcon> longRangePlayerTracker = new HashMap<UUID, TrackedPlayerMapIcon>();
    private long taskQueueTicks = 0L;
    private final Map<ChunkPos, IntOpenHashSet> rerenderCache = new HashMap<ChunkPos, IntOpenHashSet>();
    private int minimapTextureId = -1;
    private int currentPlayerChunkX;
    private int currentPlayerChunkZ;
    private double currentPlayerX;
    private double currentPlayerY;
    private double currentPlayerZ;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private int renderedDebugCount = 0;
    private boolean updateMinimapScheduled = false;
    private SendGeneralDataPacket.GeneralChunkData generalChunkData;
    private long nextRegionSave = 0L;
    private double prevZoom = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
    private long lastZoomTime = 0L;
    private final List<MapIcon> mapIcons = new ArrayList<MapIcon>();
    private final List<InWorldMapIcon> inWorldMapIcons = new ArrayList<InWorldMapIcon>();
    private long lastMapIconUpdate = 0L;
    private Matrix4f worldMatrix;
    private Vec3 cameraPos;
    private final List<MinimapInfoComponent> sortedComponents = new LinkedList<MinimapInfoComponent>();
    private static double vanillaEffectsOffsetX;

    public void init() {
        if (Minecraft.getInstance() == null) {
            return;
        }
        FTBChunksAPI._initClient(new FTBChunksClientAPIImpl());
        FTBChunksClientConfig.init();
        this.registerKeys();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new EntityIcons());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new ColorMapLoader());
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        CustomClickEvent.EVENT.register(this::customClick);
        ClientRawInputEvent.KEY_PRESSED.register(this::keyPressed);
        ClientScreenInputEvent.KEY_PRESSED_PRE.register(this::keyPressed);
        ClientGuiEvent.RENDER_HUD.register(this::renderHud);
        ClientGuiEvent.INIT_PRE.register(this::screenOpened);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        TeamEvent.CLIENT_PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        MapIconEvent.LARGE_MAP.register(this::mapIcons);
        MapIconEvent.MINIMAP.register(this::mapIcons);
        ClientReloadShadersEvent.EVENT.register(this::reloadShaders);
        FTBChunksClient.registerPlatform();
        FTBChunksClientAPI clientApi = FTBChunksAPI.clientApi();
        clientApi.registerMinimapComponent(new PlayerPosInfoComponent());
        clientApi.registerMinimapComponent(new ZoneInfoComponent());
        clientApi.registerMinimapComponent(new BiomeComponent());
        clientApi.registerMinimapComponent(new GameTimeComponent());
        clientApi.registerMinimapComponent(new RealTimeComponent());
        clientApi.registerMinimapComponent(new FPSComponent());
        clientApi.registerMinimapComponent(new DebugComponent());
        ClientLifecycleEvent.CLIENT_STARTED.register(this::clientStarted);
    }

    private void clientStarted(Minecraft minecraft) {
        this.setupComponents();
    }

    private void registerKeys() {
        this.openMapKey = new KeyMapping("key.ftbchunks.map", InputConstants.Type.KEYSYM, 77, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.openMapKey);
        this.toggleMinimapKey = new KeyMapping("key.ftbchunks.toggle_minimap", InputConstants.Type.KEYSYM, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.toggleMinimapKey);
        this.openClaimManagerKey = new KeyMapping("key.ftbchunks.claim_manager", InputConstants.Type.KEYSYM, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.openClaimManagerKey);
        this.zoomInKey = new KeyMapping("key.ftbchunks.minimap.zoomIn", InputConstants.Type.KEYSYM, 61, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.zoomInKey);
        this.zoomOutKey = new KeyMapping("key.ftbchunks.minimap.zoomOut", InputConstants.Type.KEYSYM, 45, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.zoomOutKey);
        this.addWaypointKey = new KeyMapping("key.ftbchunks.add_waypoint", InputConstants.Type.KEYSYM, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.addWaypointKey);
        this.waypointManagerKey = new KeyMapping("key.ftbchunks.waypoint_manager", InputConstants.Type.KEYSYM, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((KeyMapping)this.waypointManagerKey);
    }

    public Set<ChunkPos> getPendingRerender() {
        return this.rerenderCache.keySet();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatform() {
        FTBChunksClientImpl.registerPlatform();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean doesKeybindMatch(KeyMapping keyMapping, int keyCode, int scanCode, int modifiers) {
        void var3_3;
        void var2_2;
        void var1_1;
        return FTBChunksClientImpl.doesKeybindMatch(keyMapping, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    public static boolean doesKeybindMatch(KeyMapping keyMapping, Key key) {
        return FTBChunksClient.doesKeybindMatch(keyMapping, key.keyCode, key.scanCode, key.modifiers.modifiers);
    }

    public void openGui() {
        LargeMapScreen.openMap();
    }

    public void scheduleMinimapUpdate() {
        this.updateMinimapScheduled = true;
    }

    public void handlePlayerLogin(UUID serverId, SNBTCompoundTag config) {
        FTBChunks.LOGGER.info("Loading FTB Chunks client data from world {}", (Object)serverId);
        FTBChunksWorldConfig.CONFIG.read(config);
        MapManager.startUp(serverId);
        this.scheduleMinimapUpdate();
        this.renderedDebugCount = 0;
        ChunkUpdateTask.init();
    }

    public void loggedOut(@Nullable LocalPlayer player) {
        MapManager.shutdown();
    }

    public void updateGeneralData(SendGeneralDataPacket.GeneralChunkData chunkData) {
        this.generalChunkData = chunkData;
    }

    public void updateChunksFromServer(ResourceKey<Level> dimId, UUID teamId, Collection<ChunkSyncInfo> chunkSyncInfoList) {
        MapManager.getInstance().ifPresent(manager -> {
            MapDimension dimension = manager.getDimension(dimId);
            Date now = new Date();
            chunkSyncInfoList.forEach(chunkSyncInfo -> ClientTaskQueue.queue(new UpdateChunkFromServerTask(dimension, (ChunkSyncInfo)chunkSyncInfo, teamId, now)));
        });
    }

    public void syncRegionFromServer(RegionSyncKey key, int offset, int total, byte[] data) {
        PartialPackets.REGION.read(key, offset, total, data);
    }

    public void handlePlayerDeath(GlobalPos pos, int deathNumber) {
        if (((Boolean)FTBChunksClientConfig.DEATH_WAYPOINTS.get()).booleanValue() && FTBChunksWorldConfig.playerHasMapStage((Player)Minecraft.getInstance().player)) {
            MapManager.getInstance().ifPresent(manager -> {
                MapDimension dimension = manager.getDimension((ResourceKey<Level>)pos.dimension());
                for (WaypointImpl w : dimension.getWaypointManager()) {
                    if (!w.isDeathpoint()) continue;
                    w.setHidden(true);
                    w.refreshIcon();
                }
                WaypointImpl deathPoint = new WaypointImpl(WaypointType.DEATH, dimension, pos.pos()).setName("Death #" + deathNumber).setColor(0xFF0000);
                dimension.getWaypointManager().add(deathPoint);
            });
        }
    }

    public void handleBlockColorRequest() {
        Minecraft mc = Minecraft.getInstance();
        mc.submit(() -> {
            mc.setScreen(null);
            new Thread(() -> {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                mc.submit(() -> {
                    HitResult patt0$temp = mc.hitResult;
                    if (patt0$temp instanceof BlockHitResult) {
                        BlockHitResult hitResult = (BlockHitResult)patt0$temp;
                        if (mc.level != null && mc.player != null) {
                            ResourceLocation id = FTBChunks.BLOCK_REGISTRY.getId((Object)mc.level.getBlockState(hitResult.getBlockPos()).getBlock());
                            Window window = mc.getWindow();
                            try (NativeImage image = Screenshot.takeScreenshot((RenderTarget)mc.getMainRenderTarget());){
                                int col = image.getPixelRGBA(image.getWidth() / 2 - (int)(2.0 * window.getGuiScale()), image.getHeight() / 2 - (int)(2.0 * window.getGuiScale()));
                                String s = String.format("\"%s\": \"#%06X\"", id.getPath(), ColorUtils.convertFromNative(col) & 0xFFFFFF);
                                mc.player.displayClientMessage((Component)Component.literal((String)(id.getNamespace() + " - " + s)).withStyle(Style.EMPTY.applyFormat(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy")))), false);
                            }
                        }
                    }
                });
            }, "Color getter").start();
        });
    }

    public void syncLoadedChunkViewFromServer(ResourceKey<Level> dimension, Long2IntMap chunks) {
        MapManager.getInstance().ifPresent(manager -> {
            manager.getDimension(dimension).updateLoadedChunkView(chunks);
            manager.updateAllRegions(false);
        });
    }

    public boolean skipBlock(BlockState state) {
        ResourceLocation id = FTBChunks.BLOCK_REGISTRY.getId((Object)state.getBlock());
        return id == null || ColorMapLoader.getBlockColor(id).isIgnored();
    }

    public EventResult customClick(CustomClickEvent event) {
        if (FTBChunksWorldConfig.playerHasMapStage((Player)Minecraft.getInstance().player)) {
            if (event.id().equals((Object)BUTTON_ID_MAP)) {
                this.openGui();
                return EventResult.interruptTrue();
            }
            if (event.id().equals((Object)BUTTON_ID_CLAIM)) {
                ChunkScreen.openChunkScreen();
                return EventResult.interruptTrue();
            }
        }
        return EventResult.pass();
    }

    public EventResult keyPressed(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        if (action != 1 || client.screen != null || !FTBChunksWorldConfig.playerHasMapStage((Player)client.player)) {
            return EventResult.pass();
        }
        if (FTBChunksClient.doesKeybindMatch(this.openMapKey, keyCode, scanCode, modifiers)) {
            this.openGui();
            return EventResult.interruptTrue();
        }
        if (FTBChunksClient.doesKeybindMatch(this.toggleMinimapKey, keyCode, scanCode, modifiers)) {
            FTBChunksClientConfig.MINIMAP_ENABLED.set((Object)((Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get() == false ? 1 : 0));
            FTBChunksClientConfig.saveConfig();
            return EventResult.interruptTrue();
        }
        if (FTBChunksClient.doesKeybindMatch(this.openClaimManagerKey, keyCode, scanCode, modifiers)) {
            try {
                ChunkScreen.openChunkScreen();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return EventResult.interruptTrue();
        }
        if (FTBChunksClient.doesKeybindMatch(this.zoomInKey, keyCode, scanCode, modifiers)) {
            return this.changeZoom(true);
        }
        if (FTBChunksClient.doesKeybindMatch(this.zoomOutKey, keyCode, scanCode, modifiers)) {
            return this.changeZoom(false);
        }
        if (FTBChunksClient.doesKeybindMatch(this.addWaypointKey, keyCode, scanCode, modifiers)) {
            return this.addQuickWaypoint();
        }
        if (FTBChunksClient.doesKeybindMatch(this.waypointManagerKey, keyCode, scanCode, modifiers)) {
            new WaypointEditorScreen().openGui();
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public EventResult keyPressed(Minecraft client, Screen screen, int keyCode, int scanCode, int modifiers) {
        LargeMapScreen gui;
        if (FTBChunksClient.doesKeybindMatch(this.openMapKey, keyCode, scanCode, modifiers) && Platform.isFabric() && (gui = (LargeMapScreen)((Object)ClientUtils.getCurrentGuiAs(LargeMapScreen.class))) != null && !gui.anyModalPanelOpen()) {
            gui.closeGui(false);
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private EventResult addQuickWaypoint() {
        StringConfig name = new StringConfig();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return EventResult.pass();
        }
        return MapManager.getInstance().map(arg_0 -> FTBChunksClient.lambda$addQuickWaypoint$7(name, (Player)player, arg_0)).orElse(EventResult.pass());
    }

    private EventResult changeZoom(boolean zoomIn) {
        double zoomFactor;
        double zoom = this.prevZoom = ((Double)FTBChunksClientConfig.MINIMAP_ZOOM.get()).doubleValue();
        double d = zoomFactor = zoomIn ? 1.0 : -1.0;
        zoom = zoom + zoomFactor > 4.0 ? 4.0 : (zoom + zoomFactor < 1.0 ? 1.0 : (zoom += zoomFactor));
        this.lastZoomTime = System.currentTimeMillis();
        FTBChunksClientConfig.MINIMAP_ZOOM.set(Double.valueOf(zoom));
        return EventResult.interruptTrue();
    }

    public float getZoom() {
        double z = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
        if (this.prevZoom != z) {
            long max = (long)(400.0 / z);
            long t = Mth.clamp((long)(System.currentTimeMillis() - this.lastZoomTime), (long)0L, (long)max);
            if (t == max) {
                this.lastZoomTime = 0L;
                return (float)z;
            }
            return (float)Mth.lerp((double)((double)t / (double)max), (double)this.prevZoom, (double)z);
        }
        return (float)z;
    }

    public int generateTextureId(int w, int h) {
        int textureId = TextureUtil.generateTextureId();
        TextureUtil.prepareImage((int)textureId, (int)w, (int)h);
        return textureId;
    }

    public void renderHud(GuiGraphics graphics, DeltaTracker tickDelta) {
        float scale;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null || MapManager.getInstance().isEmpty() || MapDimension.getCurrent().isEmpty()) {
            return;
        }
        float partialTicks = tickDelta.getGameTimeDeltaPartialTick(false);
        double playerX = Mth.lerp((double)partialTicks, (double)this.prevPlayerX, (double)this.currentPlayerX);
        double playerY = Mth.lerp((double)partialTicks, (double)this.prevPlayerY, (double)this.currentPlayerY);
        double playerZ = Mth.lerp((double)partialTicks, (double)this.prevPlayerZ, (double)this.currentPlayerZ);
        double guiScale = mc.getWindow().getGuiScale();
        int scaledWidth = mc.getWindow().getGuiScaledWidth();
        int scaledHeight = mc.getWindow().getGuiScaledHeight();
        MapDimension dim = MapDimension.getCurrent().get();
        if (dim.dimension != mc.level.dimension()) {
            MapDimension.clearCurrentDimension();
            dim = MapDimension.getCurrent().orElseThrow();
            this.longRangePlayerTracker.clear();
        }
        long now = System.currentTimeMillis();
        if (this.nextRegionSave == 0L || now >= this.nextRegionSave) {
            this.nextRegionSave = now + 60000L;
            MapManager.getInstance().ifPresent(MapManager::saveAllRegions);
        }
        if (this.minimapTextureId == -1) {
            this.minimapTextureId = this.generateTextureId(240, 240);
            this.scheduleMinimapUpdate();
        }
        float zoom0 = this.getZoom();
        float zoom = zoom0 / 3.5f;
        MinimapBlurMode blurMode = (MinimapBlurMode)((Object)FTBChunksClientConfig.MINIMAP_BLUR_MODE.get());
        boolean minimapBlur = blurMode == MinimapBlurMode.AUTO ? zoom0 < 1.5f : blurMode == MinimapBlurMode.ON;
        int filter = minimapBlur ? 9729 : 9728;
        RenderSystem.bindTextureForSetup((int)this.minimapTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)filter);
        RenderSystem.texParameter((int)3553, (int)10240, (int)filter);
        int cx = Mth.floor((double)playerX) >> 4;
        int cz = Mth.floor((double)playerZ) >> 4;
        if (cx != this.currentPlayerChunkX || cz != this.currentPlayerChunkZ) {
            this.scheduleMinimapUpdate();
        }
        if (this.updateMinimapScheduled) {
            this.updateMinimapScheduled = false;
            for (int mz = 0; mz < 15; ++mz) {
                for (int mx = 0; mx < 15; ++mx) {
                    int ox = cx + mx - 7;
                    int oz = cz + mz - 7;
                    MapRegion region = dim.getRegion(XZ.regionFromChunk((int)ox, (int)oz));
                    region.getRenderedMapImage().upload(0, mx * 16, mz * 16, (ox & 0x1F) * 16, (oz & 0x1F) * 16, 16, 16, minimapBlur, false, false, false);
                }
            }
            this.currentPlayerChunkX = cx;
            this.currentPlayerChunkZ = cz;
        }
        if (mc.options.hideGui || mc.getDebugOverlay().showDebugScreen() || !((Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get()).booleanValue() || (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get() == 0 || !FTBChunksWorldConfig.shouldShowMinimap((Player)mc.player)) {
            return;
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_PROPORTIONAL.get()).booleanValue()) {
            scale = (float)(4.0 / guiScale);
            scale *= (float)scaledWidth / 10.0f / (scale * 64.0f) * ((Double)FTBChunksClientConfig.MINIMAP_SCALE.get()).floatValue();
        } else {
            scale = (float)((Double)FTBChunksClientConfig.MINIMAP_SCALE.get() * 4.0 / guiScale);
        }
        boolean rotationLocked = (Boolean)FTBChunksClientConfig.MINIMAP_LOCKED_NORTH.get() != false || (Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false;
        float minimapRotation = (rotationLocked ? 180.0f : -mc.player.getYRot()) % 360.0f;
        int size = (int)(64.0 * (double)scale);
        double halfSizeD = (double)size / 2.0;
        float halfSizeF = (float)size / 2.0f;
        MinimapPosition minimapPosition = (MinimapPosition)((Object)FTBChunksClientConfig.MINIMAP_POSITION.get());
        int x = minimapPosition.getX(scaledWidth, size);
        int y = minimapPosition.getY(scaledHeight, size);
        int offsetX = (Integer)FTBChunksClientConfig.MINIMAP_OFFSET_X.get();
        int offsetY = (Integer)FTBChunksClientConfig.MINIMAP_OFFSET_Y.get();
        MinimapPosition.MinimapOffsetConditional offsetConditional = (MinimapPosition.MinimapOffsetConditional)FTBChunksClientConfig.MINIMAP_POSITION_OFFSET_CONDITION.get();
        if (offsetConditional.test(minimapPosition)) {
            x += minimapPosition.posX == 0 ? offsetX : -offsetX;
            y -= minimapPosition.posY > 1 ? offsetY : -offsetY;
        }
        vanillaEffectsOffsetX = !mc.player.getActiveEffects().isEmpty() && y <= 50 && x + size > scaledWidth - 50 ? (double)(-(scaledWidth - x) - 5) : 0.0;
        float border = 0.0f;
        int alpha = (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        RenderSystem.enableDepthTest();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)x + halfSizeD, (double)y + halfSizeD, 490.0);
        Matrix4f m = poseStack.last().pose();
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)((Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false ? SQUARE_MASK : CIRCLE_MASK));
        buffer.addVertex(m, -halfSizeF + border, -halfSizeF + border, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f);
        buffer.addVertex(m, -halfSizeF + border, halfSizeF - border, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f);
        buffer.addVertex(m, halfSizeF - border, halfSizeF - border, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f);
        buffer.addVertex(m, halfSizeF - border, -halfSizeF + border, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        poseStack.mulPose(Axis.ZP.rotationDegrees(minimapRotation + 180.0f));
        RenderSystem.depthFunc((int)518);
        float halfSizeBorderF = halfSizeF - border;
        float offX = 0.5f + (float)((MathUtils.mod((double)playerX, (double)16.0) / 16.0 - 0.5) / 15.0);
        float offZ = 0.5f + (float)((MathUtils.mod((double)playerZ, (double)16.0) / 16.0 - 0.5) / 15.0);
        float zws = 2.0f / (15.0f * zoom);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (int)this.minimapTextureId);
        buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(m, -halfSizeBorderF, -halfSizeBorderF, 0.0f).setColor(255, 255, 255, alpha).setUv(offX - zws, offZ - zws);
        buffer.addVertex(m, -halfSizeBorderF, halfSizeBorderF, 0.0f).setColor(255, 255, 255, alpha).setUv(offX - zws, offZ + zws);
        buffer.addVertex(m, halfSizeBorderF, halfSizeBorderF, 0.0f).setColor(255, 255, 255, alpha).setUv(offX + zws, offZ + zws);
        buffer.addVertex(m, halfSizeBorderF, -halfSizeBorderF, 0.0f).setColor(255, 255, 255, alpha).setUv(offX + zws, offZ - zws);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)((Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false ? SQUARE_BORDER : CIRCLE_BORDER));
        buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(m, -halfSizeF, -halfSizeF, 0.0f).setColor(255, 255, 255, alpha).setUv(0.0f, 0.0f);
        buffer.addVertex(m, -halfSizeF, halfSizeF, 0.0f).setColor(255, 255, 255, alpha).setUv(0.0f, 1.0f);
        buffer.addVertex(m, halfSizeF, halfSizeF, 0.0f).setColor(255, 255, 255, alpha).setUv(1.0f, 1.0f);
        buffer.addVertex(m, halfSizeF, -halfSizeF, 0.0f).setColor(255, 255, 255, alpha).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(m, -halfSizeF, 0.0f, 0.0f).setColor(0, 0, 0, 30);
        buffer.addVertex(m, halfSizeF, 0.0f, 0.0f).setColor(0, 0, 0, 30);
        buffer.addVertex(m, 0.0f, -halfSizeF, 0.0f).setColor(0, 0, 0, 30);
        buffer.addVertex(m, 0.0f, halfSizeF, 0.0f).setColor(0, 0, 0, 30);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        poseStack.popPose();
        m = poseStack.last().pose();
        if (((Boolean)FTBChunksClientConfig.MINIMAP_COMPASS.get()).booleanValue()) {
            this.drawMinimapCompassPoints(minimapRotation, size, halfSizeD, x, y, tessellator, buffer, m);
        }
        if (this.lastMapIconUpdate == 0L || now - this.lastMapIconUpdate >= (long)((Integer)FTBChunksClientConfig.MINIMAP_ICON_UPDATE_TIMER.get()).intValue()) {
            this.lastMapIconUpdate = now;
            this.mapIcons.clear();
            ((Consumer)MapIconEvent.MINIMAP.invoker()).accept(new MapIconEvent(dim.dimension, this.mapIcons, MapType.MINIMAP));
            if (this.mapIcons.size() >= 2) {
                this.mapIcons.sort(new MapIconComparator(mc.player.position(), tickDelta.getGameTimeDeltaPartialTick(false)));
            }
        }
        for (MapIcon icon : this.mapIcons) {
            double distance;
            Vec3 pos = icon.getPos(tickDelta.getGameTimeDeltaPartialTick(false));
            double d = (distance = MathUtils.dist((double)playerX, (double)playerZ, (double)pos.x, (double)pos.z)) * (double)scale * (double)zoom;
            if (!icon.isVisible(MapType.MINIMAP, distance, d > halfSizeD)) continue;
            if (d > halfSizeD) {
                d = halfSizeD;
            }
            double angle = Math.atan2(playerZ - pos.z, playerX - pos.x) + (double)minimapRotation * Math.PI / 180.0;
            double ws = (double)size / (32.0 / icon.getIconScale(MapType.MINIMAP));
            double wx = (double)x + halfSizeD + Math.cos(angle) * d;
            double wy = (double)y + halfSizeD + Math.sin(angle) * d;
            float wsf = (float)(ws * 2.0);
            poseStack.pushPose();
            poseStack.translate(wx - ws, wy - ws - (icon.isIconOnEdge(MapType.MINIMAP, d >= halfSizeD) ? ws / 2.0 : 0.0), 0.0);
            poseStack.scale(wsf, wsf, 1.0f);
            icon.draw(MapType.MINIMAP, graphics, 0, 0, 1, 1, d >= halfSizeD, 255);
            poseStack.popPose();
        }
        if (rotationLocked || ((Boolean)FTBChunksClientConfig.SHOW_PLAYER_WHEN_UNLOCKED.get()).booleanValue()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)PLAYER);
            poseStack.pushPose();
            poseStack.translate((double)x + halfSizeD, (double)y + halfSizeD, 0.0);
            if (rotationLocked) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(mc.player.getYRot() + 180.0f));
            }
            poseStack.scale((float)size / 16.0f, (float)size / 16.0f, 1.0f);
            m = poseStack.last().pose();
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            buffer.addVertex(m, -1.0f, -1.0f, 0.0f).setColor(255, 255, 255, 200).setUv(0.0f, 0.0f);
            buffer.addVertex(m, -1.0f, 1.0f, 0.0f).setColor(255, 255, 255, 200).setUv(0.0f, 1.0f);
            buffer.addVertex(m, 1.0f, 1.0f, 0.0f).setColor(255, 255, 255, 200).setUv(1.0f, 1.0f);
            buffer.addVertex(m, 1.0f, -1.0f, 0.0f).setColor(255, 255, 255, 200).setUv(1.0f, 0.0f);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            poseStack.popPose();
        }
        MinimapContext context = new MinimapContext(mc, mc.player, dim, XZ.of((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ), new Vec3(playerX, playerY, playerZ), (Map)FTBChunksClientConfig.MINIMAP_SETTINGS.get());
        float fontScale = ((Double)FTBChunksClientConfig.MINIMAP_FONT_SCALE.get()).floatValue();
        int yOffset = 0;
        for (MinimapInfoComponent component : this.sortedComponents) {
            if (!component.shouldRender(context)) continue;
            int height = component.height(context);
            boolean isBottom = y + size + height >= scaledHeight;
            float yOff = isBottom ? (float)(-height - yOffset) : (float)size + 2.0f + (float)yOffset;
            poseStack.pushPose();
            poseStack.translate((double)x + halfSizeD, (double)((float)y + yOff), 0.0);
            poseStack.scale(fontScale, fontScale, 1.0f);
            component.render(context, graphics, mc.font);
            poseStack.popPose();
            yOffset += height;
        }
        RenderSystem.enableDepthTest();
        if (this.worldMatrix != null && ((Boolean)FTBChunksClientConfig.IN_WORLD_WAYPOINTS.get()).booleanValue()) {
            this.drawInWorldIcons(mc, graphics, tickDelta, playerX, playerY, playerZ, scaledWidth, scaledHeight);
        }
    }

    private void drawMinimapCompassPoints(float minimapRotation, int size, double halfSizeD, int minimapX, int minimapY, Tesselator tessellator, BufferBuilder buffer, Matrix4f m) {
        double d = (double)size / 2.2;
        float ws = (float)size / 32.0f;
        for (int face = 0; face < 4; ++face) {
            double angle = ((double)minimapRotation + 180.0 - (double)face * 90.0) * Math.PI / 180.0;
            float wx = (float)((double)minimapX + halfSizeD + Math.cos(angle) * d);
            float wy = (float)((double)minimapY + halfSizeD + Math.sin(angle) * d);
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)COMPASS[face]);
            buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            buffer.addVertex(m, wx - ws, wy - ws, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f);
            buffer.addVertex(m, wx - ws, wy + ws, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f);
            buffer.addVertex(m, wx + ws, wy + ws, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f);
            buffer.addVertex(m, wx + ws, wy - ws, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        }
    }

    private void drawInWorldIcons(Minecraft mc, GuiGraphics graphics, DeltaTracker tickDelta, double playerX, double playerY, double playerZ, int scaledWidth, int scaledHeight) {
        GuiHelper.setupDrawing();
        float scaledWidth2 = (float)scaledWidth / 2.0f;
        float scaledHeight2 = (float)scaledHeight / 2.0f;
        InWorldMapIcon focusedIcon = null;
        for (MapIcon icon : this.mapIcons) {
            Vec3 pos = icon.getPos(tickDelta.getGameTimeDeltaPartialTick(false));
            double playerDist = MathUtils.dist((double)pos.x, (double)pos.y, (double)pos.z, (double)playerX, (double)playerY, (double)playerZ);
            if (!icon.isVisible(MapType.WORLD_ICON, playerDist, false)) continue;
            Vector4f v = new Vector4f((float)(pos.x - this.cameraPos.x), (float)(pos.y - this.cameraPos.y), (float)(pos.z - this.cameraPos.z), 1.0f);
            double lookAngle = mc.player.getLookAngle().dot(new Vec3((double)v.x(), (double)v.y(), (double)v.z()).normalize());
            if (!(lookAngle > 0.0)) continue;
            this.worldMatrix.transform(v);
            v.div(v.w());
            float ix = scaledWidth2 + v.x() * scaledWidth2;
            float iy = scaledHeight2 - v.y() * scaledHeight2;
            double mouseDist = MathUtils.dist((double)ix, (double)iy, (double)scaledWidth2, (double)scaledHeight2);
            InWorldMapIcon inWorldMapIcon = new InWorldMapIcon(icon, ix, iy, playerDist, mouseDist);
            if (mouseDist <= 5.0 * (Double)FTBChunksClientConfig.WAYPOINT_FOCUS_DISTANCE.get() && (focusedIcon == null || focusedIcon.distanceToMouse() > mouseDist)) {
                focusedIcon = inWorldMapIcon;
            }
            this.inWorldMapIcons.add(inWorldMapIcon);
        }
        double fadeStart = (Double)FTBChunksClientConfig.WAYPOINT_DOT_FADE_DISTANCE.get();
        double fadeMin = fadeStart * 2.0 / 3.0;
        for (InWorldMapIcon icon : this.inWorldMapIcons) {
            if (!(icon.distanceToPlayer() > fadeMin)) continue;
            int iconAlpha = icon.distanceToPlayer() < fadeStart ? (int)(255.0 * ((icon.distanceToPlayer() - fadeMin) / (fadeStart - fadeMin))) : 255;
            float minSize = 0.25f;
            float maxSize = (float)((double)minSize * (Double)FTBChunksClientConfig.WAYPOINT_FOCUS_SCALE.get());
            if (iconAlpha <= 0) continue;
            float iconScale = Mth.lerp((float)((50.0f - Math.min((float)icon.distanceToMouse(), 50.0f)) / 50.0f), (float)minSize, (float)maxSize);
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            poseStack.translate(icon.x(), icon.y(), icon == focusedIcon ? 50.0f : -100.0f);
            poseStack.scale(iconScale, iconScale, 1.0f);
            icon.icon().draw(MapType.WORLD_ICON, graphics, -8, -8, 16, 16, icon != focusedIcon, iconAlpha);
            poseStack.popPose();
        }
        this.inWorldMapIcons.clear();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
    }

    public void renderWorldLast(PoseStack poseStack, Matrix4f projectionMatrix, Matrix4f modelViewMatrix, Camera camera, DeltaTracker tickDelta) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || MapManager.getInstance().isEmpty() || mc.level == null || mc.player == null || MapDimension.getCurrent().isEmpty() || !FTBChunksWorldConfig.playerHasMapStage((Player)mc.player)) {
            return;
        }
        this.worldMatrix = new Matrix4f((Matrix4fc)projectionMatrix);
        this.worldMatrix.mul((Matrix4fc)modelViewMatrix);
        this.cameraPos = camera.getPosition();
        if (!((Boolean)FTBChunksClientConfig.IN_WORLD_WAYPOINTS.get()).booleanValue()) {
            return;
        }
        List<WaypointIcon> visibleWaypoints = this.findVisibleWaypoints((Player)mc.player, tickDelta);
        if (visibleWaypoints.isEmpty()) {
            return;
        }
        Vec3 cameraPos = camera.getPosition();
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        RenderType renderType = RenderType.beaconBeam((ResourceLocation)WAYPOINT_BEAM, (boolean)true);
        VertexConsumer depthBuffer = mc.renderBuffers().bufferSource().getBuffer(renderType);
        float y1 = (float)(cameraPos.y + 30.0);
        float y2 = y1 + 70.0f;
        int yMin = mc.level.getMinBuildHeight();
        for (WaypointIcon waypoint : visibleWaypoints) {
            FTBChunksClient.drawWaypointBeacon(poseStack, cameraPos, depthBuffer, y1, y2, yMin, waypoint);
        }
        poseStack.popPose();
        mc.renderBuffers().bufferSource().endBatch(renderType);
    }

    private static void drawWaypointBeacon(PoseStack poseStack, Vec3 cameraPos, VertexConsumer depthBuffer, float y1, float y2, int yMin, WaypointIcon waypoint) {
        Vec3 pos = waypoint.getPos(1.0f);
        int alpha = waypoint.getAlpha();
        double angle = Math.atan2(cameraPos.z - pos.z, cameraPos.x - pos.x) * 180.0 / Math.PI;
        int r = waypoint.getColor().redi();
        int g = waypoint.getColor().greeni();
        int b = waypoint.getColor().bluei();
        poseStack.pushPose();
        poseStack.translate(pos.x, 0.0, pos.z);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)(-angle - 135.0)));
        float s = 0.6f;
        Matrix4f m = poseStack.last().pose();
        depthBuffer.addVertex(m, -s, (float)yMin, s).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        depthBuffer.addVertex(m, -s, y1, s).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        depthBuffer.addVertex(m, s, y1, -s).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        depthBuffer.addVertex(m, s, (float)yMin, -s).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        depthBuffer.addVertex(m, -s, y1, s).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        depthBuffer.addVertex(m, -s, y2, s).setColor(r, g, b, 0).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        depthBuffer.addVertex(m, s, y2, -s).setColor(r, g, b, 0).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        depthBuffer.addVertex(m, s, y1, -s).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
        poseStack.popPose();
    }

    private List<WaypointIcon> findVisibleWaypoints(Player player, DeltaTracker tickDelta) {
        return MapManager.getInstance().map(manager -> {
            ArrayList<MapIcon> visibleWaypoints = new ArrayList<MapIcon>();
            double fadeOutDistance = (Double)FTBChunksClientConfig.WAYPOINT_BEACON_FADE_DISTANCE.get();
            double fadeOutDistanceP = fadeOutDistance * 2.0 / 3.0;
            MapDimension dim = manager.getDimension((ResourceKey<Level>)player.level().dimension());
            for (Waypoint waypoint : dim.getWaypointManager()) {
                double distance;
                if (waypoint.isHidden() || !((distance = Math.sqrt(waypoint.getDistanceSq((Entity)player))) > fadeOutDistanceP) || !(distance <= (Double)FTBChunksClientConfig.WAYPOINT_MAX_DISTANCE.get())) continue;
                int alpha = 150;
                if (distance < fadeOutDistance) {
                    alpha = (int)((double)alpha * ((distance - fadeOutDistanceP) / (fadeOutDistance - fadeOutDistanceP)));
                }
                if (alpha <= 0) continue;
                waypoint.getMapIcon().setAlpha(alpha);
                visibleWaypoints.add(waypoint.getMapIcon());
            }
            visibleWaypoints.sort(new MapIconComparator(player.position(), tickDelta.getGameTimeDeltaPartialTick(false)));
            return visibleWaypoints;
        }).orElse(List.of());
    }

    private EventResult screenOpened(Screen screen, ScreenAccess access) {
        if (screen instanceof PauseScreen) {
            this.nextRegionSave = System.currentTimeMillis() + 60000L;
            MapManager.getInstance().ifPresent(MapManager::saveAllRegions);
        }
        return EventResult.pass();
    }

    private void clientTick(Minecraft mc) {
        if (mc.level == null) {
            return;
        }
        MapManager.getInstance().ifPresent(manager -> {
            int releaseInterval;
            if (mc.player != null) {
                this.prevPlayerX = this.currentPlayerX;
                this.prevPlayerY = this.currentPlayerY;
                this.prevPlayerZ = this.currentPlayerZ;
                this.currentPlayerX = mc.player.getX();
                this.currentPlayerY = mc.player.getY();
                this.currentPlayerZ = mc.player.getZ();
            }
            Level level = (Level)Objects.requireNonNull(mc.level);
            if (this.taskQueueTicks % (long)((Integer)FTBChunksClientConfig.RERENDER_QUEUE_TICKS.get()).intValue() == 0L) {
                this.runRerenderTasks(level, (MapManager)manager);
            }
            if (this.taskQueueTicks % (long)((Integer)FTBChunksClientConfig.TASK_QUEUE_TICKS.get()).intValue() == 0L) {
                ClientTaskQueue.runQueuedTasks();
            }
            if ((releaseInterval = ((Integer)FTBChunksClientConfig.REGION_RELEASE_TIME.get()).intValue()) > 0 && level.getGameTime() % ((long)releaseInterval * 20L) == 0L) {
                manager.releaseStaleRegionData((long)releaseInterval * 1000L);
            }
            if (mc.screen == null) {
                manager.checkForRegionPurge();
            }
            ++this.taskQueueTicks;
        });
    }

    private void runRerenderTasks(Level level, MapManager manager) {
        if (!this.rerenderCache.isEmpty()) {
            this.rerenderCache.forEach((chunkPos, blocks) -> {
                ChunkAccess chunkAccess = level.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.FULL, false);
                if (chunkAccess != null) {
                    this.queueOrExecute(new ChunkUpdateTask(manager, level, chunkAccess, (ChunkPos)chunkPos, blocks.toIntArray()));
                }
            });
            this.rerenderCache.clear();
        }
    }

    private void teamPropertiesChanged(ClientTeamPropertiesChangedEvent event) {
        MapManager.getInstance().ifPresent(manager -> manager.updateAllRegions(false));
    }

    private void mapIcons(MapIconEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_WAYPOINTS.get()).booleanValue()) {
            MapDimension.getCurrent().ifPresent(mapDimension -> {
                for (Waypoint w : mapDimension.getWaypointManager()) {
                    if (w.isHidden() && event.getMapType().isMinimap()) continue;
                    event.add(w.getMapIcon());
                }
            });
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_ENTITIES.get()).booleanValue()) {
            for (Entity entity : mc.level.entitiesForRendering()) {
                if (!EntityIcons.shouldEntityRender(entity, (Player)mc.player)) continue;
                Icon icon2 = EntityIcons.getIcon(entity);
                Optional<EntityIcons.EntityIconSettings> settings = EntityIcons.getSettings(entity.getType());
                if (settings.isEmpty()) continue;
                EntityIcons.WidthHeight wh = settings.get().widthHeight();
                if (icon2.isEmpty()) continue;
                if (((Boolean)FTBChunksClientConfig.ONLY_SURFACE_ENTITIES.get()).booleanValue() && !mc.level.dimensionType().hasCeiling()) {
                    MapDimension.getCurrent().ifPresent(mapDimension -> {
                        int z;
                        int x = Mth.floor((double)entity.getX());
                        MapRegion region = mapDimension.getRegion(XZ.regionFromBlock((int)x, (int)(z = Mth.floor((double)entity.getZ()))));
                        MapRegionData data = region.getData();
                        if (data != null) {
                            short y = data.height[(x & 0x1FF) + (z & 0x1FF) * 512];
                            if (entity.getY() >= (double)(y - 10)) {
                                event.add(new EntityMapIcon(entity, icon2, wh));
                            }
                        }
                    });
                    continue;
                }
                event.add(new EntityMapIcon(entity, icon2, wh));
            }
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_PLAYER_HEADS.get()).booleanValue()) {
            if (mc.level.players().size() > 1) {
                for (AbstractClientPlayer player : mc.level.players()) {
                    if (player == mc.player || player.isInvisibleTo((Player)mc.player) || !VisibleClientPlayers.isPlayerVisible((Player)player)) continue;
                    if (this.longRangePlayerTracker.remove(player.getUUID()) != null) {
                        LargeMapScreen.refreshIconsIfOpen();
                    }
                    event.add(new EntityMapIcon((Entity)player, (Icon)FaceIcon.getFace((GameProfile)player.getGameProfile())));
                }
            }
            this.longRangePlayerTracker.forEach((id, icon) -> event.add((MapIcon)icon));
        }
        if (!event.getMapType().isMinimap()) {
            event.add(new EntityMapIcon((Entity)mc.player, (Icon)FaceIcon.getFace((GameProfile)mc.player.getGameProfile())));
            event.add(new PointerIcon());
        }
    }

    void refreshMinimapIcons() {
        this.lastMapIconUpdate = 0L;
    }

    private void reloadShaders(ResourceProvider resourceProvider, ClientReloadShadersEvent.ShadersSink sink) {
    }

    public void rerender(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        IntOpenHashSet set = this.rerenderCache.get(chunkPos);
        if (set == null) {
            set = new IntOpenHashSet();
            this.rerenderCache.put(chunkPos, set);
        }
        if (set.add((pos.getX() & 0xF) + (pos.getZ() & 0xF) * 16) && ((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            ++this.renderedDebugCount;
        }
    }

    public void handlePacket(ClientboundSectionBlocksUpdatePacket p) {
        short[] positions;
        SectionPos sectionPos = p.sectionPos;
        for (short position : positions = p.positions) {
            this.rerender(sectionPos.relativeToBlockPos(position));
        }
    }

    public void handlePacket(ClientboundLevelChunkWithLightPacket p) {
        ChunkAccess chunkAccess;
        MapManager manager = MapManager.getInstance().orElse(null);
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (chunkAccess = level.getChunk(p.getX(), p.getZ(), ChunkStatus.FULL, false)) != null) {
            this.queueOrExecute(new ChunkUpdateTask(manager, (Level)level, chunkAccess, new ChunkPos(p.getX(), p.getZ())));
        }
    }

    public void queueOrExecute(MapTask task) {
        FTBChunks.EXECUTOR.execute(task);
    }

    public void handlePacket(ClientboundBlockUpdatePacket p) {
        this.rerender(p.getPos());
    }

    public void maybeClearDeathpoint(Player player) {
        int maxDist = (Integer)FTBChunksClientConfig.DEATH_WAYPOINT_AUTOREMOVE_DISTANCE.get();
        MapManager.getInstance().ifPresent(manager -> {
            if (maxDist > 0 && Minecraft.getInstance().screen == null) {
                WaypointManagerImpl wpm = manager.getDimension((ResourceKey<Level>)player.level().dimension()).getWaypointManager();
                wpm.getNearestDeathpoint(player).ifPresent(wp -> {
                    if (wp.getDistanceSq((Entity)player) < (double)(maxDist * maxDist)) {
                        wpm.remove((WaypointImpl)wp);
                        wpm.getNearestDeathpoint(player).ifPresent(wp1 -> wp1.setHidden(false));
                        player.displayClientMessage((Component)Component.translatable((String)"ftbchunks.deathpoint_removed", (Object[])new Object[]{wp.getName()}).withStyle(ChatFormatting.YELLOW), true);
                    }
                });
            }
        });
    }

    public void updateTrackedPlayerPos(GameProfile profile, BlockPos pos) {
        boolean changed = false;
        if (pos == null) {
            changed = this.longRangePlayerTracker.remove(profile.getId()) != null;
        } else {
            TrackedPlayerMapIcon icon = this.longRangePlayerTracker.get(profile.getId());
            if (icon == null) {
                this.longRangePlayerTracker.put(profile.getId(), new TrackedPlayerMapIcon(profile, Vec3.atCenterOf((Vec3i)pos), FaceIcon.getFace((GameProfile)profile)));
                changed = true;
            } else {
                icon.setPos(Vec3.atCenterOf((Vec3i)pos));
            }
        }
        if (changed) {
            LargeMapScreen.refreshIconsIfOpen();
        }
    }

    public List<Component> getChunkSummary() {
        if (this.generalChunkData == null) {
            return List.of();
        }
        ArrayList<Component> list = new ArrayList<Component>(4);
        list.add((Component)Component.translatable((String)"ftbchunks.gui.claimed"));
        int claimed = this.generalChunkData.claimed();
        int maxClaim = this.generalChunkData.maxClaimChunks();
        list.add((Component)Component.literal((String)(claimed + " / " + maxClaim)).withStyle(claimed > maxClaim ? ChatFormatting.RED : (claimed == maxClaim ? ChatFormatting.YELLOW : ChatFormatting.GREEN)));
        list.add((Component)Component.translatable((String)"ftbchunks.gui.force_loaded"));
        int loaded = this.generalChunkData.loaded();
        int maxLoaded = this.generalChunkData.maxForceLoadChunks();
        list.add((Component)Component.literal((String)(loaded + " / " + maxLoaded)).withStyle(loaded > maxLoaded ? ChatFormatting.RED : (loaded == maxLoaded ? ChatFormatting.YELLOW : ChatFormatting.GREEN)));
        return list;
    }

    public SendGeneralDataPacket.GeneralChunkData getGeneralChunkData() {
        return this.generalChunkData;
    }

    public int getMinimapTextureId() {
        return this.minimapTextureId;
    }

    public static Waypoint addWaypoint(String name, GlobalPos position, int color) {
        return FTBChunksAPI.clientApi().getWaypointManager((ResourceKey<Level>)position.dimension()).map(mgr -> {
            Waypoint wp = mgr.addWaypointAt(position.pos(), name);
            wp.setColor(color);
            return wp;
        }).orElse(null);
    }

    public void setupComponents() {
        this.sortedComponents.clear();
        this.computeOrderedComponents();
    }

    private void computeOrderedComponents() {
        Map componentMap = FTBChunksAPI.clientApi().getMinimapComponents().stream().collect(Collectors.toMap(MinimapInfoComponent::id, Function.identity()));
        List order = ((List)FTBChunksClientConfig.MINIMAP_INFO_ORDER.get()).stream().map(ResourceLocation::parse).collect(Collectors.toList());
        boolean save = false;
        for (ResourceLocation location : componentMap.keySet()) {
            if (order.contains(location)) continue;
            order.add(location);
            save = true;
        }
        if (save) {
            FTBChunksClientConfig.MINIMAP_INFO_ORDER.set(order.stream().map(ResourceLocation::toString).collect(Collectors.toList()));
            FTBChunksClientConfig.saveConfig();
        }
        for (ResourceLocation id : order) {
            MinimapInfoComponent minimapInfoComponent = (MinimapInfoComponent)componentMap.get(id);
            if (minimapInfoComponent == null || !FTBChunksAPI.clientApi().isMinimapComponentEnabled(minimapInfoComponent)) continue;
            this.sortedComponents.add(minimapInfoComponent);
        }
    }

    public static double getVanillaEffectsOffsetX() {
        return vanillaEffectsOffsetX;
    }

    public int getRenderedDebugCount() {
        return this.renderedDebugCount;
    }

    private static /* synthetic */ EventResult lambda$addQuickWaypoint$7(StringConfig name, Player player, MapManager manager) {
        WaypointAddScreen screen = new WaypointAddScreen(name, player);
        screen.openGuiLater();
        return EventResult.interruptTrue();
    }

    static {
        WAYPOINT_BEAM = FTBChunksAPI.rl("textures/waypoint_beam.png");
        BUTTON_ID_MAP = FTBChunksAPI.rl("open_gui");
        BUTTON_ID_CLAIM = FTBChunksAPI.rl("open_claim_gui");
        CIRCLE_MASK = FTBChunksAPI.rl("textures/circle_mask.png");
        CIRCLE_BORDER = FTBChunksAPI.rl("textures/circle_border.png");
        SQUARE_MASK = FTBChunksAPI.rl("textures/square_mask.png");
        SQUARE_BORDER = FTBChunksAPI.rl("textures/square_border.png");
        PLAYER = FTBChunksAPI.rl("textures/player.png");
        COMPASS = new ResourceLocation[]{FTBChunksAPI.rl("textures/compass_e.png"), FTBChunksAPI.rl("textures/compass_n.png"), FTBChunksAPI.rl("textures/compass_w.png"), FTBChunksAPI.rl("textures/compass_s.png")};
    }

    public static class WaypointAddScreen
    extends BaseScreen {
        private final StringConfig name;
        private final GlobalPos waypointLocation;

        public WaypointAddScreen(StringConfig name, GlobalPos waypointLocation) {
            this.name = name;
            this.waypointLocation = waypointLocation;
            this.setHeight(35);
        }

        public WaypointAddScreen(StringConfig name, Player player) {
            this(name, new GlobalPos(player.level().dimension(), player.blockPosition()));
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        }

        public void addWidgets() {
            ColorConfig col = new ColorConfig();
            AddWaypointOverlay.GlobalPosConfig globalPosConfig = new AddWaypointOverlay.GlobalPosConfig();
            globalPosConfig.setValue(this.waypointLocation);
            col.setValue((Object)Color4I.hsb((float)MathUtils.RAND.nextFloat(), (float)1.0f, (float)1.0f));
            AddWaypointOverlay overlay = new AddWaypointOverlay(this, (Panel)this, globalPosConfig, (ConfigFromString)this.name, col, set -> {
                if (set && !((String)this.name.getValue()).isEmpty()) {
                    Waypoint wp = FTBChunksClient.addWaypoint((String)this.name.getValue(), (GlobalPos)globalPosConfig.getValue(), ((Color4I)col.getValue()).rgba());
                    Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"ftbchunks.waypoint_added", (Object[])new Object[]{Component.literal((String)wp.getName()).withStyle(ChatFormatting.YELLOW)}), true);
                }
            }){

                public void onClosed() {
                    this.closeGui();
                }
            };
            overlay.setWidth(this.width);
            this.pushModalPanel((ModalPanel)overlay);
        }
    }
}

