/*
 * Decompiled with CFR 0.152.
 */
package appeng.facade;

import appeng.api.implementations.items.IFacadeItem;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartCollisionHelper;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FacadePart
implements IFacadePart {
    private final ItemStack facade;
    private final Direction side;

    public FacadePart(ItemStack facade, Direction side) {
        Objects.requireNonNull(side, "side");
        Objects.requireNonNull(facade, "facade");
        this.facade = facade.copy();
        this.facade.setCount(1);
        this.side = side;
    }

    @Override
    public ItemStack getItemStack() {
        return this.facade;
    }

    @Override
    public void getBoxes(IPartCollisionHelper ch, boolean itemEntity) {
        if (itemEntity) {
            ch.addBox(0.0, 0.0, 15.0, 16.0, 16.0, 15.9);
        } else {
            ch.addBox(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
        }
    }

    @Override
    public Direction getSide() {
        return this.side;
    }

    @Override
    public Item getItem() {
        ItemStack is = this.getTextureItem();
        if (is.isEmpty()) {
            return Items.AIR;
        }
        return is.getItem();
    }

    @Override
    public ItemStack getTextureItem() {
        Item maybeFacade = this.facade.getItem();
        if (maybeFacade instanceof IFacadeItem) {
            IFacadeItem facade = (IFacadeItem)maybeFacade;
            return facade.getTextureItem(this.facade);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public BlockState getBlockState() {
        Item maybeFacade = this.facade.getItem();
        if (maybeFacade instanceof IFacadeItem) {
            IFacadeItem facade = (IFacadeItem)maybeFacade;
            return facade.getTextureBlockState(this.facade);
        }
        return Blocks.GLASS.defaultBlockState();
    }
}

