/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.recipes;

import appeng.api.stacks.AEKeyType;
import appeng.api.util.AEColor;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.datagen.providers.recipes.AE2RecipeProvider;
import appeng.datagen.providers.tags.ConventionTags;
import appeng.items.materials.MaterialItem;
import appeng.items.tools.powered.PortableCellItem;
import appeng.recipes.game.AddItemUpgradeRecipe;
import appeng.recipes.game.RemoveItemUpgradeRecipe;
import appeng.recipes.game.StorageCellUpgradeRecipe;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;

public class CraftingRecipes
extends AE2RecipeProvider {
    public CraftingRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public String getName() {
        return "AE2 Crafting Recipes";
    }

    protected void buildRecipes(RecipeOutput consumer) {
        this.storageCellUpgradeRecipes(consumer);
        this.itemUpgradeRecipe(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.BASIC_CARD, (int)2).pattern("ab ").pattern("cdb").pattern("ab ").define(Character.valueOf('a'), ConventionTags.GOLD_INGOT).define(Character.valueOf('b'), ConventionTags.IRON_INGOT).define(Character.valueOf('c'), ConventionTags.REDSTONE).define(Character.valueOf('d'), AEItems.CALCULATION_PROCESSOR).unlockedBy("has_calculation_processor", CraftingRecipes.has(AEItems.CALCULATION_PROCESSOR)).save(consumer, AppEng.makeId("materials/basiccard"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.CAPACITY_CARD).requires(ConventionTags.ALL_CERTUS_QUARTZ).requires(AEItems.BASIC_CARD).unlockedBy("has_basic_card", CraftingRecipes.has(AEItems.BASIC_CARD)).save(consumer, AppEng.makeId("materials/cardcapacity"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.CRAFTING_CARD).requires((ItemLike)Items.CRAFTING_TABLE).requires(AEItems.BASIC_CARD).unlockedBy("has_basic_card", CraftingRecipes.has(AEItems.BASIC_CARD)).save(consumer, AppEng.makeId("materials/cardcrafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.REDSTONE_CARD).requires((ItemLike)Items.REDSTONE_TORCH).requires(AEItems.BASIC_CARD).unlockedBy("has_basic_card", CraftingRecipes.has(AEItems.BASIC_CARD)).save(consumer, AppEng.makeId("materials/cardredstone"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.VOID_CARD).requires(AEItems.CALCULATION_PROCESSOR).requires(AEItems.BASIC_CARD).unlockedBy("has_basic_card", CraftingRecipes.has(AEItems.BASIC_CARD)).save(consumer, AppEng.makeId("materials/cardvoid"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.ADVANCED_CARD, (int)2).pattern("ab ").pattern("cdb").pattern("ab ").define(Character.valueOf('a'), ConventionTags.DIAMOND).define(Character.valueOf('b'), ConventionTags.IRON_INGOT).define(Character.valueOf('c'), ConventionTags.REDSTONE).define(Character.valueOf('d'), AEItems.CALCULATION_PROCESSOR).unlockedBy("has_calculation_processor", CraftingRecipes.has(AEItems.CALCULATION_PROCESSOR)).save(consumer, AppEng.makeId("materials/advancedcard"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.FUZZY_CARD).requires(AEItems.ADVANCED_CARD).requires(ItemTags.WOOL).unlockedBy("has_advanced_card", CraftingRecipes.has(AEItems.ADVANCED_CARD)).save(consumer, AppEng.makeId("materials/cardfuzzy"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.INVERTER_CARD).requires((ItemLike)Items.REDSTONE_TORCH).requires(AEItems.ADVANCED_CARD).unlockedBy("has_advanced_card", CraftingRecipes.has(AEItems.ADVANCED_CARD)).save(consumer, AppEng.makeId("materials/cardinverter"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.SPEED_CARD).requires(AEItems.ADVANCED_CARD).requires(ConventionTags.ALL_FLUIX).unlockedBy("has_advanced_card", CraftingRecipes.has(AEItems.ADVANCED_CARD)).save(consumer, AppEng.makeId("materials/cardspeed"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.EQUAL_DISTRIBUTION_CARD).requires(AEItems.ADVANCED_CARD).requires(AEItems.CALCULATION_PROCESSOR).unlockedBy("has_advanced_card", CraftingRecipes.has(AEItems.ADVANCED_CARD)).save(consumer, AppEng.makeId("materials/carddistribution"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.ENERGY_CARD).pattern("ab").define(Character.valueOf('a'), AEBlocks.DENSE_ENERGY_CELL).define(Character.valueOf('b'), AEItems.ADVANCED_CARD).unlockedBy("has_advanced_card", CraftingRecipes.has(AEItems.ADVANCED_CARD)).save(consumer, AppEng.makeId("materials/cardenergy"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.ANNIHILATION_CORE, (int)2).pattern("abc").define(Character.valueOf('a'), ConventionTags.ALL_NETHER_QUARTZ).define(Character.valueOf('b'), ConventionTags.FLUIX_DUST).define(Character.valueOf('c'), AEItems.LOGIC_PROCESSOR).unlockedBy("has_logic_processor", CraftingRecipes.has(AEItems.LOGIC_PROCESSOR)).save(consumer, AppEng.makeId("materials/annihilationcore"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.FORMATION_CORE, (int)2).pattern("abc").define(Character.valueOf('a'), ConventionTags.ALL_CERTUS_QUARTZ).define(Character.valueOf('b'), ConventionTags.FLUIX_DUST).define(Character.valueOf('c'), AEItems.LOGIC_PROCESSOR).unlockedBy("has_logic_processor", CraftingRecipes.has(AEItems.LOGIC_PROCESSOR)).save(consumer, AppEng.makeId("materials/formationcore"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.SKY_STONE_CHEST).pattern("aaa").pattern("a a").pattern("aaa").define(Character.valueOf('a'), AEBlocks.SKY_STONE_BLOCK).unlockedBy("has_sky_stone_block", CraftingRecipes.has(AEBlocks.SKY_STONE_BLOCK)).save(consumer, AppEng.makeId("misc/chests_sky_stone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.SMOOTH_SKY_STONE_CHEST).pattern("aaa").pattern("a a").pattern("aaa").define(Character.valueOf('a'), AEBlocks.SMOOTH_SKY_STONE_BLOCK).unlockedBy("has_smooth_sky_stone_block", CraftingRecipes.has(AEBlocks.SMOOTH_SKY_STONE_BLOCK)).save(consumer, AppEng.makeId("misc/chests_smooth_sky_stone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.SKY_STONE_TANK).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), AEBlocks.SKY_STONE_BLOCK).define(Character.valueOf('b'), AEBlocks.QUARTZ_GLASS).unlockedBy("has_sky_stone_block", CraftingRecipes.has(AEBlocks.SKY_STONE_BLOCK)).save(consumer, AppEng.makeId("misc/tank_sky_stone"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_CRYSTAL, (int)4).requires(AEBlocks.QUARTZ_BLOCK).unlockedBy("has_quartz_block", CraftingRecipes.has(AEBlocks.QUARTZ_BLOCK)).save(consumer, AppEng.makeId("misc/deconstruction_certus_quartz_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_CRYSTAL, (int)4).requires(AEBlocks.CUT_QUARTZ_BLOCK).unlockedBy("has_cut_quartz_block", CraftingRecipes.has(AEBlocks.CUT_QUARTZ_BLOCK)).save(consumer, AppEng.makeId("misc/deconstruction_cut_certus_quartz_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_CRYSTAL, (int)4).requires(AEBlocks.SMOOTH_QUARTZ_BLOCK).unlockedBy("has_smooth_quartz_block", CraftingRecipes.has(AEBlocks.SMOOTH_QUARTZ_BLOCK)).save(consumer, AppEng.makeId("misc/deconstruction_smooth_certus_quartz_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_CRYSTAL, (int)4).requires(AEBlocks.QUARTZ_BRICKS).unlockedBy("has_quartz_bricks", CraftingRecipes.has(AEBlocks.QUARTZ_BRICKS)).save(consumer, AppEng.makeId("misc/deconstruction_certus_quartz_bricks"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_CRYSTAL, (int)4).requires(AEBlocks.QUARTZ_PILLAR).unlockedBy("has_quartz_pillar", CraftingRecipes.has(AEBlocks.QUARTZ_PILLAR)).save(consumer, AppEng.makeId("misc/deconstruction_certus_quartz_pillar"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_CRYSTAL, (int)4).requires(AEBlocks.CHISELED_QUARTZ_BLOCK).unlockedBy("has_chiseled_quartz_block", CraftingRecipes.has(AEBlocks.CHISELED_QUARTZ_BLOCK)).save(consumer, AppEng.makeId("misc/deconstruction_chiseled_certus_quartz"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.FLUIX_CRYSTAL, (int)4).requires(AEBlocks.FLUIX_BLOCK).unlockedBy("has_fluix_block", CraftingRecipes.has(AEBlocks.FLUIX_BLOCK)).save(consumer, AppEng.makeId("misc/deconstruction_fluix_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.FLUIX_PEARL).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), ConventionTags.FLUIX_DUST).define(Character.valueOf('b'), ConventionTags.ALL_FLUIX).define(Character.valueOf('c'), ConventionTags.ENDER_PEARL).unlockedBy("has_dusts/fluix", CraftingRecipes.has(ConventionTags.FLUIX_DUST)).unlockedBy("has_crystals/fluix", CraftingRecipes.has(ConventionTags.ALL_FLUIX)).save(consumer, AppEng.makeId("misc/fluixpearl"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.TINY_TNT).pattern("ab").pattern("ba").define(Character.valueOf('a'), ConventionTags.ALL_QUARTZ_DUST).define(Character.valueOf('b'), (ItemLike)Items.GUNPOWDER).unlockedBy("has_gunpowder", CraftingRecipes.has((ItemLike)Items.GUNPOWDER)).unlockedBy("has_dusts/quartz", CraftingRecipes.has(ConventionTags.ALL_QUARTZ_DUST)).save(consumer, AppEng.makeId("misc/tiny_tnt"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.CRYSTAL_RESONANCE_GENERATOR).pattern("cfc").pattern("cqc").pattern("iii").define(Character.valueOf('i'), ConventionTags.IRON_INGOT).define(Character.valueOf('f'), AEBlocks.FLUIX_BLOCK).define(Character.valueOf('c'), ConventionTags.COPPER_INGOT).define(Character.valueOf('q'), AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED).unlockedBy(CraftingRecipes.getHasName(AEBlocks.FLUIX_BLOCK), CraftingRecipes.has(AEBlocks.FLUIX_BLOCK)).save(consumer, AppEng.makeId("network/crystal_resonance_generator"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.WIRELESS_ACCESS_POINT).pattern("a").pattern("b").pattern("c").define(Character.valueOf('a'), AEItems.WIRELESS_RECEIVER).define(Character.valueOf('b'), AEItems.CALCULATION_PROCESSOR).define(Character.valueOf('c'), AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).unlockedBy("has_wireless_receiver", CraftingRecipes.has(AEItems.WIRELESS_RECEIVER)).save(consumer, AppEng.makeId("network/wireless_access_point"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.WIRELESS_BOOSTER, (int)2).pattern("abc").pattern("ddd").define(Character.valueOf('a'), ConventionTags.FLUIX_DUST).define(Character.valueOf('b'), ConventionTags.ALL_CERTUS_QUARTZ).define(Character.valueOf('c'), ConventionTags.ENDER_PEARL_DUST).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).unlockedBy("has_dusts/ender", CraftingRecipes.has(ConventionTags.ENDER_PEARL_DUST)).save(consumer, AppEng.makeId("network/wireless_booster"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.WIRELESS_RECEIVER).pattern(" a ").pattern("bcb").pattern(" b ").define(Character.valueOf('a'), AEItems.FLUIX_PEARL).define(Character.valueOf('b'), ConventionTags.IRON_INGOT).define(Character.valueOf('c'), AEParts.QUARTZ_FIBER).unlockedBy("has_fluix_pearl", CraftingRecipes.has(AEItems.FLUIX_PEARL)).save(consumer, AppEng.makeId("network/wireless_part"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.WIRELESS_TERMINAL).pattern("a").pattern("b").pattern("c").define(Character.valueOf('a'), AEItems.WIRELESS_RECEIVER).define(Character.valueOf('b'), AEParts.TERMINAL).define(Character.valueOf('c'), AEBlocks.DENSE_ENERGY_CELL).unlockedBy("has_terminal", CraftingRecipes.has(AEParts.TERMINAL)).unlockedBy("has_dense_energy_cell", CraftingRecipes.has(AEBlocks.DENSE_ENERGY_CELL)).unlockedBy("has_wireless_receiver", CraftingRecipes.has(AEItems.WIRELESS_RECEIVER)).save(consumer, AppEng.makeId("network/wireless_terminal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.WIRELESS_CRAFTING_TERMINAL).pattern("a").pattern("b").pattern("c").define(Character.valueOf('a'), AEItems.WIRELESS_RECEIVER).define(Character.valueOf('b'), AEParts.CRAFTING_TERMINAL).define(Character.valueOf('c'), AEBlocks.DENSE_ENERGY_CELL).unlockedBy("has_terminal", CraftingRecipes.has(AEParts.CRAFTING_TERMINAL)).unlockedBy("has_dense_energy_cell", CraftingRecipes.has(AEBlocks.DENSE_ENERGY_CELL)).unlockedBy("has_wireless_receiver", CraftingRecipes.has(AEItems.WIRELESS_RECEIVER)).save(consumer, AppEng.makeId("network/wireless_crafting_terminal"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.WIRELESS_CRAFTING_TERMINAL).requires(AEItems.WIRELESS_TERMINAL).requires((ItemLike)Items.CRAFTING_TABLE).requires(AEItems.CALCULATION_PROCESSOR).unlockedBy("has_terminal", CraftingRecipes.has(AEItems.WIRELESS_TERMINAL)).unlockedBy("has_calculation_processor", CraftingRecipes.has(AEItems.CALCULATION_PROCESSOR)).save(consumer, AppEng.makeId("network/upgrade_wireless_crafting_terminal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.CELL_WORKBENCH).pattern("aba").pattern("cdc").pattern("ccc").define(Character.valueOf('a'), ItemTags.WOOL).define(Character.valueOf('b'), AEItems.CALCULATION_PROCESSOR).define(Character.valueOf('c'), ConventionTags.IRON_INGOT).define(Character.valueOf('d'), ConventionTags.CHEST).unlockedBy("has_calculation_processor", CraftingRecipes.has(AEItems.CALCULATION_PROCESSOR)).save(consumer, AppEng.makeId("network/blocks/cell_workbench"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.CONTROLLER).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), AEBlocks.SMOOTH_SKY_STONE_BLOCK).define(Character.valueOf('b'), AEItems.FLUIX_CRYSTAL).define(Character.valueOf('c'), AEItems.ENGINEERING_PROCESSOR).unlockedBy("has_purified_fluix_crystal", CraftingRecipes.has(AEItems.FLUIX_CRYSTAL)).unlockedBy("has_engineering_processor", CraftingRecipes.has(AEItems.ENGINEERING_PROCESSOR)).save(consumer, AppEng.makeId("network/blocks/controller"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.CHARGER).pattern("aba").pattern("a  ").pattern("aba").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), ConventionTags.COPPER_INGOT).unlockedBy("has_crystals/fluix", CraftingRecipes.has(ConventionTags.ALL_FLUIX)).save(consumer, AppEng.makeId("network/blocks/crystal_processing_charger"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.CRANK).pattern("aaa").pattern("  a").pattern("  b").define(Character.valueOf('a'), ConventionTags.WOOD_STICK).define(Character.valueOf('b'), ConventionTags.COPPER_INGOT).unlockedBy("has_stick", CraftingRecipes.has(ConventionTags.WOOD_STICK)).unlockedBy("has_copper_ingot", CraftingRecipes.has(ConventionTags.COPPER_INGOT)).save(consumer, AppEng.makeId("network/blocks/crank"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.GROWTH_ACCELERATOR).pattern("aba").pattern("cdc").pattern("aba").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('c'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('d'), AEBlocks.FLUIX_BLOCK).unlockedBy("has_fluix_block", CraftingRecipes.has(AEBlocks.FLUIX_BLOCK)).unlockedBy("has_glass_cable", CraftingRecipes.has(AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT))).unlockedBy("has_quartz_glass", CraftingRecipes.has(AEBlocks.QUARTZ_GLASS)).save(consumer, AppEng.makeId("network/blocks/crystal_processing_growth_accelerator"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.DENSE_ENERGY_CELL).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), AEBlocks.ENERGY_CELL).define(Character.valueOf('b'), AEItems.CALCULATION_PROCESSOR).unlockedBy("has_energy_cell", CraftingRecipes.has(AEBlocks.ENERGY_CELL)).save(consumer, AppEng.makeId("network/blocks/energy_dense_energy_cell"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.ENERGY_ACCEPTOR).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('c'), ConventionTags.COPPER_INGOT).unlockedBy("has_crystals/fluix", CraftingRecipes.has(ConventionTags.ALL_FLUIX)).save(consumer, AppEng.makeId("network/blocks/energy_energy_acceptor"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEBlocks.ENERGY_ACCEPTOR).requires(AEParts.ENERGY_ACCEPTOR).unlockedBy("has_cable_energy_acceptor", CraftingRecipes.has(AEParts.ENERGY_ACCEPTOR)).save(consumer, AppEng.makeId("network/blocks/energy_energy_acceptor_alt"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.ENERGY_CELL).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), ConventionTags.ALL_CERTUS_QUARTZ).define(Character.valueOf('b'), ConventionTags.FLUIX_DUST).define(Character.valueOf('c'), AEBlocks.QUARTZ_GLASS).unlockedBy("has_quartz_glass", CraftingRecipes.has(AEBlocks.QUARTZ_GLASS)).unlockedBy("has_dusts/fluix", CraftingRecipes.has(ConventionTags.FLUIX_DUST)).unlockedBy("has_crystals/certus", CraftingRecipes.has(ConventionTags.ALL_CERTUS_QUARTZ)).save(consumer, AppEng.makeId("network/blocks/energy_energy_cell"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.VIBRATION_CHAMBER).pattern("ded").pattern("aba").pattern("aca").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)Items.FURNACE).define(Character.valueOf('c'), AEBlocks.ENERGY_ACCEPTOR).define(Character.valueOf('d'), ConventionTags.COPPER_INGOT).define(Character.valueOf('e'), ConventionTags.FLUIX_CRYSTAL).unlockedBy("has_energy_acceptor", CraftingRecipes.has(AEBlocks.ENERGY_ACCEPTOR)).save(consumer, AppEng.makeId("network/blocks/energy_vibration_chamber"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.INSCRIBER).pattern("aba").pattern("c a").pattern("aba").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)Items.PISTON).define(Character.valueOf('c'), ConventionTags.COPPER_INGOT).unlockedBy("has_crystals/fluix", CraftingRecipes.has(ConventionTags.ALL_FLUIX)).save(consumer, AppEng.makeId("network/blocks/inscribers"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.CONDENSER).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), ConventionTags.GLASS).define(Character.valueOf('c'), ConventionTags.FLUIX_DUST).unlockedBy("has_dusts/fluix", CraftingRecipes.has(ConventionTags.FLUIX_DUST)).save(consumer, AppEng.makeId("network/blocks/io_condenser"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.IO_PORT).pattern("aaa").pattern("bcb").pattern("ded").define(Character.valueOf('a'), ConventionTags.GLASS).define(Character.valueOf('b'), AEBlocks.DRIVE).define(Character.valueOf('c'), AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).define(Character.valueOf('e'), AEItems.LOGIC_PROCESSOR).unlockedBy("has_drive", CraftingRecipes.has(AEBlocks.DRIVE)).save(consumer, AppEng.makeId("network/blocks/io_port"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.PATTERN_PROVIDER).pattern("aba").pattern("c d").pattern("aba").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)Items.CRAFTING_TABLE).define(Character.valueOf('c'), AEItems.ANNIHILATION_CORE).define(Character.valueOf('d'), AEItems.FORMATION_CORE).unlockedBy("has_annihilation_core", CraftingRecipes.has(AEItems.ANNIHILATION_CORE)).unlockedBy("has_formation_core", CraftingRecipes.has(AEItems.FORMATION_CORE)).save(consumer, AppEng.makeId("network/blocks/pattern_providers_interface"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEBlocks.PATTERN_PROVIDER).requires(AEParts.PATTERN_PROVIDER).unlockedBy("has_cable_pattern_provider", CraftingRecipes.has(AEParts.PATTERN_PROVIDER)).save(consumer, AppEng.makeId("network/blocks/pattern_providers_interface_alt"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.PATTERN_PROVIDER).requires(AEBlocks.PATTERN_PROVIDER).unlockedBy("has_pattern_provider", CraftingRecipes.has(AEBlocks.PATTERN_PROVIDER)).save(consumer, AppEng.makeId("network/blocks/pattern_providers_interface_part"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.INTERFACE).pattern("aba").pattern("c d").pattern("aba").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), ConventionTags.GLASS).define(Character.valueOf('c'), AEItems.ANNIHILATION_CORE).define(Character.valueOf('d'), AEItems.FORMATION_CORE).unlockedBy("has_annihilation_core", CraftingRecipes.has(AEItems.ANNIHILATION_CORE)).unlockedBy("has_formation_core", CraftingRecipes.has(AEItems.FORMATION_CORE)).save(consumer, AppEng.makeId("network/blocks/interfaces_interface"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEBlocks.INTERFACE).requires(AEParts.INTERFACE).unlockedBy("has_cable_interface", CraftingRecipes.has(AEParts.INTERFACE)).save(consumer, AppEng.makeId("network/blocks/interfaces_interface_alt"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.INTERFACE).requires(AEBlocks.INTERFACE).unlockedBy("has_interface", CraftingRecipes.has(AEBlocks.INTERFACE)).save(consumer, AppEng.makeId("network/blocks/interfaces_interface_part"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.QUANTUM_LINK).pattern("aba").pattern("b b").pattern("aba").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), AEItems.FLUIX_PEARL).unlockedBy("has_fluix_pearl", CraftingRecipes.has(AEItems.FLUIX_PEARL)).save(consumer, AppEng.makeId("network/blocks/quantum_link"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.QUANTUM_RING).pattern("aba").pattern("cde").pattern("aba").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), AEItems.LOGIC_PROCESSOR).define(Character.valueOf('c'), AEItems.ENGINEERING_PROCESSOR).define(Character.valueOf('d'), AEBlocks.ENERGY_CELL).define(Character.valueOf('e'), ConventionTags.SMART_DENSE_CABLE).unlockedBy("has_fluix_smart_dense_cable", CraftingRecipes.has(ConventionTags.SMART_DENSE_CABLE)).unlockedBy("has_energy_cell", CraftingRecipes.has(AEBlocks.ENERGY_CELL)).unlockedBy("has_logic_processor", CraftingRecipes.has(AEItems.LOGIC_PROCESSOR)).unlockedBy("has_engineering_processor", CraftingRecipes.has(AEItems.ENGINEERING_PROCESSOR)).save(consumer, AppEng.makeId("network/blocks/quantum_ring"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.SPATIAL_ANCHOR).pattern("aaa").pattern("bcb").pattern("ded").define(Character.valueOf('a'), AEBlocks.SPATIAL_PYLON).define(Character.valueOf('b'), AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('c'), AEItems.SPATIAL_128_CELL_COMPONENT).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).define(Character.valueOf('e'), AEItems.ENGINEERING_PROCESSOR).unlockedBy("has_128_cubed_spatial_cell_component", CraftingRecipes.has(AEItems.SPATIAL_128_CELL_COMPONENT)).unlockedBy("has_spatial_pylon", CraftingRecipes.has(AEBlocks.SPATIAL_PYLON)).save(consumer, AppEng.makeId("network/blocks/spatial_anchor"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.SPATIAL_IO_PORT).pattern("aaa").pattern("bcb").pattern("ded").define(Character.valueOf('a'), ConventionTags.GLASS).define(Character.valueOf('b'), AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('c'), AEBlocks.IO_PORT).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).define(Character.valueOf('e'), AEItems.ENGINEERING_PROCESSOR).unlockedBy("has_io_port", CraftingRecipes.has(AEBlocks.IO_PORT)).unlockedBy("has_engineering_processor", CraftingRecipes.has(AEItems.ENGINEERING_PROCESSOR)).save(consumer, AppEng.makeId("network/blocks/spatial_io_port"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.SPATIAL_PYLON).pattern("aba").pattern("cdc").pattern("aba").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('c'), ConventionTags.FLUIX_DUST).define(Character.valueOf('d'), ConventionTags.ALL_FLUIX).unlockedBy("has_crystals/fluix", CraftingRecipes.has(ConventionTags.ALL_FLUIX)).unlockedBy("has_glass_cable", CraftingRecipes.has(AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT))).save(consumer, AppEng.makeId("network/blocks/spatial_io_pylon"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.ME_CHEST).pattern("aba").pattern("c c").pattern("ded").define(Character.valueOf('a'), ConventionTags.GLASS).define(Character.valueOf('b'), AEParts.TERMINAL).define(Character.valueOf('c'), AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).define(Character.valueOf('e'), ConventionTags.COPPER_INGOT).unlockedBy("has_glass_cable", CraftingRecipes.has(AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT))).unlockedBy("has_terminal", CraftingRecipes.has(AEParts.TERMINAL)).unlockedBy("has_crystals/fluix", CraftingRecipes.has(ConventionTags.ALL_FLUIX)).save(consumer, AppEng.makeId("network/blocks/storage_chest"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.DRIVE).pattern("aba").pattern("c c").pattern("aba").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), AEItems.ENGINEERING_PROCESSOR).define(Character.valueOf('c'), AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).unlockedBy("has_engineering_processor", CraftingRecipes.has(AEItems.ENGINEERING_PROCESSOR)).save(consumer, AppEng.makeId("network/blocks/storage_drive"));
        CraftingRecipes.addCables(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.ITEM_CELL_HOUSING).pattern("aba").pattern("b b").pattern("cdc").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), ConventionTags.IRON_INGOT).define(Character.valueOf('d'), ConventionTags.COPPER_INGOT).unlockedBy("has_dusts/redstone", CraftingRecipes.has(ConventionTags.REDSTONE)).save(consumer, AppEng.makeId("network/cells/item_cell_housing"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.FLUID_CELL_HOUSING).pattern("aba").pattern("b b").pattern("ccc").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), ConventionTags.COPPER_INGOT).unlockedBy("has_dusts/redstone", CraftingRecipes.has(ConventionTags.REDSTONE)).save(consumer, AppEng.makeId("network/cells/fluid_cell_housing"));
        this.addFluidCells(consumer);
        this.addItemCells(consumer);
        this.addSpatialCells(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.VIEW_CELL).pattern("aba").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), ConventionTags.ALL_CERTUS_QUARTZ).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).unlockedBy("has_terminal", CraftingRecipes.has(AEParts.TERMINAL)).save(consumer, AppEng.makeId("network/cells/view_cell"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.VIEW_CELL).requires(AEItems.ITEM_CELL_HOUSING).requires(ConventionTags.ALL_CERTUS_QUARTZ).unlockedBy("has_terminal", CraftingRecipes.has(AEParts.TERMINAL)).save(consumer, AppEng.makeId("network/cells/view_cell_storage"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.CRAFTING_UNIT).pattern("aba").pattern("cdc").pattern("aba").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), AEItems.CALCULATION_PROCESSOR).define(Character.valueOf('c'), AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('d'), AEItems.LOGIC_PROCESSOR).unlockedBy("has_calculation_processor", CraftingRecipes.has(AEItems.CALCULATION_PROCESSOR)).save(consumer, AppEng.makeId("network/crafting/cpu_crafting_unit"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEBlocks.CRAFTING_STORAGE_1K).requires(AEBlocks.CRAFTING_UNIT).requires(AEItems.CELL_COMPONENT_1K).unlockedBy("has_crafting_unit", CraftingRecipes.has(AEBlocks.CRAFTING_UNIT)).save(consumer, AppEng.makeId("network/crafting/1k_cpu_crafting_storage"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEBlocks.CRAFTING_STORAGE_4K).requires(AEBlocks.CRAFTING_UNIT).requires(AEItems.CELL_COMPONENT_4K).unlockedBy("has_crafting_unit", CraftingRecipes.has(AEBlocks.CRAFTING_UNIT)).save(consumer, AppEng.makeId("network/crafting/4k_cpu_crafting_storage"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEBlocks.CRAFTING_STORAGE_16K).requires(AEBlocks.CRAFTING_UNIT).requires(AEItems.CELL_COMPONENT_16K).unlockedBy("has_crafting_unit", CraftingRecipes.has(AEBlocks.CRAFTING_UNIT)).save(consumer, AppEng.makeId("network/crafting/16k_cpu_crafting_storage"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEBlocks.CRAFTING_STORAGE_64K).requires(AEBlocks.CRAFTING_UNIT).requires(AEItems.CELL_COMPONENT_64K).unlockedBy("has_crafting_unit", CraftingRecipes.has(AEBlocks.CRAFTING_UNIT)).save(consumer, AppEng.makeId("network/crafting/64k_cpu_crafting_storage"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEBlocks.CRAFTING_STORAGE_256K).requires(AEBlocks.CRAFTING_UNIT).requires(AEItems.CELL_COMPONENT_256K).unlockedBy("has_crafting_unit", CraftingRecipes.has(AEBlocks.CRAFTING_UNIT)).save(consumer, AppEng.makeId("network/crafting/256k_cpu_crafting_storage"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEBlocks.CRAFTING_ACCELERATOR).requires(AEBlocks.CRAFTING_UNIT).requires(AEItems.ENGINEERING_PROCESSOR).unlockedBy("has_crafting_unit", CraftingRecipes.has(AEBlocks.CRAFTING_UNIT)).save(consumer, AppEng.makeId("network/crafting/cpu_crafting_accelerator"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEBlocks.CRAFTING_MONITOR).requires(AEBlocks.CRAFTING_UNIT).requires(AEParts.STORAGE_MONITOR).unlockedBy("has_crafting_unit", CraftingRecipes.has(AEBlocks.CRAFTING_UNIT)).save(consumer, AppEng.makeId("network/crafting/cpu_crafting_monitor"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEBlocks.MOLECULAR_ASSEMBLER).pattern("aba").pattern("cde").pattern("aba").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('c'), AEItems.ANNIHILATION_CORE).define(Character.valueOf('d'), (ItemLike)Items.CRAFTING_TABLE).define(Character.valueOf('e'), AEItems.FORMATION_CORE).unlockedBy("has_formation_core", CraftingRecipes.has(AEItems.FORMATION_CORE)).unlockedBy("has_annihilation_core", CraftingRecipes.has(AEItems.ANNIHILATION_CORE)).save(consumer, AppEng.makeId("network/crafting/molecular_assembler"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.BLANK_PATTERN, (int)2).pattern("aba").pattern("bcb").pattern("ded").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.GLOWSTONE).define(Character.valueOf('c'), ConventionTags.ALL_CERTUS_QUARTZ).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).define(Character.valueOf('e'), ConventionTags.COPPER_INGOT).unlockedBy("has_pattern_encoding_terminal", CraftingRecipes.has(AEParts.PATTERN_ENCODING_TERMINAL)).save(consumer, AppEng.makeId("network/crafting/patterns_blank"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.ENERGY_ACCEPTOR).requires(AEBlocks.ENERGY_ACCEPTOR).unlockedBy("has_energy_acceptor", CraftingRecipes.has(AEBlocks.ENERGY_ACCEPTOR)).save(consumer, AppEng.makeId("network/parts/energy_acceptor"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.ANNIHILATION_PLANE).pattern("aaa").pattern("bcb").define(Character.valueOf('a'), ConventionTags.ALL_FLUIX).define(Character.valueOf('b'), ConventionTags.IRON_INGOT).define(Character.valueOf('c'), AEItems.ANNIHILATION_CORE).unlockedBy("has_annihilation_core", CraftingRecipes.has(AEItems.ANNIHILATION_CORE)).save(consumer, AppEng.makeId("network/parts/annihilation_plane_alt"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.ANNIHILATION_PLANE).pattern("ab").pattern("cb").pattern("ab").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), ConventionTags.ALL_FLUIX).define(Character.valueOf('c'), AEItems.ANNIHILATION_CORE).unlockedBy("has_annihilation_core", CraftingRecipes.has(AEItems.ANNIHILATION_CORE)).save(consumer, AppEng.makeId("network/parts/annihilation_plane_alt2"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.EXPORT_BUS).pattern("aba").pattern(" c ").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), AEItems.FORMATION_CORE).define(Character.valueOf('c'), (ItemLike)Items.PISTON).unlockedBy("has_formation_core", CraftingRecipes.has(AEItems.FORMATION_CORE)).save(consumer, AppEng.makeId("network/parts/export_bus"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.FORMATION_PLANE).pattern("aaa").pattern("bcb").define(Character.valueOf('a'), ConventionTags.ALL_FLUIX).define(Character.valueOf('b'), ConventionTags.IRON_INGOT).define(Character.valueOf('c'), AEItems.FORMATION_CORE).unlockedBy("has_formation_core", CraftingRecipes.has(AEItems.FORMATION_CORE)).save(consumer, AppEng.makeId("network/parts/formation_plane"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.FORMATION_PLANE).pattern("ab").pattern("cb").pattern("ab").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), ConventionTags.ALL_FLUIX).define(Character.valueOf('c'), AEItems.FORMATION_CORE).unlockedBy("has_formation_core", CraftingRecipes.has(AEItems.FORMATION_CORE)).save(consumer, AppEng.makeId("network/parts/formation_plane_alt"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.IMPORT_BUS).pattern(" a ").pattern("bcb").define(Character.valueOf('a'), AEItems.ANNIHILATION_CORE).define(Character.valueOf('b'), ConventionTags.IRON_INGOT).define(Character.valueOf('c'), (ItemLike)Items.PISTON).unlockedBy("has_annihilation_core", CraftingRecipes.has(AEItems.ANNIHILATION_CORE)).save(consumer, AppEng.makeId("network/parts/import_bus"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.LEVEL_EMITTER).requires((ItemLike)Items.REDSTONE_TORCH).requires(AEItems.CALCULATION_PROCESSOR).unlockedBy("has_calculation_processor", CraftingRecipes.has(AEItems.CALCULATION_PROCESSOR)).save(consumer, AppEng.makeId("network/parts/level_emitter"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.ENERGY_LEVEL_EMITTER).requires((ItemLike)Items.REDSTONE_TORCH).requires(AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED).requires(AEItems.CALCULATION_PROCESSOR).unlockedBy("has_calculation_processor", CraftingRecipes.has(AEItems.CALCULATION_PROCESSOR)).save(consumer, AppEng.makeId("network/parts/energy_level_emitter"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.STORAGE_BUS).requires((ItemLike)Items.PISTON).requires(ConventionTags.INTERFACE).requires((ItemLike)Items.PISTON).unlockedBy("has_interface", CraftingRecipes.has(ConventionTags.INTERFACE)).save(consumer, AppEng.makeId("network/parts/storage_bus"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.CONVERSION_MONITOR).requires(AEItems.FORMATION_CORE).requires(AEParts.STORAGE_MONITOR).requires(AEItems.ANNIHILATION_CORE).unlockedBy("has_storage_monitor", CraftingRecipes.has(AEParts.STORAGE_MONITOR)).save(consumer, AppEng.makeId("network/parts/monitors_conversion"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.STORAGE_MONITOR).requires(AEParts.LEVEL_EMITTER).requires(ConventionTags.ILLUMINATED_PANEL).unlockedBy("has_illuminated_panel", CraftingRecipes.has(ConventionTags.ILLUMINATED_PANEL)).unlockedBy("has_level_emitter", CraftingRecipes.has(AEParts.LEVEL_EMITTER)).save(consumer, AppEng.makeId("network/parts/monitors_storage"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.DARK_MONITOR).requires(AEParts.MONITOR).unlockedBy("has_monitor", CraftingRecipes.has(AEParts.MONITOR)).save(consumer, AppEng.makeId("network/parts/panels_dark_monitor"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.MONITOR).requires(AEParts.SEMI_DARK_MONITOR).unlockedBy("has_semi_dark_monitor", CraftingRecipes.has(AEParts.SEMI_DARK_MONITOR)).save(consumer, AppEng.makeId("network/parts/panels_monitor"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.SEMI_DARK_MONITOR, (int)3).pattern(" ab").pattern("cdb").pattern(" ab").define(Character.valueOf('a'), ConventionTags.GLOWSTONE).define(Character.valueOf('b'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('c'), ConventionTags.IRON_INGOT).define(Character.valueOf('d'), ConventionTags.REDSTONE).unlockedBy("has_quartz_glass", CraftingRecipes.has(AEBlocks.QUARTZ_GLASS)).save(consumer, AppEng.makeId("network/parts/panels_semi_dark_monitor"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.SEMI_DARK_MONITOR).requires(AEParts.DARK_MONITOR).unlockedBy("has_dark_monitor", CraftingRecipes.has(AEParts.DARK_MONITOR)).save(consumer, AppEng.makeId("network/parts/panels_semi_dark_monitor_alt"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.QUARTZ_FIBER, (int)3).pattern("aaa").pattern("bbb").pattern("aaa").define(Character.valueOf('a'), ConventionTags.GLASS).define(Character.valueOf('b'), ConventionTags.ALL_QUARTZ_DUST).unlockedBy("has_dusts/quartz", CraftingRecipes.has(ConventionTags.ALL_QUARTZ_DUST)).save(consumer, AppEng.makeId("network/parts/quartz_fiber_part"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.TERMINAL).requires(AEItems.FORMATION_CORE).requires(ConventionTags.ILLUMINATED_PANEL).requires(AEItems.LOGIC_PROCESSOR).requires(AEItems.ANNIHILATION_CORE).unlockedBy("has_formation_core", CraftingRecipes.has(AEItems.FORMATION_CORE)).unlockedBy("has_illuminated_panel", CraftingRecipes.has(ConventionTags.ILLUMINATED_PANEL)).unlockedBy("has_logic_processor", CraftingRecipes.has(AEItems.LOGIC_PROCESSOR)).unlockedBy("has_annihilation_core", CraftingRecipes.has(AEItems.ANNIHILATION_CORE)).save(consumer, AppEng.makeId("network/parts/terminals"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.CRAFTING_TERMINAL).requires(AEParts.TERMINAL).requires((ItemLike)Items.CRAFTING_TABLE).requires(AEItems.CALCULATION_PROCESSOR).unlockedBy("has_terminal", CraftingRecipes.has(AEParts.TERMINAL)).unlockedBy("has_calculation_processor", CraftingRecipes.has(AEItems.CALCULATION_PROCESSOR)).save(consumer, AppEng.makeId("network/parts/terminals_crafting"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.PATTERN_ACCESS_TERMINAL).requires(ConventionTags.ILLUMINATED_PANEL).requires(AEItems.ENGINEERING_PROCESSOR).requires(ConventionTags.PATTERN_PROVIDER).unlockedBy("has_pattern_provider", CraftingRecipes.has(ConventionTags.PATTERN_PROVIDER)).save(consumer, AppEng.makeId("network/parts/terminals_pattern_access"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.PATTERN_ENCODING_TERMINAL).requires(AEItems.ENGINEERING_PROCESSOR).requires(AEParts.CRAFTING_TERMINAL).unlockedBy("has_crafting_terminal", CraftingRecipes.has(AEParts.CRAFTING_TERMINAL)).save(consumer, AppEng.makeId("network/parts/terminals_pattern_encoding"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.TOGGLE_BUS).pattern(" a ").pattern("bcb").pattern(" a ").define(Character.valueOf('a'), ConventionTags.REDSTONE).define(Character.valueOf('b'), AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('c'), (ItemLike)Items.LEVER).unlockedBy("has_glass_cable", CraftingRecipes.has(AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT))).save(consumer, AppEng.makeId("network/parts/toggle_bus"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.TOGGLE_BUS).requires(AEParts.INVERTED_TOGGLE_BUS).unlockedBy("has_inverted_toggle_bus", CraftingRecipes.has(AEParts.INVERTED_TOGGLE_BUS)).save(consumer, AppEng.makeId("network/parts/toggle_bus_alt"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.INVERTED_TOGGLE_BUS).requires(AEParts.TOGGLE_BUS).unlockedBy("has_toggle_bus", CraftingRecipes.has(AEParts.TOGGLE_BUS)).save(consumer, AppEng.makeId("network/parts/toggle_bus_inverted_alt"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.ME_P2P_TUNNEL).pattern(" a ").pattern("aba").pattern("ccc").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), AEItems.ENGINEERING_PROCESSOR).define(Character.valueOf('c'), ConventionTags.ALL_FLUIX).unlockedBy("has_engineering_processor", CraftingRecipes.has(AEItems.ENGINEERING_PROCESSOR)).save(consumer, AppEng.makeId("network/parts/tunnels_me"));
        this.addQuartzTools(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.MATTER_CANNON).pattern("aab").pattern("cd ").pattern("a  ").define(Character.valueOf('a'), ConventionTags.IRON_INGOT).define(Character.valueOf('b'), AEItems.FORMATION_CORE).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_4K).define(Character.valueOf('d'), AEBlocks.ENERGY_CELL).unlockedBy("has_formation_core", CraftingRecipes.has(AEItems.FORMATION_CORE)).save(consumer, AppEng.makeId("tools/matter_cannon"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CHARGED_STAFF).pattern("a  ").pattern(" b ").pattern("  b").define(Character.valueOf('a'), AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED).define(Character.valueOf('b'), ConventionTags.IRON_INGOT).unlockedBy("has_charged_certus_quartz_crystal", CraftingRecipes.has(AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED)).save(consumer, AppEng.makeId("tools/misctools_charged_staff"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.ENTROPY_MANIPULATOR).pattern("ab ").pattern("cd ").pattern("  d").define(Character.valueOf('a'), ConventionTags.ALL_FLUIX).define(Character.valueOf('b'), AEBlocks.ENERGY_CELL).define(Character.valueOf('c'), AEItems.ENGINEERING_PROCESSOR).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).unlockedBy("has_engineering_processor", CraftingRecipes.has(AEItems.ENGINEERING_PROCESSOR)).save(consumer, AppEng.makeId("tools/misctools_entropy_manipulator"));
        this.portableCell(consumer, AEItems.PORTABLE_ITEM_CELL1K);
        this.portableCell(consumer, AEItems.PORTABLE_ITEM_CELL4K);
        this.portableCell(consumer, AEItems.PORTABLE_ITEM_CELL16K);
        this.portableCell(consumer, AEItems.PORTABLE_ITEM_CELL64K);
        this.portableCell(consumer, AEItems.PORTABLE_ITEM_CELL256K);
        this.portableCell(consumer, AEItems.PORTABLE_FLUID_CELL1K);
        this.portableCell(consumer, AEItems.PORTABLE_FLUID_CELL4K);
        this.portableCell(consumer, AEItems.PORTABLE_FLUID_CELL16K);
        this.portableCell(consumer, AEItems.PORTABLE_FLUID_CELL64K);
        this.portableCell(consumer, AEItems.PORTABLE_FLUID_CELL256K);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.COLOR_APPLICATOR).pattern("ab ").pattern("bc ").pattern("  d").define(Character.valueOf('a'), AEItems.FORMATION_CORE).define(Character.valueOf('b'), ConventionTags.IRON_INGOT).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_4K).define(Character.valueOf('d'), AEBlocks.ENERGY_CELL).unlockedBy("has_formation_core", CraftingRecipes.has(AEItems.FORMATION_CORE)).unlockedBy("has_energy_cell", CraftingRecipes.has(AEBlocks.ENERGY_CELL)).save(consumer, AppEng.makeId("tools/network_color_applicator"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.MEMORY_CARD).pattern("abb").pattern("cdc").define(Character.valueOf('a'), AEItems.CALCULATION_PROCESSOR).define(Character.valueOf('b'), ConventionTags.IRON_INGOT).define(Character.valueOf('c'), ConventionTags.GOLD_INGOT).define(Character.valueOf('d'), ConventionTags.REDSTONE).unlockedBy("has_calculation_processor", CraftingRecipes.has(AEItems.CALCULATION_PROCESSOR)).save(consumer, AppEng.makeId("tools/network_memory_card"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.NETWORK_TOOL).requires(ConventionTags.ILLUMINATED_PANEL).requires(ConventionTags.CHEST).requires(ConventionTags.QUARTZ_WRENCH).requires(AEItems.CALCULATION_PROCESSOR).unlockedBy("has_quartz_wrench", CraftingRecipes.has(ConventionTags.QUARTZ_WRENCH)).unlockedBy("has_calculation_processor", CraftingRecipes.has(AEItems.CALCULATION_PROCESSOR)).save(consumer, AppEng.makeId("tools/network_tool"));
        this.addPaintBalls(consumer);
    }

    private void storageCellUpgradeRecipes(RecipeOutput output) {
        this.storageCellUpgradeRecipes(output, List.of(new CellUpgradeTier("1k", AEItems.ITEM_CELL_1K, AEItems.CELL_COMPONENT_1K), new CellUpgradeTier("4k", AEItems.ITEM_CELL_4K, AEItems.CELL_COMPONENT_4K), new CellUpgradeTier("16k", AEItems.ITEM_CELL_16K, AEItems.CELL_COMPONENT_16K), new CellUpgradeTier("64k", AEItems.ITEM_CELL_64K, AEItems.CELL_COMPONENT_64K), new CellUpgradeTier("256k", AEItems.ITEM_CELL_256K, AEItems.CELL_COMPONENT_256K)));
        this.storageCellUpgradeRecipes(output, List.of(new CellUpgradeTier("1k", AEItems.FLUID_CELL_1K, AEItems.CELL_COMPONENT_1K), new CellUpgradeTier("4k", AEItems.FLUID_CELL_4K, AEItems.CELL_COMPONENT_4K), new CellUpgradeTier("16k", AEItems.FLUID_CELL_16K, AEItems.CELL_COMPONENT_16K), new CellUpgradeTier("64k", AEItems.FLUID_CELL_64K, AEItems.CELL_COMPONENT_64K), new CellUpgradeTier("256k", AEItems.FLUID_CELL_256K, AEItems.CELL_COMPONENT_256K)));
        this.storageCellUpgradeRecipes(output, List.of(new CellUpgradeTier("1k", AEItems.PORTABLE_ITEM_CELL1K, AEItems.CELL_COMPONENT_1K), new CellUpgradeTier("4k", AEItems.PORTABLE_ITEM_CELL4K, AEItems.CELL_COMPONENT_4K), new CellUpgradeTier("16k", AEItems.PORTABLE_ITEM_CELL16K, AEItems.CELL_COMPONENT_16K), new CellUpgradeTier("64k", AEItems.PORTABLE_ITEM_CELL64K, AEItems.CELL_COMPONENT_64K), new CellUpgradeTier("256k", AEItems.PORTABLE_ITEM_CELL256K, AEItems.CELL_COMPONENT_256K)));
        this.storageCellUpgradeRecipes(output, List.of(new CellUpgradeTier("1k", AEItems.PORTABLE_FLUID_CELL1K, AEItems.CELL_COMPONENT_1K), new CellUpgradeTier("4k", AEItems.PORTABLE_FLUID_CELL4K, AEItems.CELL_COMPONENT_4K), new CellUpgradeTier("16k", AEItems.PORTABLE_FLUID_CELL16K, AEItems.CELL_COMPONENT_16K), new CellUpgradeTier("64k", AEItems.PORTABLE_FLUID_CELL64K, AEItems.CELL_COMPONENT_64K), new CellUpgradeTier("256k", AEItems.PORTABLE_FLUID_CELL256K, AEItems.CELL_COMPONENT_256K)));
    }

    private void storageCellUpgradeRecipes(RecipeOutput output, List<CellUpgradeTier> tiers) {
        for (int i = 0; i < tiers.size(); ++i) {
            CellUpgradeTier fromTier = tiers.get(i);
            Object inputCell = fromTier.cell().asItem();
            ResourceLocation inputId = fromTier.cell().id();
            Item resultComponent = fromTier.component().asItem();
            for (int j = i + 1; j < tiers.size(); ++j) {
                CellUpgradeTier toTier = tiers.get(j);
                Object resultCell = toTier.cell().asItem();
                Item inputComponent = toTier.component().asItem();
                ResourceLocation recipeId = inputId.withPath(path -> "upgrade/" + path + "_to_" + toTier.suffix);
                output.accept(recipeId, (Recipe)new StorageCellUpgradeRecipe((Item)inputCell, inputComponent, (Item)resultCell, resultComponent), null);
            }
        }
    }

    private void itemUpgradeRecipe(RecipeOutput output) {
        output.accept(AppEng.makeId("add_item_upgrade"), (Recipe)AddItemUpgradeRecipe.INSTANCE, null);
        output.accept(AppEng.makeId("remove_item_upgrade"), (Recipe)RemoveItemUpgradeRecipe.INSTANCE, null);
    }

    private void portableCell(RecipeOutput consumer, ItemDefinition<PortableCellItem> cell) {
        ItemDefinition<MaterialItem> housing;
        if (cell.get().getKeyType() == AEKeyType.items()) {
            housing = AEItems.ITEM_CELL_HOUSING;
        } else if (cell.get().getKeyType() == AEKeyType.fluids()) {
            housing = AEItems.FLUID_CELL_HOUSING;
        } else {
            throw new RuntimeException("No housing known for " + String.valueOf(cell.get().getKeyType()));
        }
        Item component = cell.get().getTier().componentSupplier().get();
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, cell).requires(AEBlocks.ME_CHEST).requires((ItemLike)component).requires(AEBlocks.ENERGY_CELL).requires(housing).unlockedBy("has_" + housing.id().getPath(), CraftingRecipes.has(housing)).unlockedBy("has_energy_cell", CraftingRecipes.has(AEBlocks.ENERGY_CELL)).save(consumer, cell.get().getRecipeId());
    }

    private void addSpatialCells(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.SPATIAL_2_CELL_COMPONENT).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), ConventionTags.GLOWSTONE).define(Character.valueOf('b'), AEItems.FLUIX_PEARL).define(Character.valueOf('c'), AEItems.ENGINEERING_PROCESSOR).unlockedBy("has_engineering_processor", CraftingRecipes.has(AEItems.ENGINEERING_PROCESSOR)).unlockedBy("has_fluix_pearl", CraftingRecipes.has(AEItems.FLUIX_PEARL)).save(consumer, AppEng.makeId("network/cells/spatial_components"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.SPATIAL_16_CELL_COMPONENT).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), ConventionTags.GLOWSTONE).define(Character.valueOf('b'), AEItems.SPATIAL_2_CELL_COMPONENT).define(Character.valueOf('c'), AEItems.ENGINEERING_PROCESSOR).unlockedBy("has_2_cubed_spatial_cell_component", CraftingRecipes.has(AEItems.SPATIAL_2_CELL_COMPONENT)).save(consumer, AppEng.makeId("network/cells/spatial_components_0"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.SPATIAL_128_CELL_COMPONENT).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), ConventionTags.GLOWSTONE).define(Character.valueOf('b'), AEItems.SPATIAL_16_CELL_COMPONENT).define(Character.valueOf('c'), AEItems.ENGINEERING_PROCESSOR).unlockedBy("has_16_cubed_spatial_cell_component", CraftingRecipes.has(AEItems.SPATIAL_16_CELL_COMPONENT)).save(consumer, AppEng.makeId("network/cells/spatial_components_1"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.SPATIAL_CELL2).pattern("aba").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.SPATIAL_2_CELL_COMPONENT).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).unlockedBy("has_2_cubed_spatial_cell_component", CraftingRecipes.has(AEItems.SPATIAL_2_CELL_COMPONENT)).save(consumer, AppEng.makeId("network/cells/spatial_storage_cell_2_cubed"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.SPATIAL_CELL2).requires(AEItems.ITEM_CELL_HOUSING).requires(AEItems.SPATIAL_2_CELL_COMPONENT).unlockedBy("has_2_cubed_spatial_cell_component", CraftingRecipes.has(AEItems.SPATIAL_2_CELL_COMPONENT)).save(consumer, AppEng.makeId("network/cells/spatial_storage_cell_2_cubed_storage"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.SPATIAL_CELL16).pattern("aba").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.SPATIAL_16_CELL_COMPONENT).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).unlockedBy("has_16_cubed_spatial_cell_component", CraftingRecipes.has(AEItems.SPATIAL_16_CELL_COMPONENT)).save(consumer, AppEng.makeId("network/cells/spatial_storage_cell_16_cubed"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.SPATIAL_CELL16).requires(AEItems.ITEM_CELL_HOUSING).requires(AEItems.SPATIAL_16_CELL_COMPONENT).unlockedBy("has_16_cubed_spatial_cell_component", CraftingRecipes.has(AEItems.SPATIAL_16_CELL_COMPONENT)).save(consumer, AppEng.makeId("network/cells/spatial_storage_cell_16_cubed_storage"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.SPATIAL_CELL128).pattern("aba").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.SPATIAL_128_CELL_COMPONENT).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).unlockedBy("has_128_cubed_spatial_cell_component", CraftingRecipes.has(AEItems.SPATIAL_128_CELL_COMPONENT)).save(consumer, AppEng.makeId("network/cells/spatial_storage_cell_128_cubed"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.SPATIAL_CELL128).requires(AEItems.ITEM_CELL_HOUSING).requires(AEItems.SPATIAL_128_CELL_COMPONENT).unlockedBy("has_128_cubed_spatial_cell_component", CraftingRecipes.has(AEItems.SPATIAL_128_CELL_COMPONENT)).save(consumer, AppEng.makeId("network/cells/spatial_storage_cell_128_cubed_storage"));
    }

    private void addItemCells(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CELL_COMPONENT_1K).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), ConventionTags.REDSTONE).define(Character.valueOf('b'), ConventionTags.ALL_CERTUS_QUARTZ).define(Character.valueOf('c'), AEItems.LOGIC_PROCESSOR).unlockedBy("has_logic_processor", CraftingRecipes.has(AEItems.LOGIC_PROCESSOR)).save(consumer, AppEng.makeId("network/cells/item_storage_components_cell_1k_part"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CELL_COMPONENT_4K).pattern("aba").pattern("cdc").pattern("aca").define(Character.valueOf('a'), ConventionTags.REDSTONE).define(Character.valueOf('b'), AEItems.CALCULATION_PROCESSOR).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_1K).define(Character.valueOf('d'), AEBlocks.QUARTZ_GLASS).unlockedBy("has_cell_component_1k", CraftingRecipes.has(AEItems.CELL_COMPONENT_1K)).save(consumer, AppEng.makeId("network/cells/item_storage_components_cell_4k_part"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CELL_COMPONENT_16K).pattern("aba").pattern("cdc").pattern("aca").define(Character.valueOf('a'), ConventionTags.GLOWSTONE).define(Character.valueOf('b'), AEItems.CALCULATION_PROCESSOR).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_4K).define(Character.valueOf('d'), AEBlocks.QUARTZ_GLASS).unlockedBy("has_cell_component_4k", CraftingRecipes.has(AEItems.CELL_COMPONENT_4K)).save(consumer, AppEng.makeId("network/cells/item_storage_components_cell_16k_part"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CELL_COMPONENT_64K).pattern("aba").pattern("cdc").pattern("aca").define(Character.valueOf('a'), ConventionTags.GLOWSTONE).define(Character.valueOf('b'), AEItems.CALCULATION_PROCESSOR).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_16K).define(Character.valueOf('d'), AEBlocks.QUARTZ_GLASS).unlockedBy("has_cell_component_16k", CraftingRecipes.has(AEItems.CELL_COMPONENT_16K)).save(consumer, AppEng.makeId("network/cells/item_storage_components_cell_64k_part"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CELL_COMPONENT_256K).pattern("aba").pattern("cdc").pattern("aca").define(Character.valueOf('a'), AEItems.SKY_DUST).define(Character.valueOf('b'), AEItems.CALCULATION_PROCESSOR).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_64K).define(Character.valueOf('d'), AEBlocks.QUARTZ_GLASS).unlockedBy("has_cell_component_64k", CraftingRecipes.has(AEItems.CELL_COMPONENT_64K)).save(consumer, AppEng.makeId("network/cells/item_storage_components_cell_256k_part"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.ITEM_CELL_1K).pattern("aba").pattern("bcb").pattern("ded").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_1K).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).define(Character.valueOf('e'), ConventionTags.COPPER_INGOT).unlockedBy("has_cell_component_1k", CraftingRecipes.has(AEItems.CELL_COMPONENT_1K)).save(consumer, AppEng.makeId("network/cells/item_storage_cell_1k"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.ITEM_CELL_1K).requires(AEItems.ITEM_CELL_HOUSING).requires(AEItems.CELL_COMPONENT_1K).unlockedBy("has_cell_component_1k", CraftingRecipes.has(AEItems.CELL_COMPONENT_1K)).unlockedBy("has_item_cell_housing", CraftingRecipes.has(AEItems.ITEM_CELL_HOUSING)).save(consumer, AppEng.makeId("network/cells/item_storage_cell_1k_storage"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.ITEM_CELL_4K).pattern("aba").pattern("bcb").pattern("ded").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_4K).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).define(Character.valueOf('e'), ConventionTags.COPPER_INGOT).unlockedBy("has_cell_component_4k", CraftingRecipes.has(AEItems.CELL_COMPONENT_4K)).save(consumer, AppEng.makeId("network/cells/item_storage_cell_4k"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.ITEM_CELL_4K).requires(AEItems.ITEM_CELL_HOUSING).requires(AEItems.CELL_COMPONENT_4K).unlockedBy("has_cell_component_4k", CraftingRecipes.has(AEItems.CELL_COMPONENT_4K)).save(consumer, AppEng.makeId("network/cells/item_storage_cell_4k_storage"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.ITEM_CELL_16K).pattern("aba").pattern("bcb").pattern("ded").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_16K).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).define(Character.valueOf('e'), ConventionTags.COPPER_INGOT).unlockedBy("has_cell_component_16k", CraftingRecipes.has(AEItems.CELL_COMPONENT_16K)).save(consumer, AppEng.makeId("network/cells/item_storage_cell_16k"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.ITEM_CELL_16K).requires(AEItems.CELL_COMPONENT_16K).requires(AEItems.ITEM_CELL_HOUSING).unlockedBy("has_cell_component_16k", CraftingRecipes.has(AEItems.CELL_COMPONENT_16K)).save(consumer, AppEng.makeId("network/cells/item_storage_cell_16k_storage"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.ITEM_CELL_64K).pattern("aba").pattern("bcb").pattern("ded").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_64K).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).define(Character.valueOf('e'), ConventionTags.COPPER_INGOT).unlockedBy("has_cell_component_64k", CraftingRecipes.has(AEItems.CELL_COMPONENT_64K)).save(consumer, AppEng.makeId("network/cells/item_storage_cell_64k"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.ITEM_CELL_64K).requires(AEItems.ITEM_CELL_HOUSING).requires(AEItems.CELL_COMPONENT_64K).unlockedBy("has_cell_component_64k", CraftingRecipes.has(AEItems.CELL_COMPONENT_64K)).save(consumer, AppEng.makeId("network/cells/item_storage_cell_64k_storage"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.ITEM_CELL_256K).pattern("aba").pattern("bcb").pattern("ded").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_256K).define(Character.valueOf('d'), ConventionTags.IRON_INGOT).define(Character.valueOf('e'), ConventionTags.COPPER_INGOT).unlockedBy("has_cell_component_256k", CraftingRecipes.has(AEItems.CELL_COMPONENT_256K)).save(consumer, AppEng.makeId("network/cells/item_storage_cell_256k"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.ITEM_CELL_256K).requires(AEItems.ITEM_CELL_HOUSING).requires(AEItems.CELL_COMPONENT_256K).unlockedBy("has_cell_component_256k", CraftingRecipes.has(AEItems.CELL_COMPONENT_256K)).save(consumer, AppEng.makeId("network/cells/item_storage_cell_256k_storage"));
    }

    private void addFluidCells(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.FLUID_CELL_1K).pattern("aba").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_1K).define(Character.valueOf('d'), ConventionTags.COPPER_INGOT).unlockedBy("has_cell_component_1k", CraftingRecipes.has(AEItems.CELL_COMPONENT_1K)).save(consumer, AppEng.makeId("network/cells/fluid_storage_cell_1k"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.FLUID_CELL_1K).requires(AEItems.FLUID_CELL_HOUSING).requires(AEItems.CELL_COMPONENT_1K).unlockedBy("has_item_cell_housing", CraftingRecipes.has(AEItems.FLUID_CELL_HOUSING)).unlockedBy("has_cell_component_1k", CraftingRecipes.has(AEItems.CELL_COMPONENT_1K)).save(consumer, AppEng.makeId("network/cells/fluid_storage_cell_1k_storage"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.FLUID_CELL_4K).pattern("aba").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_4K).define(Character.valueOf('d'), ConventionTags.COPPER_INGOT).unlockedBy("has_cell_component_4k", CraftingRecipes.has(AEItems.CELL_COMPONENT_4K)).save(consumer, AppEng.makeId("network/cells/fluid_storage_cell_4k"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.FLUID_CELL_4K).requires(AEItems.FLUID_CELL_HOUSING).requires(AEItems.CELL_COMPONENT_4K).unlockedBy("has_cell_component_4k", CraftingRecipes.has(AEItems.CELL_COMPONENT_4K)).save(consumer, AppEng.makeId("network/cells/fluid_storage_cell_4k_storage"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.FLUID_CELL_16K).pattern("aba").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_16K).define(Character.valueOf('d'), ConventionTags.COPPER_INGOT).unlockedBy("has_cell_component_16k", CraftingRecipes.has(AEItems.CELL_COMPONENT_16K)).save(consumer, AppEng.makeId("network/cells/fluid_storage_cell_16k"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.FLUID_CELL_16K).requires(AEItems.FLUID_CELL_HOUSING).requires(AEItems.CELL_COMPONENT_16K).unlockedBy("has_cell_component_16k", CraftingRecipes.has(AEItems.CELL_COMPONENT_16K)).save(consumer, AppEng.makeId("network/cells/fluid_storage_cell_16k_storage"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.FLUID_CELL_64K).pattern("aba").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_64K).define(Character.valueOf('d'), ConventionTags.COPPER_INGOT).unlockedBy("has_cell_component_64k", CraftingRecipes.has(AEItems.CELL_COMPONENT_64K)).save(consumer, AppEng.makeId("network/cells/fluid_storage_cell_64k"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.FLUID_CELL_64K).requires(AEItems.FLUID_CELL_HOUSING).requires(AEItems.CELL_COMPONENT_64K).unlockedBy("has_cell_component_64k", CraftingRecipes.has(AEItems.CELL_COMPONENT_64K)).save(consumer, AppEng.makeId("network/cells/fluid_storage_cell_64k_storage"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.FLUID_CELL_256K).pattern("aba").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), ConventionTags.REDSTONE).define(Character.valueOf('c'), AEItems.CELL_COMPONENT_256K).define(Character.valueOf('d'), ConventionTags.COPPER_INGOT).unlockedBy("has_cell_component_256k", CraftingRecipes.has(AEItems.CELL_COMPONENT_256K)).save(consumer, AppEng.makeId("network/cells/fluid_storage_cell_256k"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.FLUID_CELL_256K).requires(AEItems.FLUID_CELL_HOUSING).requires(AEItems.CELL_COMPONENT_256K).unlockedBy("has_cell_component_256k", CraftingRecipes.has(AEItems.CELL_COMPONENT_256K)).save(consumer, AppEng.makeId("network/cells/fluid_storage_cell_256k_storage"));
    }

    private void addQuartzTools(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_AXE).pattern("aa").pattern("ab").pattern(" b").define(Character.valueOf('a'), ConventionTags.CERTUS_QUARTZ).define(Character.valueOf('b'), ConventionTags.WOOD_STICK).unlockedBy("has_certus_quartz", CraftingRecipes.has(ConventionTags.CERTUS_QUARTZ)).save(consumer, AppEng.makeId("tools/certus_quartz_axe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_HOE).pattern("aa").pattern(" b").pattern(" b").define(Character.valueOf('a'), ConventionTags.CERTUS_QUARTZ).define(Character.valueOf('b'), ConventionTags.WOOD_STICK).unlockedBy("has_certus_quartz", CraftingRecipes.has(ConventionTags.CERTUS_QUARTZ)).save(consumer, AppEng.makeId("tools/certus_quartz_hoe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_PICK).pattern("aaa").pattern(" b ").pattern(" b ").define(Character.valueOf('a'), ConventionTags.CERTUS_QUARTZ).define(Character.valueOf('b'), ConventionTags.WOOD_STICK).unlockedBy("has_certus_quartz", CraftingRecipes.has(ConventionTags.CERTUS_QUARTZ)).save(consumer, AppEng.makeId("tools/certus_quartz_pickaxe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_SHOVEL).pattern("a").pattern("b").pattern("b").define(Character.valueOf('a'), ConventionTags.CERTUS_QUARTZ).define(Character.valueOf('b'), ConventionTags.WOOD_STICK).unlockedBy("has_certus_quartz", CraftingRecipes.has(ConventionTags.CERTUS_QUARTZ)).save(consumer, AppEng.makeId("tools/certus_quartz_spade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_SWORD).pattern("a").pattern("a").pattern("b").define(Character.valueOf('a'), ConventionTags.CERTUS_QUARTZ).define(Character.valueOf('b'), ConventionTags.WOOD_STICK).unlockedBy("has_certus_quartz", CraftingRecipes.has(ConventionTags.CERTUS_QUARTZ)).save(consumer, AppEng.makeId("tools/certus_quartz_sword"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.NETHER_QUARTZ_AXE).pattern("aa").pattern("ab").pattern(" b").define(Character.valueOf('a'), ConventionTags.NETHER_QUARTZ).define(Character.valueOf('b'), ConventionTags.WOOD_STICK).unlockedBy("has_nether_quartz", CraftingRecipes.has(ConventionTags.NETHER_QUARTZ)).save(consumer, AppEng.makeId("tools/nether_quartz_axe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.NETHER_QUARTZ_HOE).pattern("aa").pattern(" b").pattern(" b").define(Character.valueOf('a'), ConventionTags.NETHER_QUARTZ).define(Character.valueOf('b'), ConventionTags.WOOD_STICK).unlockedBy("has_nether_quartz", CraftingRecipes.has(ConventionTags.NETHER_QUARTZ)).save(consumer, AppEng.makeId("tools/nether_quartz_hoe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.NETHER_QUARTZ_PICK).pattern("aaa").pattern(" b ").pattern(" b ").define(Character.valueOf('a'), ConventionTags.NETHER_QUARTZ).define(Character.valueOf('b'), ConventionTags.WOOD_STICK).unlockedBy("has_nether_quartz", CraftingRecipes.has(ConventionTags.NETHER_QUARTZ)).save(consumer, AppEng.makeId("tools/nether_quartz_pickaxe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.NETHER_QUARTZ_SHOVEL).pattern("a").pattern("b").pattern("b").define(Character.valueOf('a'), ConventionTags.NETHER_QUARTZ).define(Character.valueOf('b'), ConventionTags.WOOD_STICK).unlockedBy("has_nether_quartz", CraftingRecipes.has(ConventionTags.NETHER_QUARTZ)).save(consumer, AppEng.makeId("tools/nether_quartz_spade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.NETHER_QUARTZ_SWORD).pattern("a").pattern("a").pattern("b").define(Character.valueOf('a'), ConventionTags.NETHER_QUARTZ).define(Character.valueOf('b'), ConventionTags.WOOD_STICK).unlockedBy("has_nether_quartz", CraftingRecipes.has(ConventionTags.NETHER_QUARTZ)).save(consumer, AppEng.makeId("tools/nether_quartz_sword"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_KNIFE).pattern("  a").pattern("ba ").pattern("cc ").define(Character.valueOf('a'), ConventionTags.WOOD_STICK).define(Character.valueOf('b'), ConventionTags.IRON_INGOT).define(Character.valueOf('c'), ConventionTags.CERTUS_QUARTZ).unlockedBy("has_certus_quartz", CraftingRecipes.has(ConventionTags.CERTUS_QUARTZ)).save(consumer, AppEng.makeId("tools/certus_quartz_cutting_knife"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.NETHER_QUARTZ_KNIFE).pattern("  a").pattern("ba ").pattern("cc ").define(Character.valueOf('a'), ConventionTags.WOOD_STICK).define(Character.valueOf('b'), ConventionTags.IRON_INGOT).define(Character.valueOf('c'), ConventionTags.NETHER_QUARTZ).unlockedBy("has_nether_quartz", CraftingRecipes.has(ConventionTags.NETHER_QUARTZ)).save(consumer, AppEng.makeId("tools/nether_quartz_cutting_knife"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.CERTUS_QUARTZ_WRENCH).pattern("a a").pattern(" a ").pattern("a a").define(Character.valueOf('a'), ConventionTags.CERTUS_QUARTZ).unlockedBy("has_certus_quartz", CraftingRecipes.has(ConventionTags.CERTUS_QUARTZ)).save(consumer, AppEng.makeId("tools/certus_quartz_wrench"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEItems.NETHER_QUARTZ_WRENCH).pattern("a a").pattern(" a ").pattern("a a").define(Character.valueOf('a'), ConventionTags.NETHER_QUARTZ).unlockedBy("has_nether_quartz", CraftingRecipes.has(ConventionTags.NETHER_QUARTZ)).save(consumer, AppEng.makeId("tools/nether_quartz_wrench"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEItems.FLUIX_UPGRADE_SMITHING_TEMPLATE).requires((ItemLike)Items.PAPER).requires(ConventionTags.FLUIX_CRYSTAL).unlockedBy("has_fluix_crystal", CraftingRecipes.has(ConventionTags.FLUIX_CRYSTAL)).save(consumer, AppEng.makeId("tools/fluix_upgrade_smithing_template"));
    }

    private static void addCables(RecipeOutput consumer) {
        for (AEColor color : AEColor.VALID_COLORS) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.COVERED_CABLE.item(color), (int)8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('b'), ConventionTags.dye(color.dye)).unlockedBy("has_fluix_covered_cable", CraftingRecipes.has(AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT))).save(consumer, AppEng.makeId("network/cables/covered_" + color.registryPrefix));
        }
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT)).requires(CraftingRecipes.tagExcept(ConventionTags.COVERED_CABLE, AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT))).requires(ConventionTags.CAN_REMOVE_COLOR).unlockedBy("has_covered_cable", CraftingRecipes.has(ConventionTags.COVERED_CABLE)).save(consumer, AppEng.makeId("network/cables/covered_fluix_clean"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT)).requires(ItemTags.WOOL).requires(AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).unlockedBy("has_glass_cable", CraftingRecipes.has(AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT))).save(consumer, AppEng.makeId("network/cables/covered_fluix"));
        for (AEColor color : AEColor.VALID_COLORS) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.COVERED_DENSE_CABLE.item(color), (int)8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), AEParts.COVERED_DENSE_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('b'), ConventionTags.dye(color.dye)).unlockedBy("has_fluix_covered_dense_cable", CraftingRecipes.has(AEParts.COVERED_DENSE_CABLE.item(AEColor.TRANSPARENT))).unlockedBy("has_dyes/black", CraftingRecipes.has(ConventionTags.dye(color.dye))).save(consumer, AppEng.makeId("network/cables/dense_covered_" + color.registryPrefix));
        }
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.COVERED_DENSE_CABLE.item(AEColor.TRANSPARENT)).requires(AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT)).requires(AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT)).requires(AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT)).requires(AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT)).unlockedBy("has_fluix_covered_cable", CraftingRecipes.has(AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT))).save(consumer, AppEng.makeId("network/cables/dense_covered_fluix"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.COVERED_DENSE_CABLE.item(AEColor.TRANSPARENT)).requires(CraftingRecipes.tagExcept(ConventionTags.COVERED_DENSE_CABLE, AEParts.COVERED_DENSE_CABLE.item(AEColor.TRANSPARENT))).requires(ConventionTags.CAN_REMOVE_COLOR).unlockedBy("has_covered_dense_cable", CraftingRecipes.has(ConventionTags.COVERED_DENSE_CABLE)).save(consumer, AppEng.makeId("network/cables/dense_covered_fluix_clean"));
        for (AEColor color : AEColor.VALID_COLORS) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.SMART_DENSE_CABLE.item(color), (int)8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('b'), ConventionTags.dye(color.dye)).unlockedBy("has_dyes/black", CraftingRecipes.has(ConventionTags.dye(color.dye))).unlockedBy("has_fluix_smart_dense_cable", CraftingRecipes.has(AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT))).save(consumer, AppEng.makeId("network/cables/dense_smart_" + color.registryPrefix));
        }
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT)).requires(AEParts.COVERED_DENSE_CABLE.item(AEColor.TRANSPARENT)).requires(ConventionTags.REDSTONE).requires(ConventionTags.GLOWSTONE).unlockedBy("has_fluix_covered_dense_cable", CraftingRecipes.has(AEParts.COVERED_DENSE_CABLE.item(AEColor.TRANSPARENT))).unlockedBy("has_dusts/glowstone", CraftingRecipes.has(ConventionTags.GLOWSTONE)).unlockedBy("has_dusts/redstone", CraftingRecipes.has(ConventionTags.REDSTONE)).save(consumer, AppEng.makeId("network/cables/dense_smart_fluix"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT)).requires(AEParts.SMART_CABLE.item(AEColor.TRANSPARENT)).requires(AEParts.SMART_CABLE.item(AEColor.TRANSPARENT)).requires(AEParts.SMART_CABLE.item(AEColor.TRANSPARENT)).requires(AEParts.SMART_CABLE.item(AEColor.TRANSPARENT)).unlockedBy("has_fluix_smart_cable", CraftingRecipes.has(AEParts.SMART_CABLE.item(AEColor.TRANSPARENT))).save(consumer, AppEng.makeId("network/cables/dense_smart_from_smart"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT)).requires(CraftingRecipes.tagExcept(ConventionTags.SMART_DENSE_CABLE, AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT))).requires(ConventionTags.CAN_REMOVE_COLOR).unlockedBy("has_smart_dense_cable", CraftingRecipes.has(ConventionTags.SMART_DENSE_CABLE)).save(consumer, AppEng.makeId("network/cables/dense_smart_fluix_clean"));
        for (AEColor color : AEColor.VALID_COLORS) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.GLASS_CABLE.item(color), (int)8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('b'), ConventionTags.dye(color.dye)).unlockedBy("has_dyes/black", CraftingRecipes.has(ConventionTags.dye(color.dye))).unlockedBy("has_fluix_glass_cable", CraftingRecipes.has(AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT))).save(consumer, AppEng.makeId("network/cables/glass_" + color.registryPrefix));
        }
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT), (int)4).requires(AEParts.QUARTZ_FIBER).requires(ConventionTags.ALL_FLUIX).requires(ConventionTags.ALL_FLUIX).unlockedBy("has_quartz_fiber", CraftingRecipes.has(AEParts.QUARTZ_FIBER)).unlockedBy("has_crystals/fluix", CraftingRecipes.has(ConventionTags.ALL_FLUIX)).save(consumer, AppEng.makeId("network/cables/glass_fluix"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT)).requires(CraftingRecipes.tagExcept(ConventionTags.GLASS_CABLE, AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT))).requires(ConventionTags.CAN_REMOVE_COLOR).unlockedBy("has_glass_cable", CraftingRecipes.has(ConventionTags.GLASS_CABLE)).save(consumer, AppEng.makeId("network/cables/glass_fluix_clean"));
        for (AEColor color : AEColor.VALID_COLORS) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AEParts.SMART_CABLE.item(color), (int)8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), AEParts.SMART_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('b'), ConventionTags.dye(color.dye)).unlockedBy("has_dyes/black", CraftingRecipes.has(ConventionTags.dye(color.dye))).unlockedBy("has_fluix_smart_cable", CraftingRecipes.has(AEParts.SMART_CABLE.item(AEColor.TRANSPARENT))).save(consumer, AppEng.makeId("network/cables/smart_" + color.registryPrefix));
        }
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.SMART_CABLE.item(AEColor.TRANSPARENT)).requires(AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT)).requires(ConventionTags.REDSTONE).requires(ConventionTags.GLOWSTONE).unlockedBy("has_dusts/redstone", CraftingRecipes.has(ConventionTags.REDSTONE)).unlockedBy("has_dusts/glowstone", CraftingRecipes.has(ConventionTags.GLOWSTONE)).unlockedBy("has_fluix_covered_cable", CraftingRecipes.has(AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT))).save(consumer, AppEng.makeId("network/cables/smart_fluix"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AEParts.SMART_CABLE.item(AEColor.TRANSPARENT)).requires(CraftingRecipes.tagExcept(ConventionTags.SMART_CABLE, AEParts.SMART_CABLE.item(AEColor.TRANSPARENT))).requires(ConventionTags.CAN_REMOVE_COLOR).unlockedBy("has_smart_cable", CraftingRecipes.has(ConventionTags.SMART_CABLE)).save(consumer, AppEng.makeId("network/cables/smart_fluix_clean"));
    }

    private void addPaintBalls(RecipeOutput consumer) {
        for (AEColor color : AEColor.VALID_COLORS) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AEItems.COLORED_PAINT_BALL.item(color), (int)8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), AEItems.MATTER_BALL).define(Character.valueOf('b'), ConventionTags.dye(color.dye)).unlockedBy("has_matter_ball", CraftingRecipes.has(AEItems.MATTER_BALL)).save(consumer, AppEng.makeId("tools/paintballs_" + color.registryPrefix));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AEItems.COLORED_LUMEN_PAINT_BALL.item(color), (int)8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)AEItems.COLORED_PAINT_BALL.item(color)).define(Character.valueOf('b'), ConventionTags.GLOWSTONE).unlockedBy("has_paint_ball", CraftingRecipes.has(ConventionTags.PAINT_BALLS)).save(consumer, AppEng.makeId("tools/paintballs_lumen_" + color.registryPrefix));
        }
    }

    private static Ingredient tagExcept(TagKey<Item> tag, ItemLike exception) {
        return DifferenceIngredient.of((Ingredient)Ingredient.of(tag), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{exception}));
    }

    record CellUpgradeTier(String suffix, ItemDefinition<?> cell, ItemLike component) {
    }
}

