/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GuidebookLightmap
implements AutoCloseable {
    private final DynamicTexture lightmapTexture = new DynamicTexture(16, 16, false);
    private final NativeImage lightmapPixels = Objects.requireNonNull(this.lightmapTexture.getPixels());

    public GuidebookLightmap() {
        this.lightmapPixels.fillRect(0, 0, 16, 16, -1);
        this.lightmapTexture.upload();
    }

    public float getSkyDarken(Level level, float partialTick) {
        float f = level.getTimeOfDay(partialTick);
        float g = 1.0f - (Mth.cos((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        g = Mth.clamp((float)g, (float)0.0f, (float)1.0f);
        g = 1.0f - g;
        return 0.2f + g * 0.8f;
    }

    public void update(Level level) {
        float f = this.getSkyDarken(level, 1.0f);
        Vector3f vector3f = new Vector3f(f, f, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
        float g = f * 0.95f + 0.05f;
        float m = 1.5f;
        Minecraft minecraft = Minecraft.getInstance();
        Vector3f vector3f2 = new Vector3f();
        for (int skyLightLvl = 0; skyLightLvl < 16; ++skyLightLvl) {
            for (int blockLightLvl = 0; blockLightLvl < 16; ++blockLightLvl) {
                float p = LightTexture.getBrightness((DimensionType)level.dimensionType(), (int)skyLightLvl) * g;
                float q = LightTexture.getBrightness((DimensionType)level.dimensionType(), (int)blockLightLvl) * m;
                float s = q * ((q * 0.6f + 0.4f) * 0.6f + 0.4f);
                float t = q * (q * q * 0.6f + 0.4f);
                vector3f2.set(q, s, t);
                Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f).mul(p);
                vector3f2.add((Vector3fc)vector3f3);
                vector3f2.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                float v = ((Double)minecraft.options.gamma().get()).floatValue();
                Vector3f vector3f5 = new Vector3f(this.notGamma(vector3f2.x), this.notGamma(vector3f2.y), this.notGamma(vector3f2.z));
                vector3f2.lerp((Vector3fc)vector3f5, Math.max(0.0f, v));
                vector3f2.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                GuidebookLightmap.clampColor(vector3f2);
                vector3f2.mul(255.0f);
                int x = (int)vector3f2.x();
                int y = (int)vector3f2.y();
                int z = (int)vector3f2.z();
                this.lightmapPixels.setPixelRGBA(blockLightLvl, skyLightLvl, 0xFF000000 | z << 16 | y << 8 | x);
            }
        }
        this.lightmapTexture.upload();
    }

    private static void clampColor(Vector3f vector3f) {
        vector3f.set(Mth.clamp((float)vector3f.x, (float)0.0f, (float)1.0f), Mth.clamp((float)vector3f.y, (float)0.0f, (float)1.0f), Mth.clamp((float)vector3f.z, (float)0.0f, (float)1.0f));
    }

    private float notGamma(float value) {
        float f = 1.0f - value;
        return 1.0f - f * f * f * f;
    }

    public void bind() {
        RenderSystem.setShaderTexture((int)2, (int)this.lightmapTexture.getId());
        this.lightmapTexture.bind();
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void close() throws Exception {
        this.lightmapTexture.close();
    }
}

