/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.indices;

import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.compiler.IdUtils;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.indices.UniqueIndex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemIndex
extends UniqueIndex<ResourceLocation, PageAnchor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemIndex.class);

    public ItemIndex() {
        super("Item Index", ItemIndex::getItemAnchors, (writer, value) -> writer.value(value.toString()), (writer, value) -> writer.value(value.toString()));
    }

    private static List<Pair<ResourceLocation, PageAnchor>> getItemAnchors(ParsedGuidePage page) {
        Object itemIdsNode = page.getFrontmatter().additionalProperties().get("item_ids");
        if (itemIdsNode == null) {
            return List.of();
        }
        if (!(itemIdsNode instanceof List)) {
            LOGGER.warn("Page {} contains malformed item_ids frontmatter", (Object)page.getId());
            return List.of();
        }
        List itemIdList = (List)itemIdsNode;
        ArrayList<Pair<ResourceLocation, PageAnchor>> itemAnchors = new ArrayList<Pair<ResourceLocation, PageAnchor>>();
        for (Object listEntry : itemIdList) {
            if (listEntry instanceof String) {
                ResourceLocation itemId;
                String itemIdStr = (String)listEntry;
                try {
                    itemId = IdUtils.resolveId(itemIdStr, page.getId().getNamespace());
                }
                catch (ResourceLocationException e) {
                    LOGGER.warn("Page {} contains a malformed item_ids frontmatter entry: {}", (Object)page.getId(), listEntry);
                    continue;
                }
                if (BuiltInRegistries.ITEM.containsKey(itemId)) {
                    itemAnchors.add((Pair<ResourceLocation, PageAnchor>)Pair.of((Object)itemId, (Object)new PageAnchor(page.getId(), null)));
                    continue;
                }
                LOGGER.warn("Page {} references an unknown item {} in its item_ids frontmatter", (Object)page.getId(), (Object)itemId);
                continue;
            }
            LOGGER.warn("Page {} contains a malformed item_ids frontmatter entry: {}", (Object)page.getId(), listEntry);
        }
        return itemAnchors;
    }
}

