/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.interaction;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.interaction.GuideTooltip;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.layout.MinecraftFontMetrics;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.siteexport.ExportableResourceProvider;
import appeng.siteexport.ResourceExporter;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ContentTooltip
implements GuideTooltip {
    private final List<ClientTooltipComponent> components;
    @Nullable
    private LytRect layoutViewport;
    @Nullable
    private LytRect layoutBox;
    private final LytBlock content;

    public ContentTooltip(final LytBlock content) {
        this.content = content;
        this.components = List.of(new ClientTooltipComponent(){

            public int getHeight() {
                return ContentTooltip.this.getLayoutBox().height();
            }

            public int getWidth(Font font) {
                return ContentTooltip.this.getLayoutBox().width();
            }

            public void renderText(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
                ContentTooltip.this.getLayoutBox();
                GuiGraphics guiGraphics = new GuiGraphics(Minecraft.getInstance(), bufferSource);
                PoseStack poseStack = guiGraphics.pose();
                poseStack.mulPose(matrix);
                poseStack.translate((float)x, (float)y, 0.0f);
                SimpleRenderContext ctx = new SimpleRenderContext(ContentTooltip.this.layoutViewport, guiGraphics);
                content.renderBatch(ctx, (MultiBufferSource)bufferSource);
            }

            public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
                ContentTooltip.this.getLayoutBox();
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                pose.translate((float)x, (float)y, 0.0f);
                SimpleRenderContext ctx = new SimpleRenderContext(ContentTooltip.this.layoutViewport, guiGraphics);
                content.render(ctx);
                pose.popPose();
            }
        });
    }

    @Override
    public List<ClientTooltipComponent> getLines() {
        return this.components;
    }

    public LytBlock getContent() {
        return this.content;
    }

    private LytRect getLayoutBox() {
        Window window = Minecraft.getInstance().getWindow();
        LytRect currentViewport = new LytRect(0, 0, window.getGuiScaledWidth(), window.getGuiScaledHeight());
        if (this.layoutBox == null || !currentViewport.equals(this.layoutViewport)) {
            this.layoutViewport = currentViewport;
            LayoutContext layoutContext = new LayoutContext(new MinecraftFontMetrics());
            this.layoutBox = this.content.layout(layoutContext, 0, 0, window.getGuiScaledWidth() / 2);
        }
        return this.layoutBox;
    }

    @Override
    public void exportResources(ResourceExporter exporter) {
        ExportableResourceProvider.visit(this.content, exporter);
    }
}

