/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.flow;

import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.color.SymbolicColor;
import appeng.client.guidebook.document.flow.LytTooltipSpan;
import appeng.client.guidebook.screen.GuideScreen;
import appeng.sounds.AppEngSounds;
import java.net.URI;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LytFlowLink
extends LytTooltipSpan {
    private static final Logger LOG = LoggerFactory.getLogger(LytFlowLink.class);
    @Nullable
    private Consumer<GuideScreen> clickCallback;
    @Nullable
    private SoundEvent clickSound = AppEngSounds.GUIDE_CLICK_EVENT;

    public LytFlowLink() {
        this.modifyStyle(style -> style.color(SymbolicColor.LINK));
        this.modifyHoverStyle(style -> style.underlined(true));
    }

    public void setClickCallback(@Nullable Consumer<GuideScreen> clickCallback) {
        this.clickCallback = clickCallback;
    }

    @Override
    public boolean mouseClicked(GuideScreen screen, int x, int y, int button) {
        if (button == 0 && this.clickCallback != null) {
            if (this.clickSound != null) {
                SoundManager handler = Minecraft.getInstance().getSoundManager();
                handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.clickSound, (float)1.0f));
            }
            this.clickCallback.accept(screen);
            return true;
        }
        return false;
    }

    @Nullable
    public SoundEvent getClickSound() {
        return this.clickSound;
    }

    public void setClickSound(@Nullable SoundEvent clickSound) {
        this.clickSound = clickSound;
    }

    public void setExternalUrl(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("External URLs must be absolute: " + String.valueOf(uri));
        }
        this.setClickCallback(screen -> {
            Minecraft mc = Minecraft.getInstance();
            mc.setScreen((Screen)new ConfirmLinkScreen(yes -> {
                if (yes) {
                    Util.getPlatform().openUri(uri);
                }
                mc.setScreen((Screen)screen);
            }, uri.toString(), true));
        });
    }

    public void setPageLink(PageAnchor anchor) {
        this.setClickCallback(screen -> screen.navigateTo(anchor));
    }
}

