/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler;

import java.net.URI;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public final class IdUtils {
    private IdUtils() {
    }

    public static ResourceLocation resolveId(String idText, String defaultNamespace) {
        if (!idText.contains(":")) {
            return ResourceLocation.fromNamespaceAndPath((String)defaultNamespace, (String)idText);
        }
        return ResourceLocation.parse((String)idText);
    }

    public static ResourceLocation resolveLink(String idText, ResourceLocation anchor) throws ResourceLocationException {
        if (idText.startsWith("/")) {
            return ResourceLocation.fromNamespaceAndPath((String)anchor.getNamespace(), (String)idText.substring(1));
        }
        if (!idText.contains(":")) {
            URI uri = URI.create(anchor.getPath());
            uri = uri.resolve(idText);
            String relativeId = uri.toString();
            return ResourceLocation.fromNamespaceAndPath((String)anchor.getNamespace(), (String)relativeId);
        }
        return ResourceLocation.parse((String)idText);
    }
}

