/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.util.data;

import com.google.gson.JsonElement;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.data.RuntimeDatagenHelpers;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public abstract class DynamicRegistryProvider<T extends CodecProvider<T>>
implements DataProvider {
    protected final CompletableFuture<HolderLookup.Provider> lookupProvider;
    protected final PackOutput.PathProvider pathProvider;
    protected final DynamicRegistry<T> registry;
    private List<CompletableFuture<?>> futures;
    private CachedOutput cachedOutput;

    protected DynamicRegistryProvider(GatherDataEvent event, DynamicRegistry<T> registry) {
        this.lookupProvider = event.getLookupProvider();
        this.pathProvider = event.getGenerator().getPackOutput().createPathProvider(PackOutput.Target.DATA_PACK, registry.getPath());
        this.registry = registry;
    }

    public final CompletableFuture<?> run(CachedOutput pOutput) {
        this.futures = new ArrayList();
        this.cachedOutput = pOutput;
        this.generate();
        return CompletableFuture.allOf((CompletableFuture[])this.futures.toArray(CompletableFuture[]::new));
    }

    protected final void add(ResourceLocation id, T object) {
        this.futures.add(DataProvider.saveStable((CachedOutput)this.cachedOutput, (JsonElement)RuntimeDatagenHelpers.toJson(object), (Path)this.pathProvider.json(id)));
    }

    public abstract void generate();
}

