/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.Fzzy_configKt;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.RenderUtil;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 B2\u00020\u0001:\u0001BBK\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J/\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010$\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010&\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b&\u0010'J/\u0010*\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b*\u0010+J\u0019\u0010.\u001a\u00020\u001a2\b\u0010-\u001a\u0004\u0018\u00010,H\u0016\u00a2\u0006\u0004\b.\u0010/J\u001f\u00100\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b0\u0010'J\u0017\u00101\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b1\u00102J\u0017\u00104\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b4\u00102J\u000f\u00106\u001a\u000205H\u0014\u00a2\u0006\u0004\b6\u00107J\u0017\u0010:\u001a\u00020\u001a2\u0006\u00109\u001a\u000208H\u0014\u00a2\u0006\u0004\b:\u0010;R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010<R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010=R\u0016\u0010>\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0016\u0010@\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010?R\u0016\u00103\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u0010A\u00a8\u0006C"}, d2={"Lme/fzzyhmstrs/fzzy_config/screen/widget/VerticalSliderWidget;", "Lnet/minecraft/client/gui/components/AbstractWidget;", "Ljava/util/function/Supplier;", "", "wrappedValue", "", "x", "y", "width", "height", "Lnet/minecraft/network/chat/Component;", "message", "Ljava/util/function/Consumer;", "valueApplier", "<init>", "(Ljava/util/function/Supplier;IIIILnet/minecraft/network/chat/Component;Ljava/util/function/Consumer;)V", "Lnet/minecraft/resources/ResourceLocation;", "getTexture", "()Lnet/minecraft/resources/ResourceLocation;", "getHandlerTexture", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "mouseX", "mouseY", "", "delta", "", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "", "focused", "setFocused", "(Z)V", "keyCode", "scanCode", "modifiers", "keyPressed", "(III)Z", "onClick", "(DD)V", "deltaX", "deltaY", "onDrag", "(DDDD)V", "Lnet/minecraft/client/sounds/SoundManager;", "soundManager", "playDownSound", "(Lnet/minecraft/client/sounds/SoundManager;)V", "onRelease", "setValueFromMouse", "(D)V", "value", "setValue", "Lnet/minecraft/network/chat/MutableComponent;", "getNarrationMessage", "()Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/client/gui/narration/NarrationElementOutput;", "builder", "appendClickableNarrations", "(Lnet/minecraft/client/gui/narration/NarrationElementOutput;)V", "Ljava/util/function/Supplier;", "Ljava/util/function/Consumer;", "mouseHasBeenClicked", "Z", "sliderFocused", "D", "Companion", "fzzy_config"})
public final class VerticalSliderWidget
extends AbstractWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<Double> wrappedValue;
    @NotNull
    private final Consumer<Double> valueApplier;
    private boolean mouseHasBeenClicked;
    private boolean sliderFocused;
    private double value;
    @NotNull
    private static final ResourceLocation TEXTURE = Fzzy_configKt.fcId("widget/vertical_slider");
    @NotNull
    private static final ResourceLocation TEXTURE_HIGHLIGHTED = Fzzy_configKt.fcId("widget/vertical_slider_highlighted");
    @NotNull
    private static final ResourceLocation HANDLE = Fzzy_configKt.fcId("widget/vertical_slider_handle");
    @NotNull
    private static final ResourceLocation HANDLE_HIGHLIGHTED = Fzzy_configKt.fcId("widget/vertical_slider_handle_highlighted");

    public VerticalSliderWidget(@NotNull Supplier<Double> wrappedValue, int x, int y, int width, int height, @NotNull Component message, @NotNull Consumer<Double> valueApplier) {
        Intrinsics.checkNotNullParameter(wrappedValue, (String)"wrappedValue");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(valueApplier, (String)"valueApplier");
        super(x, y, width, height, message);
        this.wrappedValue = wrappedValue;
        this.valueApplier = valueApplier;
        Double d = this.wrappedValue.get();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"get(...)");
        this.value = ((Number)d).doubleValue();
    }

    private final ResourceLocation getTexture() {
        return this.isFocused() && !this.sliderFocused ? TEXTURE_HIGHLIGHTED : TEXTURE;
    }

    private final ResourceLocation getHandlerTexture() {
        return this.isHovered() || this.sliderFocused ? HANDLE_HIGHLIGHTED : HANDLE;
    }

    protected void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(((Number)this.wrappedValue.get()).doubleValue() == this.value)) {
            this.value = ((Number)this.wrappedValue.get()).doubleValue();
        }
        context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderUtil.INSTANCE.drawTex(context, this.getTexture(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        RenderUtil.INSTANCE.drawTex(context, this.getHandlerTexture(), this.getX(), this.getY() + (int)(this.value * (double)(this.height - 8)), this.getWidth(), 8);
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused) {
            this.sliderFocused = false;
            return;
        }
        InputType guiNavigationType = Minecraft.getInstance().getLastInputType();
        if (guiNavigationType == InputType.MOUSE || guiNavigationType == InputType.KEYBOARD_TAB) {
            this.sliderFocused = true;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (CommonInputs.selected((int)keyCode)) {
            this.sliderFocused = !this.sliderFocused;
            return true;
        }
        if (this.sliderFocused) {
            boolean bl;
            boolean bl2 = bl = keyCode == 265;
            if (bl || keyCode == 264) {
                float f = bl ? -1.0f : 1.0f;
                this.setValue(this.value + (double)(f / (float)(this.height - 8)));
                return true;
            }
        }
        return false;
    }

    public void onClick(double mouseX, double mouseY) {
        this.mouseHasBeenClicked = true;
        this.setValueFromMouse(mouseY);
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setValueFromMouse(mouseY);
        super.onDrag(mouseX, mouseY, deltaX, deltaY);
    }

    public void playDownSound(@Nullable SoundManager soundManager) {
    }

    public void onRelease(double mouseX, double mouseY) {
        if (this.mouseHasBeenClicked) {
            super.playDownSound(Minecraft.getInstance().getSoundManager());
        }
    }

    private final void setValueFromMouse(double mouseY) {
        this.setValue((mouseY - (double)(this.getY() + 4)) / (double)(this.height - 8));
    }

    private final void setValue(double value) {
        double d = this.value;
        this.value = Mth.clamp((double)value, (double)0.0, (double)1.0);
        if (!(d == this.value)) {
            this.valueApplier.accept(this.value);
        }
    }

    @NotNull
    protected MutableComponent createNarrationMessage() {
        Object[] objectArray = new Object[]{this.getMessage()};
        return FcText.INSTANCE.translate("gui.narrate.slider", objectArray);
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        MutableComponent mutableComponent = this.createNarrationMessage();
        Intrinsics.checkNotNull((Object)mutableComponent, (String)"null cannot be cast to non-null type net.minecraft.text.Text");
        builder.add(NarratedElementType.TITLE, (Component)mutableComponent);
        if (this.active) {
            if (this.isFocused()) {
                builder.add(NarratedElementType.USAGE, (Component)FcText.INSTANCE.translate("fc.button.slider.usage.focused", new Object[0]));
            } else {
                builder.add(NarratedElementType.USAGE, (Component)FcText.INSTANCE.translate("narration.slider.usage.hovered", new Object[0]));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006\u00a8\u0006\n"}, d2={"Lme/fzzyhmstrs/fzzy_config/screen/widget/VerticalSliderWidget$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "TEXTURE_HIGHLIGHTED", "HANDLE", "HANDLE_HIGHLIGHTED", "fzzy_config"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

