/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.timeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.timeline.GuiTimeline;
import team.creative.creativecore.common.gui.controls.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;

public abstract class GuiTimelineChannel<T>
extends GuiParent {
    public final GuiTimeline timeline;
    public GuiControl sidebarTitle;
    private int cachedHeight;
    private List<GuiTimelineKey<T>> keys = new ArrayList<GuiTimelineKey<T>>();
    private GuiTimelineKey<T> dragged;

    public GuiTimelineChannel(GuiTimeline timeline) {
        this.timeline = timeline;
        this.valign = VAlign.CENTER;
    }

    @Override
    public GuiTimelineChannel<T> setTooltip(List<Component> tooltip) {
        super.setTooltip(tooltip);
        this.sidebarTitle.setTooltip(tooltip);
        return this;
    }

    public GuiTimelineChannel<T> addKeyFixed(int tick, T value) {
        GuiTimelineKey<T> key = this.addKey(tick, value);
        key.modifiable = false;
        return this;
    }

    public GuiTimelineKey<T> addKey(int tick, T value) {
        GuiTimelineKey<T> key = new GuiTimelineKey<T>(this, tick, value);
        GuiChildControl child = this.addControl(key);
        if (this.hasLayer()) {
            child.setWidth(child.getPreferredWidth(0), 0);
            child.flowX();
            child.setHeight(child.getPreferredHeight(0), 0);
            child.flowY();
            child.setY((int)Math.ceil((double)this.cachedHeight / 2.0 - (double)child.getHeight() / 2.0));
        }
        this.timeline.adjustKeyPositionX(key);
        for (int i = 0; i < this.keys.size(); ++i) {
            GuiTimelineKey<T> other = this.keys.get(i);
            if (other.tick == tick) {
                return null;
            }
            if (other.tick <= tick) continue;
            this.keys.add(i, key);
            return key;
        }
        this.keys.add(key);
        this.timeline.raiseEvent(new GuiControlChangedEvent<GuiTimeline>(this.timeline));
        return key;
    }

    @Override
    public void flowX(int width, int preferred) {
        for (GuiChildControl child : this.controls) {
            child.setWidth(child.getPreferredWidth(0), 0);
            child.flowX();
        }
        this.timeline.adjustKeysPositionX();
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        super.flowY(width, height, preferred);
        this.cachedHeight = height;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED;
    }

    @Override
    public double getOffsetX() {
        return -this.timeline.scrolledX();
    }

    public void select(GuiTimelineKey<T> key) {
        this.timeline.selectKey(key);
    }

    public void deslect() {
        this.timeline.deselect();
    }

    public void removeChannel() {
        this.timeline.removeChannel(this);
    }

    public void removeKey(GuiTimelineKey<T> key) {
        this.keys.remove(key);
        this.remove(key);
        this.timeline.raiseEvent(new GuiControlChangedEvent<GuiTimeline>(this.timeline));
    }

    public void movedKey(GuiTimelineKey<T> key) {
        Collections.sort(this.keys);
        this.timeline.raiseEvent(new GuiControlChangedEvent<GuiTimeline>(this.timeline));
    }

    public void dragKey(GuiTimelineKey<T> key) {
        if (key.modifiable) {
            this.dragged = key;
        }
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        int tick;
        if (this.dragged != null && this.dragged.channel.isSpaceFor(this.dragged, tick = Math.max(0, this.timeline.getTimeAt(x)))) {
            this.dragged.tick = tick;
            this.timeline.adjustKeyPositionX(this.dragged);
        }
        super.mouseMoved(rect, x, y);
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        if (this.dragged != null) {
            this.dragged.channel.movedKey(this.dragged);
            this.dragged = null;
        }
        super.mouseReleased(rect, x, y, button);
    }

    @Override
    public boolean mouseScrolled(Rect rect, double x, double y, double delta) {
        this.timeline.scrolled((int)rect.getWidth(), x, delta);
        return true;
    }

    public boolean isSpaceFor(@Nullable GuiTimelineKey<T> key, int tick) {
        if (tick < 0 || tick > this.timeline.duration) {
            return false;
        }
        for (int i = 0; i < this.keys.size(); ++i) {
            int otherTick = this.keys.get((int)i).tick;
            if (otherTick == tick) {
                return false;
            }
            if (otherTick <= tick) continue;
            return true;
        }
        return true;
    }

    protected abstract T getValueAt(int var1);

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        boolean result = super.mouseClicked(rect, x, y, button);
        if (!result && button == 1) {
            GuiTimelineKey<T> key;
            int time = this.timeline.getTimeAt(x);
            if (this.isSpaceFor(null, time) && (key = this.addKey(time, this.getValueAt(time))) != null) {
                this.select(key);
                GuiTimelineChannel.playSound(SoundEvents.ITEM_FRAME_ADD_ITEM, 0.1f, 0.6f);
            }
            return true;
        }
        return result;
    }

    public boolean isChannelEmpty() {
        return this.keys.isEmpty();
    }

    public Iterable<GuiTimelineKey<T>> keys() {
        return this.keys;
    }

    public GuiTimelineKey<T> getFirst() {
        if (this.keys.isEmpty()) {
            return null;
        }
        return this.keys.get(0);
    }

    public GuiTimelineKey<T> getLast() {
        if (this.keys.isEmpty()) {
            return null;
        }
        return this.keys.get(this.keys.size() - 1);
    }
}

