/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.collection;

import java.util.List;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBox;
import team.creative.creativecore.common.util.text.TextMapBuilder;

public class GuiComboBoxMapped<K>
extends GuiComboBox {
    private List<K> keys;

    public GuiComboBoxMapped(String name, TextMapBuilder<K> lines) {
        super(name, lines);
        this.updateDisplay();
        this.keys = lines.keys();
    }

    @Override
    public GuiComboBoxMapped<K> setSearchbar(boolean searchbar) {
        return (GuiComboBoxMapped)super.setSearchbar(searchbar);
    }

    public void setLines(TextMapBuilder<K> builder) {
        K key = this.getSelected();
        this.lines = builder.build();
        this.keys = builder.keys();
        int index = this.keys.indexOf(key);
        if (index < 0) {
            index = 0;
        }
        this.select(index);
        this.updateDisplay();
    }

    public K getSelected() {
        int index = this.getIndex();
        if (index < this.keys.size()) {
            return this.keys.get(index);
        }
        return null;
    }

    public K getSelected(K defaultValue) {
        int index = this.getIndex();
        if (index < this.keys.size()) {
            return this.keys.get(index);
        }
        return defaultValue;
    }

    public void select(K key) {
        int index = this.keys.indexOf(key);
        if (index != -1) {
            this.select(index);
        }
    }

    public int indexOf(K key) {
        return this.keys.indexOf(key);
    }
}

