/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.converation.ConfigTypeArray;
import team.creative.creativecore.common.config.converation.ConfigTypeList;
import team.creative.creativecore.common.config.converation.ConfigTypeNamedList;
import team.creative.creativecore.common.config.converation.ConfigTypePermission;
import team.creative.creativecore.common.config.converation.ConfigTypeToggleable;
import team.creative.creativecore.common.config.converation.registry.ConfigTypeRegistryObject;
import team.creative.creativecore.common.config.converation.registry.ConfigTypeRegistryObjectList;
import team.creative.creativecore.common.config.converation.registry.ConfigTypeRegistryTag;
import team.creative.creativecore.common.config.converation.registry.ConfigTypeRegistryTagList;
import team.creative.creativecore.common.config.field.ConfigField;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.premade.MobEffectConfig;
import team.creative.creativecore.common.config.premade.NamedList;
import team.creative.creativecore.common.config.premade.Permission;
import team.creative.creativecore.common.config.premade.SelectableConfig;
import team.creative.creativecore.common.config.premade.SoundConfig;
import team.creative.creativecore.common.config.premade.ToggleableConfig;
import team.creative.creativecore.common.config.premade.registry.RegistryObjectConfig;
import team.creative.creativecore.common.config.premade.registry.RegistryObjectListConfig;
import team.creative.creativecore.common.config.premade.registry.RegistryTagConfig;
import team.creative.creativecore.common.config.premade.registry.RegistryTagListConfig;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBox;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiSlider;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.text.TextListBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.TriPredicate;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;

public abstract class ConfigTypeConveration<T> {
    private static final NumberFormat NUMBER_FORMAT = ConfigTypeConveration.createFormat();
    private static final HashMap<Class, Function<ConfigField, ?>> TYPE_CREATORS = new HashMap();
    private static final HashMap<Class, TriPredicate<Object, Object, Side>> TYPE_EQUALS_CHECKER = new HashMap();
    private static final HashMap<Class, Function<ConfigField, Type>> TYPE_GETTERS = new HashMap();
    private static final HashMap<Class, Function<ConfigField, ?>> COLLECTION_CREATORS = new HashMap();
    private static final HashMap<Class, ConfigTypeConveration> TYPES = new HashMap();
    private static final PairList<Predicate<Class>, ConfigTypeConveration> SPECIAL_TYPES = new PairList();
    public static final ICreativeConfigHolder FAKE_PARENT = new ICreativeConfigHolder(){

        @Override
        public ConfigSynchronization synchronization() {
            return ConfigSynchronization.UNIVERSAL;
        }

        @Override
        public JsonObject save(HolderLookup.Provider provider, boolean saveDefault, boolean ignoreRestart, Side side) {
            return null;
        }

        @Override
        public void restoreDefault(Side side, boolean ignoreRestart) {
        }

        @Override
        public String[] path() {
            return new String[0];
        }

        @Override
        public ICreativeConfigHolder parent() {
            return null;
        }

        @Override
        public Collection<String> names() {
            return null;
        }

        @Override
        public void load(HolderLookup.Provider provider, boolean loadDefault, boolean ignoreRestart, JsonObject json, Side side) {
        }

        @Override
        public boolean isEmptyWithoutForce(Side side) {
            return false;
        }

        @Override
        public boolean isEmpty(Side side) {
            return false;
        }

        @Override
        public boolean isDefault(Side side) {
            return false;
        }

        @Override
        public ConfigKey getField(String key) {
            return null;
        }

        @Override
        public Object get(String key) {
            return null;
        }

        @Override
        public Collection<? extends ConfigKey> fields() {
            return null;
        }

        @Override
        public void configured(Side side) {
        }
    };

    private static NumberFormat createFormat() {
        NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
        format.setMaximumFractionDigits(Integer.MAX_VALUE);
        format.setGroupingUsed(false);
        return format;
    }

    public static <T, U extends T> void registerTypeCreator(Class<U> clazz, Function<ConfigField, T> type) {
        TYPE_CREATORS.put(clazz, type);
        ConfigTypeConveration.registerTypeEqualChecker(clazz);
    }

    public static <T, U extends T> void registerTypeCreator(Class<U> clazz, Supplier<T> type) {
        TYPE_CREATORS.put(clazz, x -> type.get());
        ConfigTypeConveration.registerTypeEqualChecker(clazz);
    }

    public static void registerTypeEqualChecker(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ConfigTypeConveration.collectFieldsToCheck(clazz, fields);
        if (fields.isEmpty()) {
            return;
        }
        TYPE_EQUALS_CHECKER.put(clazz, (x, y, side) -> {
            for (int i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.get(i);
                CreativeConfig config = field.getAnnotation(CreativeConfig.class);
                if (!config.type().useValue(false, (Side)((Object)side))) continue;
                try {
                    if (ConfigTypeConveration.equals(field.get(x), field.get(y), side)) continue;
                    return false;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    CreativeCore.LOGGER.error("Could not check equals on object with class " + String.valueOf(clazz), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            return true;
        });
    }

    private static void collectFieldsToCheck(Class clazz, List<Field> fields) {
        if (clazz.getSuperclass() != Object.class && clazz.getSuperclass() != null) {
            ConfigTypeConveration.collectFieldsToCheck(clazz.getSuperclass(), fields);
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!Modifier.isPublic(declaredFields[i].getModifiers()) || !declaredFields[i].isAnnotationPresent(CreativeConfig.class)) continue;
            fields.add(declaredFields[i]);
        }
    }

    public static void registerTypeGetter(Class clazz, Function<ConfigField, Type> getter) {
        TYPE_GETTERS.put(clazz, getter);
    }

    public static <T, U extends T> void registerCollectionCreator(Class<U> clazz, Function<ConfigField, T> getter) {
        COLLECTION_CREATORS.put(clazz, getter);
    }

    public static <T, U extends T> ConfigTypeConveration<T> registerType(Class<U> clazz, ConfigTypeConveration<T> type) {
        TYPES.put(clazz, type);
        return type;
    }

    public static void registerSpecialType(Predicate<Class> predicate, ConfigTypeConveration type) {
        SPECIAL_TYPES.add(predicate, type);
    }

    public static boolean has(Class typeClass) {
        if (TYPES.containsKey(typeClass)) {
            return true;
        }
        if (typeClass.isAnnotationPresent(CreativeConfig.class)) {
            return false;
        }
        for (int i = 0; i < SPECIAL_TYPES.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.SPECIAL_TYPES.get((int)i)).key).test(typeClass)) continue;
            return true;
        }
        return false;
    }

    public static ConfigTypeConveration get(Class typeClass) {
        ConfigTypeConveration converation = TYPES.get(typeClass);
        if (converation != null) {
            return converation;
        }
        for (int i = 0; i < SPECIAL_TYPES.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.SPECIAL_TYPES.get((int)i)).key).test(typeClass)) continue;
            return (ConfigTypeConveration)((Pair)ConfigTypeConveration.SPECIAL_TYPES.get((int)i)).value;
        }
        throw new RuntimeException("Could not find converation for " + typeClass.getName());
    }

    public static ConfigTypeConveration getUnsafe(Class typeClass) {
        ConfigTypeConveration converation = TYPES.get(typeClass);
        if (converation != null) {
            return converation;
        }
        for (int i = 0; i < SPECIAL_TYPES.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.SPECIAL_TYPES.get((int)i)).key).test(typeClass)) continue;
            return (ConfigTypeConveration)((Pair)ConfigTypeConveration.SPECIAL_TYPES.get((int)i)).value;
        }
        return null;
    }

    public static Object createObject(ConfigField field) {
        Function<ConfigField, ?> func = TYPE_CREATORS.get(field.getType());
        if (func != null) {
            return func.apply(field);
        }
        try {
            return field.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    public static Type getGenericType(ConfigField field) {
        Function<ConfigField, Type> func = TYPE_GETTERS.get(field.getType());
        if (func != null) {
            return func.apply(field);
        }
        Type type = field.getGenericType();
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return p.getActualTypeArguments()[0];
        }
        throw new UnsupportedOperationException("This type is not supported " + String.valueOf(type));
    }

    public static Type getGenericType(ConfigKey key) {
        return ConfigTypeConveration.getGenericType(key.field());
    }

    public static Object createCollection(ConfigField field) {
        Function<ConfigField, ?> func = COLLECTION_CREATORS.get(field.getType());
        if (func != null) {
            return func.apply(field);
        }
        return null;
    }

    public static Object createCollection(ConfigKey key) {
        return ConfigTypeConveration.createCollection(key.field());
    }

    public static boolean equals(Object one, Object two, Side side) {
        if (Objects.equals(one, two)) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.getClass() != two.getClass()) {
            return false;
        }
        TriPredicate<Object, Object, Side> check = TYPE_EQUALS_CHECKER.get(one.getClass());
        if (check != null) {
            return check.test(one, two, side);
        }
        return false;
    }

    public abstract T readElement(HolderLookup.Provider var1, T var2, boolean var3, boolean var4, JsonElement var5, Side var6, ConfigKey var7);

    public abstract JsonElement writeElement(HolderLookup.Provider var1, T var2, boolean var3, boolean var4, Side var5, ConfigKey var6);

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public abstract void createControls(GuiParent var1, IGuiConfigParent var2, ConfigKey var3, Side var4);

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public abstract void loadValue(T var1, T var2, GuiParent var3, IGuiConfigParent var4, ConfigKey var5, Side var6);

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public void restoreDefault(T value, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        this.loadValue(value, value, parent, configParent, key, side);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public boolean shouldSave(T value, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        return !key.get().equals(value);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    protected abstract T saveValue(GuiParent var1, IGuiConfigParent var2, ConfigKey var3, Side var4);

    public abstract T set(ConfigKey var1, T var2);

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public T save(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        T value = this.saveValue(parent, configParent, key, side);
        if (value != null && key != null) {
            return this.set(key, value);
        }
        return value;
    }

    public boolean areEqual(T one, T two, ConfigKey key, Side side) {
        return one.equals(two);
    }

    static {
        SimpleConfigTypeConveration<Boolean> booleanType = new SimpleConfigTypeConveration<Boolean>(){

            @Override
            public Boolean readElement(ConfigKey key, Boolean defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return element.getAsBoolean();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Boolean value, ConfigKey key, Side side) {
                return new JsonPrimitive(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, ConfigKey key) {
                parent.add(new GuiStateButton("data", 0, String.valueOf(ChatFormatting.RED) + "false", String.valueOf(ChatFormatting.GREEN) + "true").setExpandableX());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void loadValue(Boolean value, GuiParent parent) {
                GuiStateButton button = (GuiStateButton)parent.get("data");
                button.setState(value != false ? 1 : 0);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            protected Boolean saveValue(GuiParent parent, ConfigKey key) {
                GuiStateButton button = (GuiStateButton)parent.get("data");
                return button.getState() == 1;
            }

            @Override
            public Boolean set(ConfigKey key, Boolean value) {
                return value;
            }
        };
        ConfigTypeConveration.registerType(Boolean.TYPE, booleanType);
        ConfigTypeConveration.registerType(Boolean.class, booleanType);
        ConfigTypeConveration.registerTypeCreator(Boolean.TYPE, () -> false);
        ConfigTypeConveration.registerTypeCreator(Boolean.class, () -> Boolean.FALSE);
        SimpleConfigTypeConveration<Number> numberType = new SimpleConfigTypeConveration<Number>(){

            @Override
            public Number readElement(ConfigKey key, Number defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
                    Class clazz = key.field().getType();
                    if (clazz == Float.class || clazz == Float.TYPE) {
                        return Float.valueOf(element.getAsFloat());
                    }
                    if (clazz == Double.class || clazz == Double.TYPE) {
                        return element.getAsDouble();
                    }
                    if (clazz == Byte.class || clazz == Byte.TYPE) {
                        return element.getAsByte();
                    }
                    if (clazz == Short.class || clazz == Short.TYPE) {
                        return element.getAsShort();
                    }
                    if (clazz == Integer.class || clazz == Integer.TYPE) {
                        return element.getAsInt();
                    }
                    if (clazz == Long.class || clazz == Long.TYPE) {
                        return element.getAsLong();
                    }
                    return element.getAsNumber();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Number value, ConfigKey key, Side side) {
                return new JsonPrimitive(value);
            }

            public boolean isDecimal(Class clazz) {
                return clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, ConfigKey key) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                boolean decimal = this.isDecimal(key.field().getType());
                if (key != null) {
                    if (decimal) {
                        CreativeConfig.DecimalRange decRange = key.field().getAnnotation(CreativeConfig.DecimalRange.class);
                        if (decRange != null && decRange.slider()) {
                            parent.add(new GuiSlider("data", decRange.min(), decRange.min(), decRange.max()).setExpandableX());
                            return;
                        }
                    } else {
                        CreativeConfig.IntRange intRange = key.field().getAnnotation(CreativeConfig.IntRange.class);
                        if (intRange != null && intRange.slider()) {
                            parent.add(new GuiSteppedSlider("data", intRange.min(), intRange.min(), intRange.max()).setExpandableX());
                            return;
                        }
                    }
                }
                GuiTextfield textfield = (GuiTextfield)new GuiTextfield("data").setDim(30, 8).setExpandableX();
                if (decimal) {
                    textfield.setFloatOnly();
                } else {
                    textfield.setNumbersIncludingNegativeOnly();
                }
                parent.add((GuiControl)textfield);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void loadValue(Number value, GuiParent parent) {
                Object control = parent.get("data");
                if (control instanceof GuiSteppedSlider) {
                    GuiSteppedSlider button = (GuiSteppedSlider)control;
                    button.setValue(value.intValue());
                } else if (control instanceof GuiSlider) {
                    GuiSlider button = (GuiSlider)control;
                    button.setValue(value.doubleValue());
                } else {
                    ((GuiTextfield)control).setText(NUMBER_FORMAT.format(value));
                }
            }

            public Number parseDecimal(Class clazz, double decimal) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    return Float.valueOf((float)decimal);
                }
                return decimal;
            }

            public Number parseInt(Class clazz, int number) {
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    return (byte)number;
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    return (short)number;
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    return (long)number;
                }
                return number;
            }

            public Number parseNumber(Class clazz, String text) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    try {
                        return Float.valueOf(Float.parseFloat(text));
                    }
                    catch (NumberFormatException e) {
                        return Float.valueOf(0.0f);
                    }
                }
                if (clazz == Double.class || clazz == Double.TYPE) {
                    try {
                        return Double.parseDouble(text);
                    }
                    catch (NumberFormatException e) {
                        return 0.0;
                    }
                }
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    try {
                        return Byte.parseByte(text);
                    }
                    catch (NumberFormatException e) {
                        return (byte)0;
                    }
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    try {
                        return Short.parseShort(text);
                    }
                    catch (NumberFormatException e) {
                        return (short)0;
                    }
                }
                if (clazz == Integer.class || clazz == Integer.TYPE) {
                    try {
                        return Integer.parseInt(text);
                    }
                    catch (NumberFormatException e) {
                        return 0;
                    }
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    try {
                        return Long.parseLong(text);
                    }
                    catch (NumberFormatException e) {
                        return 0L;
                    }
                }
                return 0;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            protected Number saveValue(GuiParent parent, ConfigKey key) {
                Object text;
                Object control = parent.get("data");
                if (control instanceof GuiSteppedSlider) {
                    GuiSteppedSlider button = (GuiSteppedSlider)control;
                    text = "" + button.getIntValue();
                } else if (control instanceof GuiSlider) {
                    GuiSlider button = (GuiSlider)control;
                    text = "" + button.getValue();
                } else {
                    text = ((GuiTextfield)control).getText();
                }
                return this.parseNumber(key.field().getType(), (String)text);
            }

            @Override
            public Number set(ConfigKey key, Number value) {
                if (key != null) {
                    Class clazz = key.field().getType();
                    if (this.isDecimal(clazz)) {
                        CreativeConfig.DecimalRange decRange = key.field().getAnnotation(CreativeConfig.DecimalRange.class);
                        if (decRange != null) {
                            return this.parseDecimal(clazz, Mth.clamp((double)value.doubleValue(), (double)decRange.min(), (double)decRange.max()));
                        }
                    } else {
                        CreativeConfig.IntRange intRange = key.field().getAnnotation(CreativeConfig.IntRange.class);
                        if (intRange != null) {
                            return this.parseInt(clazz, Mth.clamp((int)value.intValue(), (int)intRange.min(), (int)intRange.max()));
                        }
                    }
                }
                return value;
            }
        };
        ConfigTypeConveration.registerType(Byte.TYPE, numberType);
        ConfigTypeConveration.registerType(Byte.class, numberType);
        ConfigTypeConveration.registerType(Short.TYPE, numberType);
        ConfigTypeConveration.registerType(Short.class, numberType);
        ConfigTypeConveration.registerType(Integer.TYPE, numberType);
        ConfigTypeConveration.registerType(Integer.class, numberType);
        ConfigTypeConveration.registerType(Long.TYPE, numberType);
        ConfigTypeConveration.registerType(Long.class, numberType);
        ConfigTypeConveration.registerType(Float.TYPE, numberType);
        ConfigTypeConveration.registerType(Float.class, numberType);
        ConfigTypeConveration.registerType(Double.TYPE, numberType);
        ConfigTypeConveration.registerType(Double.class, numberType);
        ConfigTypeConveration.registerTypeCreator(Byte.TYPE, () -> (byte)0);
        ConfigTypeConveration.registerTypeCreator(Byte.class, () -> (byte)0);
        ConfigTypeConveration.registerTypeCreator(Short.TYPE, () -> (short)0);
        ConfigTypeConveration.registerTypeCreator(Short.class, () -> (short)0);
        ConfigTypeConveration.registerTypeCreator(Integer.TYPE, () -> 0);
        ConfigTypeConveration.registerTypeCreator(Integer.class, () -> 0);
        ConfigTypeConveration.registerTypeCreator(Long.TYPE, () -> 0L);
        ConfigTypeConveration.registerTypeCreator(Long.class, () -> 0L);
        ConfigTypeConveration.registerTypeCreator(Float.TYPE, () -> Float.valueOf(0.0f));
        ConfigTypeConveration.registerTypeCreator(Float.class, () -> Float.valueOf(0.0f));
        ConfigTypeConveration.registerTypeCreator(Double.TYPE, () -> 0.0);
        ConfigTypeConveration.registerTypeCreator(Double.class, () -> 0.0);
        ConfigTypeConveration.registerType(String.class, new SimpleConfigTypeConveration<String>(){

            @Override
            public String readElement(ConfigKey key, String defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return element.getAsString();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(String value, ConfigKey key, Side side) {
                return new JsonPrimitive(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, ConfigKey key) {
                parent.add(new GuiTextfield("data").setDim(30, 8).setExpandableX());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void loadValue(String value, GuiParent parent) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                button.setText(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            protected String saveValue(GuiParent parent, ConfigKey key) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                return button.getText();
            }

            @Override
            public String set(ConfigKey key, String value) {
                return value;
            }
        });
        ConfigTypeConveration.registerTypeCreator(String.class, () -> "");
        ConfigTypeConveration.registerType(ResourceLocation.class, new SimpleConfigTypeConveration<ResourceLocation>(){

            @Override
            public ResourceLocation readElement(ConfigKey key, ResourceLocation defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return ResourceLocation.parse((String)element.getAsString());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(ResourceLocation value, ConfigKey key, Side side) {
                return new JsonPrimitive(value.toString());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, ConfigKey key) {
                parent.add(new GuiTextfield("data").setDim(30, 8).setExpandableX());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void loadValue(ResourceLocation value, GuiParent parent) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                button.setText(value.toString());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            protected ResourceLocation saveValue(GuiParent parent, ConfigKey key) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                return ResourceLocation.parse((String)button.getText());
            }

            @Override
            public ResourceLocation set(ConfigKey key, ResourceLocation value) {
                return value;
            }
        });
        ConfigTypeConveration.registerTypeCreator(ResourceLocation.class, () -> ResourceLocation.withDefaultNamespace((String)""));
        ConfigTypeConveration.registerType(SoundConfig.class, new ConfigTypeConveration<SoundConfig>(){

            @Override
            public SoundConfig readElement(HolderLookup.Provider provider, SoundConfig defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
                if (element.isJsonObject()) {
                    return new SoundConfig(ResourceLocation.parse((String)element.getAsJsonObject().get("sound").getAsString()), element.getAsJsonObject().get("volume").getAsFloat(), element.getAsJsonObject().get("pitch").getAsFloat());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(HolderLookup.Provider provider, SoundConfig value, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey key) {
                JsonObject json = new JsonObject();
                json.addProperty("sound", value.event.toString());
                json.addProperty("volume", (Number)Float.valueOf(value.volume));
                json.addProperty("pitch", (Number)Float.valueOf(value.pitch));
                return json;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                parent.flow = GuiFlow.STACK_Y;
                parent.add((GuiControl)new GuiComboBoxMapped<ResourceLocation>("sound", new TextMapBuilder<ResourceLocation>().addComponent(BuiltInRegistries.SOUND_EVENT.keySet(), x -> {
                    if (x.getNamespace().equals("minecraft")) {
                        return Component.literal((String)x.getPath());
                    }
                    return Component.literal((String)x.toString());
                })).setSearchbar(true));
                GuiParent hBox = new GuiParent(GuiFlow.STACK_X).add((GuiControl)new GuiLabel("volumeLabel").setTranslate("gui.volume")).add(new GuiSlider("volume", 1.0, 0.0, 1.0).setDim(40, 10)).add((GuiControl)new GuiLabel("pitchLabel").setTranslate("gui.pitch")).add(new GuiSlider("pitch", 1.0, 0.5, 2.0).setDim(40, 10));
                parent.add((GuiControl)hBox);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void loadValue(SoundConfig value, SoundConfig defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("sound");
                GuiSlider volume = (GuiSlider)parent.get("volume");
                GuiSlider pitch = (GuiSlider)parent.get("pitch");
                box.select(value.event);
                volume.setValue(value.volume);
                pitch.setValue(value.pitch);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            protected SoundConfig saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("sound");
                GuiSlider volume = (GuiSlider)parent.get("volume");
                GuiSlider pitch = (GuiSlider)parent.get("pitch");
                return new SoundConfig((ResourceLocation)box.getSelected(), (float)volume.getValue(), (float)pitch.getValue());
            }

            @Override
            public SoundConfig set(ConfigKey key, SoundConfig value) {
                return value;
            }
        });
        ConfigTypeConveration.registerTypeCreator(SoundConfig.class, () -> new SoundConfig(ResourceLocation.withDefaultNamespace((String)"missing")));
        ConfigTypeConveration.registerType(RegistryObjectConfig.class, new ConfigTypeRegistryObject());
        ConfigTypeConveration.registerType(RegistryObjectListConfig.class, new ConfigTypeRegistryObjectList());
        ConfigTypeConveration.registerType(RegistryTagConfig.class, new ConfigTypeRegistryTag());
        ConfigTypeConveration.registerType(RegistryTagListConfig.class, new ConfigTypeRegistryTagList());
        ConfigTypeConveration.registerType(SelectableConfig.class, new ConfigTypeConveration<SelectableConfig>(){

            @Override
            public SelectableConfig readElement(HolderLookup.Provider provider, SelectableConfig defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
                    defaultValue.select(element.getAsInt());
                } else {
                    defaultValue.reset();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(HolderLookup.Provider provider, SelectableConfig value, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey key) {
                return new JsonPrimitive((Number)value.getSelected());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                SelectableConfig value = (SelectableConfig)key.get();
                configParent.setCustomData(value.getSelected());
                parent.add(new GuiComboBox("data", new TextListBuilder().add(value.getArray(), Object::toString)).setExpandableX());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void loadValue(SelectableConfig value, SelectableConfig defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                box.select(value.getSelected());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void restoreDefault(SelectableConfig value, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                value.reset();
                this.loadValue(value, value, parent, configParent, key, side);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            protected SelectableConfig saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                SelectableConfig config = (SelectableConfig)key.get();
                GuiComboBox box = (GuiComboBox)parent.get("data");
                config.select(box.getIndex());
                return config;
            }

            @Override
            public SelectableConfig set(ConfigKey key, SelectableConfig value) {
                return value;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public boolean shouldSave(SelectableConfig value, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                return value.getSelected() != ((Integer)configParent.getCustomData()).intValue();
            }
        });
        ConfigTypeConveration.registerType(NamedList.class, new ConfigTypeNamedList());
        ConfigTypeConveration.registerType(Permission.class, new ConfigTypePermission());
        ConfigTypeConveration.registerTypeCreator(MobEffectConfig.class, () -> new MobEffectConfig((Registry<MobEffect>)BuiltInRegistries.MOB_EFFECT, ResourceLocation.withDefaultNamespace((String)"slowness"), 2, 1, false));
        ConfigTypeConveration.registerType(ToggleableConfig.class, new ConfigTypeToggleable());
        ConfigTypeConveration.registerSpecialType(x -> {
            if (x.isArray()) {
                if (ConfigTypeConveration.has(x.getComponentType())) {
                    return true;
                }
                throw new RuntimeException("Array with holders are not permitted");
            }
            return false;
        }, new ConfigTypeArray());
        ConfigTypeConveration.registerSpecialType(Enum.class::isAssignableFrom, new SimpleConfigTypeConveration<Enum>(){

            private static Class getEnumClass(Class clazz) {
                if (clazz.isEnum()) {
                    return clazz;
                }
                return clazz.getSuperclass();
            }

            @Override
            public Enum readElement(ConfigKey key, Enum defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return Enum.valueOf(defaultValue.getDeclaringClass(), element.getAsString());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Enum value, ConfigKey key, Side side) {
                return new JsonPrimitive(value.name());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, ConfigKey key) {
                parent.add((GuiControl)new GuiComboBox("data", new TextListBuilder().add(8.getEnumClass(key.field().getType()).getEnumConstants(), x -> ((Enum)x).name())));
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            public void loadValue(Enum value, GuiParent parent) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                box.select(value.ordinal());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            @Environment(value=EnvType.CLIENT)
            protected Enum saveValue(GuiParent parent, ConfigKey key) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                return (Enum)8.getEnumClass(key.field().getType()).getEnumConstants()[box.getIndex()];
            }

            @Override
            public Enum set(ConfigKey key, Enum value) {
                return value;
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> List.class.isAssignableFrom((Class<?>)x) || x == ArrayList.class, new ConfigTypeList());
    }

    public static abstract class SimpleConfigTypeConveration<T>
    extends ConfigTypeConveration<T> {
        @Override
        public T readElement(HolderLookup.Provider provider, T defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
            return this.readElement(key, defaultValue, side, element);
        }

        public abstract T readElement(ConfigKey var1, T var2, Side var3, JsonElement var4);

        @Override
        public JsonElement writeElement(HolderLookup.Provider provider, T value, boolean ignoreRestart, boolean saveDefault, Side side, ConfigKey key) {
            return this.writeElement(value, key, side);
        }

        public abstract JsonElement writeElement(T var1, ConfigKey var2, Side var3);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        @Environment(value=EnvType.CLIENT)
        public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
            this.createControls(parent, key);
        }

        @OnlyIn(value=Dist.CLIENT)
        @Environment(value=EnvType.CLIENT)
        public abstract void createControls(GuiParent var1, ConfigKey var2);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        @Environment(value=EnvType.CLIENT)
        public void loadValue(T value, T defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
            this.loadValue(value, parent);
        }

        @OnlyIn(value=Dist.CLIENT)
        @Environment(value=EnvType.CLIENT)
        public abstract void loadValue(T var1, GuiParent var2);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        @Environment(value=EnvType.CLIENT)
        protected T saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
            return this.saveValue(parent, key);
        }

        @OnlyIn(value=Dist.CLIENT)
        @Environment(value=EnvType.CLIENT)
        protected abstract T saveValue(GuiParent var1, ConfigKey var2);
    }
}

