/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Environment(value=EnvType.CLIENT)
public class GuiRenderHelper {
    private static final Minecraft mc = Minecraft.getInstance();

    public static Font getFont() {
        return GuiRenderHelper.mc.font;
    }

    public static void drawItemStack(GuiGraphics graphics, ItemStack stack, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        graphics.renderItem(stack, 0, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawStringCentered(GuiGraphics graphics, String text, float width, float height, int color, boolean shadow) {
        int dotWith;
        int textWidth = GuiRenderHelper.mc.font.width((String)text);
        if ((float)textWidth > width && textWidth > (dotWith = GuiRenderHelper.mc.font.width("..."))) {
            int charWidth;
            StringBuilder builder = new StringBuilder();
            textWidth = 0;
            for (int i = 0; i < ((String)text).length() && (float)((charWidth = GuiRenderHelper.mc.font.width("" + ((String)text).charAt(i))) + textWidth + dotWith) < width; ++i) {
                builder.append(((String)text).charAt(i));
                textWidth += charWidth;
            }
            text = String.valueOf(builder) + "...";
        }
        Font font = GuiRenderHelper.mc.font;
        int n = (int)(width / 2.0f - (float)(GuiRenderHelper.mc.font.width((String)text) / 2));
        float f = height / 2.0f;
        Objects.requireNonNull(GuiRenderHelper.mc.font);
        graphics.drawString(font, (String)text, n, (int)(f - (float)(9 / 2)), -1, shadow);
    }

    public static void horizontalGradientRect(GuiGraphics graphics, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        VertexConsumer consumer = graphics.bufferSource().getBuffer(RenderType.gui());
        Matrix4f matrix = graphics.pose().last().pose();
        boolean z = false;
        consumer.addVertex(matrix, (float)x2, (float)y, (float)z).setColor(colorTo);
        consumer.addVertex(matrix, (float)x, (float)y, (float)z).setColor(colorFrom);
        consumer.addVertex(matrix, (float)x, (float)y2, (float)z).setColor(colorFrom);
        consumer.addVertex(matrix, (float)x2, (float)y2, (float)z).setColor(colorTo);
    }

    public static void verticalGradientRect(GuiGraphics graphics, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        VertexConsumer consumer = graphics.bufferSource().getBuffer(RenderType.gui());
        Matrix4f matrix = graphics.pose().last().pose();
        boolean z = false;
        consumer.addVertex(matrix, (float)x2, (float)y, (float)z).setColor(colorFrom);
        consumer.addVertex(matrix, (float)x, (float)y, (float)z).setColor(colorFrom);
        consumer.addVertex(matrix, (float)x, (float)y2, (float)z).setColor(colorTo);
        consumer.addVertex(matrix, (float)x2, (float)y2, (float)z).setColor(colorTo);
    }

    public static void horizontalGradientMaskRect(GuiGraphics graphics, int x, int y, int x2, int y2, int color, int mask) {
        GuiRenderHelper.horizontalGradientRect(graphics, x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    public static void colorRect(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        VertexConsumer consumer = graphics.bufferSource().getBuffer(RenderType.gui());
        Matrix4f matrix = graphics.pose().last().pose();
        boolean z = false;
        consumer.addVertex(matrix, (float)x, (float)y, (float)z).setColor(color);
        consumer.addVertex(matrix, (float)x, (float)(y + height), (float)z).setColor(color);
        consumer.addVertex(matrix, (float)(x + width), (float)(y + height), (float)z).setColor(color);
        consumer.addVertex(matrix, (float)(x + width), (float)y, (float)z).setColor(color);
    }

    private static void textureRect(GuiGraphics graphics, int x, int y, int z, int width, int height, float u, float v, int textureWidth, int textureHeight) {
        GuiRenderHelper.textureRect(graphics, x, x + width, y, y + height, z, u, v, width, height, textureWidth, textureHeight);
    }

    public static void textureRect(GuiGraphics graphics, int x, int y, int width, int height, float u, float v) {
        GuiRenderHelper.textureRect(graphics, x, y, 0, width, height, u, v, 256, 256);
    }

    public static void textureRect(GuiGraphics graphics, int x, int y, int width, int height, float u, float v, float u2, float v2) {
        GuiRenderHelper.textureRect(graphics, x, x + width, y, y + height, 0, u, v, u2, v2, 256, 256);
    }

    private static void textureRect(GuiGraphics graphics, int x, int x2, int y, int y2, int z, float u, float v, float u2, float v2, int textureWidth, int textureHeight) {
        GuiRenderHelper.drawTextureRect(graphics, x, x2, y, y2, z, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight);
    }

    private static void textureRect(GuiGraphics graphics, int x, int x2, int y, int y2, int z, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        GuiRenderHelper.drawTextureRect(graphics, x, x2, y, y2, z, u / (float)textureWidth, (u + (float)uWidth) / (float)textureWidth, v / (float)textureHeight, (v + (float)vHeight) / (float)textureHeight);
    }

    private static void drawTextureRect(GuiGraphics graphics, int x, int x2, int y, int y2, int z, float u, float u2, float v, float v2) {
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix, (float)x, (float)y2, (float)z).setUv(u, v2);
        bufferbuilder.addVertex(matrix, (float)x2, (float)y2, (float)z).setUv(u2, v2);
        bufferbuilder.addVertex(matrix, (float)x2, (float)y, (float)z).setUv(u2, v);
        bufferbuilder.addVertex(matrix, (float)x, (float)y, (float)z).setUv(u, v);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }
}

