/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.tasks;

import dev.ftb.mods.ftbauxilium.ApiManager;
import dev.ftb.mods.ftbauxilium.FTBAuxilium;
import dev.ftb.mods.ftbauxilium.auxilium.ModpackData;
import dev.ftb.mods.ftbauxilium.auxilium.StatManager;
import dev.ftb.mods.ftbauxilium.auxilium.SystemStats;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;

public class LaunchTask
implements Runnable {
    private final SystemStats stat;
    private final StatManager.Launchers launcher;

    public LaunchTask(Minecraft minecraft, StatManager.Launchers launcher) {
        this.stat = new SystemStats(minecraft);
        this.launcher = launcher;
        ModpackData packData = FTBAuxilium.STAT_MANAGER.getPackData();
        if (packData != null) {
            this.stat.packId = packData.id;
            this.stat.packVersionId = packData.versionId;
        }
    }

    @Override
    public void run() {
        boolean successful = ApiManager.get().systemStarted(this.stat);
        ModpackData packData = FTBAuxilium.STAT_MANAGER.getPackData();
        packData.loadTime = FTBAuxilium.STAT_MANAGER.getLoadTimeInSeconds();
        packData.modLoader = ClientBrandRetriever.getClientModName();
        packData.launcher = this.launcher;
        boolean modpackDataSuccess = ApiManager.get().modpackData(packData);
        if (!successful && !modpackDataSuccess) {
            FTBAuxilium.LOGGER.debug("Failed to send initial system data");
        }
    }
}

