/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers.recipe;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.mikey.justhammers.HammerItem;
import pro.mikey.justhammers.config.SimpleJsonConfig;
import pro.mikey.justhammers.recipe.HammerRecipes;

public class RepairRecipe
extends CustomRecipe {
    public RepairRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput recipeInput) {
        NonNullList remainingItems = NonNullList.withSize((int)recipeInput.size(), (Object)ItemStack.EMPTY);
        Pair<ItemStack, ItemStack> repairTargets = this.getRepairTargets(recipeInput);
        if (repairTargets == null) {
            return remainingItems;
        }
        ItemStack hammer = (ItemStack)repairTargets.getFirst();
        ItemStack repairItem = (ItemStack)repairTargets.getSecond();
        int currentDamage = hammer.getDamageValue();
        boolean isNetheriteHammer = ((DiggerItem)hammer.getItem()).getTier().getRepairIngredient().test(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
        double repairPercentage = isNetheriteHammer ? SimpleJsonConfig.INSTANCE.durabilityRepairPercentageNetherite.get().getAsDouble() : SimpleJsonConfig.INSTANCE.durabilityRepairPercentage.get().getAsDouble();
        double repairAmount = Math.floor((double)hammer.getMaxDamage() / 100.0 * repairPercentage);
        int neededRepairItems = Math.max(1, (int)Math.floor((double)currentDamage / repairAmount));
        neededRepairItems = Math.min(neededRepairItems, repairItem.getCount());
        repairItem.shrink(neededRepairItems - 1);
        return remainingItems;
    }

    public boolean matches(CraftingInput recipeInput, Level level) {
        return this.getRepairTargets(recipeInput) != null;
    }

    @NotNull
    public ItemStack assemble(CraftingInput recipeInput, HolderLookup.Provider provider) {
        Pair<ItemStack, ItemStack> repairTargets = this.getRepairTargets(recipeInput);
        if (repairTargets == null) {
            return ItemStack.EMPTY;
        }
        ItemStack hammer = (ItemStack)repairTargets.getFirst();
        ItemStack repairItem = (ItemStack)repairTargets.getSecond();
        ItemStack repairedHammer = hammer.copy();
        boolean isNetheriteHammer = ((DiggerItem)hammer.getItem()).getTier().getRepairIngredient().test(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
        double percentage = isNetheriteHammer ? SimpleJsonConfig.INSTANCE.durabilityRepairPercentageNetherite.get().getAsDouble() : SimpleJsonConfig.INSTANCE.durabilityRepairPercentage.get().getAsDouble();
        double repairAmount = Math.floor((double)hammer.getMaxDamage() / 100.0 * percentage);
        int currentDamage = hammer.getDamageValue();
        int neededRepairItems = Math.max(1, (int)Math.floor((double)currentDamage / repairAmount));
        int availableRepairItems = repairItem.getCount();
        neededRepairItems = Math.min(neededRepairItems, availableRepairItems);
        double repairAmountTotal = (double)neededRepairItems * repairAmount;
        double newDamage = Math.max(0.0, (double)currentDamage - repairAmountTotal);
        repairedHammer.setDamageValue((int)newDamage);
        return repairedHammer;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)HammerRecipes.REPAIR_RECIPE_SERIALIZER.get();
    }

    @Nullable
    private Pair<ItemStack, ItemStack> getRepairTargets(CraftingInput recipeInput) {
        if (recipeInput.ingredientCount() != 2) {
            return null;
        }
        ItemStack hammer = null;
        for (int i = 0; i < recipeInput.size(); ++i) {
            ItemStack stack = recipeInput.getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof HammerItem)) continue;
            hammer = stack;
        }
        if (hammer == null) {
            return null;
        }
        if (hammer.getDamageValue() == 0) {
            return null;
        }
        Ingredient repairItem = ((HammerItem)hammer.getItem()).getTier().getRepairIngredient();
        if (repairItem.isEmpty()) {
            return null;
        }
        ItemStack availableRepairItem = null;
        boolean tooManyItems = false;
        for (int i = 0; i < recipeInput.size(); ++i) {
            ItemStack stack = recipeInput.getItem(i);
            Item item = stack.getItem();
            if (item instanceof HammerItem || !repairItem.test(stack)) continue;
            if (availableRepairItem != null) {
                tooManyItems = true;
                break;
            }
            availableRepairItem = stack;
        }
        if (availableRepairItem == null || tooManyItems) {
            return null;
        }
        return Pair.of((Object)hammer, availableRepairItem);
    }
}

