/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.mikey.justhammers.HammersPlatform;

public enum SimpleJsonConfig {
    INSTANCE;

    private static final Logger LOGGER;
    private static final Gson GSON;
    private static final String CONFIG_FILE_NAME = "justhammers.json";
    private static final Path CONFIG_FILE;
    private List<CommentedEntry> entries = new LinkedList<CommentedEntry>();
    public final CommentedEntry disabledDurabilityTooltip = this.create("disabledDurabilityTooltip", new JsonPrimitive(Boolean.valueOf(false)), "Set to true to disable the durability tooltip on hammers");
    public final CommentedEntry durabilityRepairPercentage = this.create("durabilityRepairPercentage", new JsonPrimitive((Number)33.33), "The percentage of durability restored per repair item");
    public final CommentedEntry durabilityRepairPercentageNetherite = this.create("durabilityRepairPercentageNetherite", new JsonPrimitive((Number)100.0), "The percentage of durability restored per repair item for netherite hammers");
    private JsonObject config;

    public void load() {
        if (Files.notExists(CONFIG_FILE, new LinkOption[0])) {
            this.writeDefault();
        }
        try {
            this.config = (JsonObject)GSON.fromJson((Reader)Files.newBufferedReader(CONFIG_FILE), JsonObject.class);
            this.addMissingEntries();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config", (Throwable)e);
            this.writeDefault();
        }
    }

    public void writeDefault() {
        this.config = new JsonObject();
        for (CommentedEntry entry : this.entries) {
            entry.write(this.config);
        }
        try {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            Files.write(CONFIG_FILE, GSON.toJson((JsonElement)this.config).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to write default config", (Throwable)e);
        }
    }

    public void addMissingEntries() {
        boolean changed = false;
        for (CommentedEntry entry : this.entries) {
            if (this.config.has(entry.key)) continue;
            entry.write(this.config);
            changed = true;
        }
        if (!changed) {
            return;
        }
        try {
            Files.write(CONFIG_FILE, GSON.toJson((JsonElement)this.config).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to write default config", (Throwable)e);
        }
    }

    private CommentedEntry create(String key, JsonPrimitive defaultValue, String comment) {
        CommentedEntry commentedEntry = new CommentedEntry(this, key, defaultValue, comment);
        this.entries.add(commentedEntry);
        return commentedEntry;
    }

    static {
        LOGGER = LoggerFactory.getLogger(SimpleJsonConfig.class);
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_FILE = HammersPlatform.getConfigDirectory().resolve(CONFIG_FILE_NAME);
    }

    public static class CommentedEntry
    implements Supplier<JsonPrimitive> {
        private final SimpleJsonConfig parent;
        private final String key;
        private final JsonPrimitive defaultValue;
        private final String comment;
        private JsonPrimitive value;

        public CommentedEntry(SimpleJsonConfig parent, String key, JsonPrimitive defaultValue, String comment) {
            this.parent = parent;
            this.key = key;
            this.defaultValue = defaultValue;
            this.comment = comment;
        }

        @Override
        public JsonPrimitive get() {
            if (this.value == null) {
                JsonObject obj = this.parent.config.getAsJsonObject(this.key);
                this.value = obj == null ? this.defaultValue : obj.getAsJsonPrimitive("value");
                if (this.value == null) {
                    this.value = this.defaultValue;
                }
            }
            return this.value;
        }

        public void write(JsonObject object) {
            JsonObject holder = new JsonObject();
            holder.add("value", (JsonElement)this.defaultValue);
            holder.addProperty("_comment", this.comment);
            object.add(this.key, (JsonElement)holder);
        }
    }
}

