/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.registry;

import com.klikli_dev.occultism.common.capability.FamiliarSettingsData;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class OccultismDataStorage {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"occultism");
    public static final Supplier<AttachmentType<Integer>> DOUBLE_JUMP = ATTACHMENT_TYPES.register("double_jump", () -> AttachmentType.builder(() -> 0).serialize((Codec)Codec.INT).build());
    public static final Supplier<AttachmentType<FamiliarSettingsData>> FAMILIAR_SETTINGS = ATTACHMENT_TYPES.register("familiar_settings", () -> AttachmentType.serializable(FamiliarSettingsData::new).build());

    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal().hasData(FAMILIAR_SETTINGS)) {
            ((FamiliarSettingsData)event.getEntity().getData(FAMILIAR_SETTINGS)).clone((FamiliarSettingsData)event.getOriginal().getData(FAMILIAR_SETTINGS));
        }
    }

    public static void onJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            FamiliarSettingsData.syncFor(player);
        }
    }
}

