/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.handlers;

import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.block.SpiritFireBlock;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.common.item.tool.SoulGemItem;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="occultism", bus=EventBusSubscriber.Bus.GAME)
public class PlayerEventHandler {
    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isFireCharge;
        PlayerEventHandler.dancingFamiliars(event);
        boolean isFlintAndSteel = event.getItemStack().getItem() == Items.FLINT_AND_STEEL;
        boolean bl = isFireCharge = event.getItemStack().getItem() == Items.FIRE_CHARGE;
        if (isFlintAndSteel || isFireCharge) {
            AABB box = new AABB(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0).move(Math3DUtil.center(event.getPos()));
            List list = event.getLevel().getEntitiesOfClass(ItemEntity.class, box, item -> item.getItem().getItem() == OccultismItems.DATURA.get());
            if (!list.isEmpty()) {
                BlockPos pos = event.getPos().relative(event.getFace());
                if (!event.getEntity().mayUseItemAt(pos, event.getFace(), event.getItemStack())) {
                    return;
                }
                list.forEach(e -> e.remove(Entity.RemovalReason.DISCARDED));
                Level level = event.getLevel();
                if (level.isEmptyBlock(pos)) {
                    SoundEvent soundEvent = isFlintAndSteel ? SoundEvents.FLINTANDSTEEL_USE : SoundEvents.FIRECHARGE_USE;
                    level.playSound(event.getEntity(), pos, soundEvent, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.4f + 0.8f);
                    level.setBlock(pos, ((SpiritFireBlock)((Object)OccultismBlocks.SPIRIT_FIRE.get())).defaultBlockState(), 11);
                }
                if (isFlintAndSteel) {
                    event.getItemStack().hurtAndBreak(1, (LivingEntity)event.getEntity(), LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
                } else if (isFireCharge) {
                    event.getItemStack().shrink(1);
                }
                event.setCanceled(true);
                event.getEntity().swing(InteractionHand.MAIN_HAND);
            }
        }
    }

    private static void dancingFamiliars(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getLevel().getBlockState(event.getPos());
        if (!state.hasProperty((Property)JukeboxBlock.HAS_RECORD) || ((Boolean)state.getValue((Property)JukeboxBlock.HAS_RECORD)).booleanValue() || !event.getItemStack().has(DataComponents.JUKEBOX_PLAYABLE)) {
            return;
        }
        if (event.getLevel().getEntitiesOfClass(Entity.class, new AABB(event.getPos()).inflate(3.0), e -> e instanceof IFamiliar && ((IFamiliar)e).getFamiliarOwner() == event.getEntity()).isEmpty()) {
            return;
        }
        ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger((LivingEntity)event.getEntity(), FamiliarTrigger.Type.PARTY);
    }

    @SubscribeEvent
    public static void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().getItem() == OccultismItems.SOUL_GEM_ITEM.get() && event.getTarget() instanceof LivingEntity && ((SoulGemItem)((Object)OccultismItems.SOUL_GEM_ITEM.get())).interactLivingEntity(event.getItemStack(), event.getEntity(), (LivingEntity)event.getTarget(), event.getHand()) == InteractionResult.SUCCESS) {
            event.setCanceled(true);
        }
    }
}

