/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookEntryReadConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.datagen.OccultismBookProvider;
import com.klikli_dev.occultism.datagen.book.binding_rituals.ApprenticeRitualSatchelEntry;
import com.klikli_dev.occultism.datagen.book.binding_rituals.ArtisanalRitualSatchelEntry;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class BindingRitualsCategory
extends CategoryProvider {
    public static final String CATEGORY_ID = "crafting_rituals";

    public BindingRitualsCategory(OccultismBookProvider parent) {
        super((ModonomiconProviderBase)parent);
    }

    protected String[] generateEntryMap() {
        return new String[]{"___________________________", "_______b_e_x_p_q_r_________", "___________________________", "_______d_h_c__w_v_s________", "___________________________", "___9_0______________y______", "___________________________", "_______f_z_a__g_\u011d_\u011f________", "___________________________", "_________o_n_m_____________", "___________________________", "___________i_j_k_l_________", "___________________________"};
    }

    protected void generateEntries() {
        String craftFoliotID = this.modId() + ":pentacles/craft_foliot";
        String craftDjinniID = this.modId() + ":pentacles/craft_djinni";
        String craftAfritID = this.modId() + ":pentacles/craft_afrit";
        String craftMaridID = this.modId() + ":pentacles/craft_marid";
        String contactWildID = this.modId() + ":pentacles/contact_wild_spirit";
        String contactEldritchID = this.modId() + ":pentacles/contact_eldritch_spirit";
        BookEntryModel overview = this.add(this.makeCraftingRitualsOverviewEntry(this.entryMap, '0'));
        overview.withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftFoliotID));
        BookEntryModel returnToRituals = this.add(this.makeReturnToRitualsEntry(this.entryMap, '9'));
        returnToRituals.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftFoliotID));
        BookEntryModel craftInfusedPickaxe = this.add(this.makeCraftInfusedPickaxeEntry(this.entryMap, 'd'));
        craftInfusedPickaxe.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftDjinniID));
        BookEntryModel craftDimensionalMineshaft = this.add(this.makeCraftDimensionalMineshaftEntry(this.entryMap, 'b'));
        craftDimensionalMineshaft.withParent(BookEntryParentModel.create((ResourceLocation)craftInfusedPickaxe.getId()));
        BookEntryModel craftFoliotMiner = this.add(this.makeCraftFoliotMinerEntry(this.entryMap, 'e'));
        craftFoliotMiner.withParent(BookEntryParentModel.create((ResourceLocation)craftDimensionalMineshaft.getId()));
        BookEntryModel craftDjinniMiner = this.add(this.makeCraftDjinniMinerEntry(this.entryMap, 'x'));
        craftDjinniMiner.withParent(BookEntryParentModel.create((ResourceLocation)craftFoliotMiner.getId()));
        BookEntryModel craftAfritMiner = this.add(this.makeCraftAfritMinerEntry(this.entryMap, 'p'));
        craftAfritMiner.withParent(BookEntryParentModel.create((ResourceLocation)craftDjinniMiner.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftAfritID));
        BookEntryModel craftMaridMiner = this.add(this.makeCraftMaridMinerEntry(this.entryMap, 'q'));
        craftMaridMiner.withParent(BookEntryParentModel.create((ResourceLocation)craftAfritMiner.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftMaridID));
        BookEntryModel craftAncientMiner = this.add(this.makeCraftAncientMinerEntry(this.entryMap, 'r'));
        craftAncientMiner.withParent(BookEntryParentModel.create((ResourceLocation)craftAfritMiner.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(contactEldritchID));
        BookEntryModel craftStorageSystem = this.add(this.makeCraftStorageSystemEntry(this.entryMap, 'z'));
        craftStorageSystem.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftDjinniID));
        BookEntryModel craftDimensionalMatrix = this.add(this.makeCraftDimensionalMatrixEntry(this.entryMap, 'a'));
        craftDimensionalMatrix.withParent(BookEntryParentModel.create((ResourceLocation)craftStorageSystem.getId()));
        BookEntryModel craftStorageControllerBase = this.add(this.makeCraftStorageControllerBaseEntry(this.entryMap, 'n'));
        craftStorageControllerBase.withParent(BookEntryParentModel.create((ResourceLocation)craftDimensionalMatrix.getId()));
        BookEntryModel craftStabilizerTier1 = this.add(this.makeCraftStabilizerTier1Entry(this.entryMap, 'i'));
        craftStabilizerTier1.withParent(BookEntryParentModel.create((ResourceLocation)craftStorageControllerBase.getId()));
        BookEntryModel craftStabilizerTier2 = this.add(this.makeCraftStabilizerTier2Entry(this.entryMap, 'j'));
        craftStabilizerTier2.withParent(BookEntryParentModel.create((ResourceLocation)craftStabilizerTier1.getId()));
        BookEntryModel craftStabilizerTier3 = this.add(this.makeCraftStabilizerTier3Entry(this.entryMap, 'k'));
        craftStabilizerTier3.withParent(BookEntryParentModel.create((ResourceLocation)craftStabilizerTier2.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftAfritID));
        BookEntryModel craftStabilizerTier4 = this.add(this.makeCraftStabilizerTier4Entry(this.entryMap, 'l'));
        craftStabilizerTier4.withParent(BookEntryParentModel.create((ResourceLocation)craftStabilizerTier3.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftMaridID));
        BookEntryModel craftStableWormhole = this.add(this.makeCraftStableWormholeEntry(this.entryMap, 'm'));
        craftStableWormhole.withParent(BookEntryParentModel.create((ResourceLocation)craftStorageControllerBase.getId()));
        BookEntryModel craftStorageRemote = this.add(this.makeCraftStorageRemoteEntry(this.entryMap, 'o'));
        craftStorageRemote.withParent(BookEntryParentModel.create((ResourceLocation)craftStorageControllerBase.getId()));
        BookEntryModel craftOtherworldGoggles = this.add(this.makeCraftOtherworldGogglesEntry(this.entryMap, 'f'));
        craftOtherworldGoggles.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftFoliotID));
        BookEntryModel craftSatchel = this.add(this.makeCraftSatchelEntry(this.entryMap, 'g'));
        craftSatchel.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftFoliotID));
        BookEntryModel apprenticeRitualSatchel = this.add(new ApprenticeRitualSatchelEntry(this).generate('\u011d'));
        apprenticeRitualSatchel.withParent(craftSatchel).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftDjinniID));
        BookEntryModel artisanalRitualSatchel = this.add(new ArtisanalRitualSatchelEntry(this).generate('\u011f'));
        artisanalRitualSatchel.withParent(apprenticeRitualSatchel).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftAfritID));
        BookEntryModel craftSoulGem = this.add(this.makeCraftSoulGemEntry(this.entryMap, 'h'));
        craftSoulGem.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftDjinniID));
        BookEntryModel craftFamiliarRing = this.add(this.makeCraftFamiliarRingEntry(this.entryMap, 'c'));
        craftFamiliarRing.withParent(BookEntryParentModel.create((ResourceLocation)craftSoulGem.getId()));
        BookEntryModel craftWildTrim = this.add(this.makeCraftWildTrimEntry(this.entryMap, 'w'));
        craftWildTrim.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(contactWildID));
        BookEntryModel craftAmethyst = this.add(this.makeCraftAmethystEntry(this.entryMap, 'v'));
        craftAmethyst.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(contactWildID));
        BookEntryModel craftDeepslate = this.add(this.makeCraftDeepslateEntry(this.entryMap, 's'));
        craftDeepslate.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(contactEldritchID)).hideWhileLocked(true);
        BookEntryModel repairRituals = this.add(this.makeRepairEntry(this.entryMap, 'y'));
        repairRituals.withParent(BookEntryParentModel.create((ResourceLocation)overview.getId())).withCondition((BookConditionModel)BookEntryReadConditionModel.create().withEntry(craftDjinniID));
    }

    protected String categoryName() {
        return "Binding Rituals";
    }

    protected BookIconModel categoryIcon() {
        return BookIconModel.create((ResourceLocation)this.modLoc("textures/gui/book/infusion.png"));
    }

    public String categoryId() {
        return CATEGORY_ID;
    }

    private BookEntryModel makeReturnToRitualsEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("return_to_rituals");
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/robe.png")).withCategoryToOpen(this.modLoc("rituals")).withEntryBackground(1, 2).withLocation(entryMap.get(Character.valueOf(icon)));
    }

    private BookEntryModel makeCraftingRitualsOverviewEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("overview");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(this.modLoc("textures/gui/book/infusion.png")).withLocation(entryMap.get(Character.valueOf(icon))).withEntryBackground(0, 1).withPages(new BookPageModel[]{intro});
    }

    private BookEntryModel makeCraftStorageSystemEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_storage_system");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get()})).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.CHEST).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight});
    }

    private BookEntryModel makeCraftDimensionalMatrixEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_dimensional_matrix");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_dimensional_matrix"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftDimensionalMineshaftEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_dimensional_mineshaft");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_dimensional_mineshaft"));
        this.context().page("description");
        BookTextPageModel description = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("config");
        BookTextPageModel config = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual, description, config});
    }

    private BookEntryModel makeCraftInfusedPickaxeEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_infused_pickaxe");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.INFUSED_PICKAXE.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_infused_pickaxe"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.INFUSED_PICKAXE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    public BookEntryModel makeCraftStorageControllerBaseEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_storage_controller_base");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_CONTROLLER_BASE.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_storage_controller_base"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_CONTROLLER_BASE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    public BookEntryModel makeCraftStabilizerTier1Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_stabilizer_tier1");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier1"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    public BookEntryModel makeCraftStabilizerTier2Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_stabilizer_tier2");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER2.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier2"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER2.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    public BookEntryModel makeCraftStabilizerTier3Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_stabilizer_tier3");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER3.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier3"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER3.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    public BookEntryModel makeCraftStabilizerTier4Entry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_stabilizer_tier4");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_stabilizer_tier4"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    public BookEntryModel makeCraftStableWormholeEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_stable_wormhole");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STABLE_WORMHOLE.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_stable_wormhole"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismBlocks.STABLE_WORMHOLE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    public BookEntryModel makeCraftStorageRemoteEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_storage_remote");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.STORAGE_REMOTE.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_storage_remote"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.STORAGE_REMOTE.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftFoliotMinerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_foliot_miner");
        this.context().page("intro");
        BookTextPageModel intro = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("magic_lamp");
        BookTextPageModel lamp = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("magic_lamp_recipe");
        BookCraftingRecipePageModel lampRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/magic_lamp_empty"));
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_miner_foliot_unspecialized"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{intro, lamp, lampRecipe, spotlight, ritual});
    }

    private BookEntryModel makeCraftDjinniMinerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_djinni_miner");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_DJINNI_ORES.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_miner_djinni_ores"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.MINER_DJINNI_ORES.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftAfritMinerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_afrit_miner");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_AFRIT_DEEPS.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_miner_afrit_deeps"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.MINER_AFRIT_DEEPS.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftMaridMinerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_marid_miner");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_MARID_MASTER.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_miner_marid_master"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.MINER_MARID_MASTER.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftAncientMinerEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_ancient_miner");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_ANCIENT_ELDRITCH.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_miner_ancient_eldritch"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.MINER_ANCIENT_ELDRITCH.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftSatchelEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_satchel");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SATCHEL.get()})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_satchel"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.SATCHEL.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftSoulGemEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_soul_gem");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SOUL_GEM_ITEM.get()})).withText(this.context().pageText());
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_soul_gem"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.SOUL_GEM_ITEM.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, usage, ritual});
    }

    private BookEntryModel makeCraftFamiliarRingEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_familiar_ring");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.FAMILIAR_RING.get()})).withText(this.context().pageText());
        this.context().page("usage");
        BookTextPageModel usage = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_familiar_ring"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.FAMILIAR_RING.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, usage, ritual});
    }

    private BookEntryModel makeCraftOtherworldGogglesEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_otherworld_goggles");
        this.context().page("goggles_spotlight");
        BookSpotlightPageModel gogglesSpotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()})).withText(this.context().pageText());
        this.context().page("goggles_more");
        BookTextPageModel gogglesMore = BookTextPageModel.create().withText(this.context().pageText());
        this.context().page("lenses_spotlight");
        BookSpotlightPageModel lensesSpotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.LENSES.get()})).withText(this.context().pageText());
        this.context().page("lenses_more");
        BookTextPageModel lensesMore = BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("lenses_recipe");
        BookCraftingRecipePageModel lensesRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/lenses"));
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_infused_lenses"));
        this.context().page("goggles_recipe");
        BookCraftingRecipePageModel gogglesRecipe = (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/goggles"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get()).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{gogglesSpotlight, gogglesMore, lensesSpotlight, lensesMore, lensesRecipe, ritual, gogglesRecipe});
    }

    private BookEntryModel makeCraftWildTrimEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_wild_trim");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_wild_trim"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftAmethystEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_budding_amethyst");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.BUDDING_AMETHYST})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/misc_budding_amethyst"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.BUDDING_AMETHYST).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeCraftDeepslateEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("craft_reinforced_deepslate");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.REINFORCED_DEEPSLATE})).withText(this.context().pageText());
        this.context().page("ritual");
        BookRitualRecipePageModel ritual = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/misc_reinforced_deepslate"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon((ItemLike)Items.REINFORCED_DEEPSLATE).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritual});
    }

    private BookEntryModel makeRepairEntry(CategoryEntryMap entryMap, char icon) {
        this.context().entry("repair");
        this.context().page("spotlight");
        BookSpotlightPageModel spotlight = BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.ANVIL})).withTitle(this.context().pageTitle()).withText(this.context().pageText());
        this.context().page("ritual_chalks");
        BookRitualRecipePageModel ritualChalks = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/repair_chalks"));
        this.context().page("ritual_chalks");
        BookRitualRecipePageModel ritualMiners = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/repair_miners"));
        this.context().page("ritual_chalks");
        BookRitualRecipePageModel ritualTools = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/repair_tools"));
        this.context().page("ritual_chalks");
        BookRitualRecipePageModel ritualArmors = (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/repair_armors"));
        return BookEntryModel.create((ResourceLocation)this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), (String)this.context().entryName()).withIcon(OccultismItems.REPAIR_ICON).withLocation(entryMap.get(Character.valueOf(icon))).withPages(new BookPageModel[]{spotlight, ritualChalks, ritualMiners, ritualTools, ritualArmors});
    }
}

