/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModelsGenerator
extends ItemModelProvider {
    public ItemModelsGenerator(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "occultism", existingFileHelper);
    }

    protected void registerModels() {
        BuiltInRegistries.ITEM.forEach(item -> {
            ResourceLocation key = BuiltInRegistries.ITEM.getKey(item);
            if (key.getPath().startsWith("ritual_dummy/")) {
                this.registerRitualDummy("item/" + key.getPath());
            } else if (key.getPath().startsWith("spawn_egg/")) {
                this.registerSpawnEgg("item/" + key.getPath());
            }
        });
        this.registerAdvancementItem();
        this.registerItemCommon();
        this.registerItemHandheld();
        this.registerItemFromBlock();
        this.registerItemMiners();
        this.registerItemGenerated(this.name((Item)OccultismItems.BOOK_OF_CALLING_DJINNI_MANAGE_MACHINE.get()), "book_of_calling_manage_machine");
        this.registerItemGenerated(this.name((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_CLEANER.get()), "book_of_calling_cleaner");
        this.registerItemGenerated(this.name((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_LUMBERJACK.get()), "book_of_calling_lumberjack");
        this.registerItemGenerated(this.name((Item)OccultismItems.BOOK_OF_CALLING_FOLIOT_TRANSPORT_ITEMS.get()), "book_of_calling_transport_items");
        this.registerItemGenerated(this.name((Item)OccultismItems.PENTACLE_SUMMON.get()), "ritual_dummy_summon");
        this.registerItemGenerated(this.name((Item)OccultismItems.PENTACLE_POSSESS.get()), "ritual_dummy_possess");
        this.registerItemGenerated(this.name((Item)OccultismItems.PENTACLE_CRAFT.get()), "ritual_dummy_craft");
        this.registerItemGenerated(this.name((Item)OccultismItems.PENTACLE_MISC.get()), "ritual_dummy_misc");
    }

    protected String name(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    private void registerItemGenerated(String name, String texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("item/" + texture));
    }

    private void registerRitualDummy(String name) {
        if (name.contains("misc") || name.contains("contact") || name.contains("wild") || name.contains("resurrect")) {
            ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("occultism:item/pentacle_misc"));
        } else if (name.contains("craft") || name.contains("repair")) {
            ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("occultism:item/pentacle_craft"));
        } else if (name.contains("invoke") || name.contains("possess") || name.contains("familiar")) {
            ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("occultism:item/pentacle_possess"));
        } else if (name.contains("summon")) {
            ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("occultism:item/pentacle_summon"));
        }
    }

    private void registerSpawnEgg(String name) {
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/template_spawn_egg"));
    }

    private void registerAdvancementItem() {
        String[] textures = new String[]{"cthulhu_icon", "bat_icon", "deer_icon", "devil_icon", "greedy_icon", "hat_icon", "dragon_icon", "blacksmith_icon", "guardian_icon", "headless_icon", "chimera_icon", "shub_niggurath_icon", "shub_niggurath_spawn_icon", "beholder_icon", "fairy_icon", "mummy_icon", "beaver_icon"};
        ArrayList<ItemModelBuilder> icons = new ArrayList<ItemModelBuilder>();
        for (String texture : textures) {
            icons.add((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("item/advancement/" + texture, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/advancement/" + texture)));
        }
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("item/advancement_icon", this.mcLoc("item/generated"));
        for (int i = 0; i < icons.size(); ++i) {
            builder.override().predicate(this.mcLoc("custom_model_data"), (float)i).model((ModelFile)icons.get(i)).end();
        }
    }

    private void registerItemCommon() {
        String[] items;
        for (String item : items = new String[]{this.name((Item)OccultismItems.AFRIT_ESSENCE.get()), this.name((Item)OccultismItems.AMETHYST_DUST.get()), this.name((Item)OccultismItems.AWAKENED_FEATHER.get()), this.name((Item)OccultismItems.BEAVER_NUGGET.get()), this.name((Item)OccultismItems.BOOK_OF_BINDING_AFRIT.get()), this.name((Item)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()), this.name((Item)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()), this.name((Item)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()), this.name((Item)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()), this.name((Item)OccultismItems.BOOK_OF_BINDING_DJINNI.get()), this.name((Item)OccultismItems.BOOK_OF_BINDING_EMPTY.get()), this.name((Item)OccultismItems.BOOK_OF_BINDING_FOLIOT.get()), this.name((Item)OccultismItems.BOOK_OF_BINDING_MARID.get()), this.name((Item)OccultismItems.BRUSH.get()), this.name((Item)OccultismItems.BURNT_OTHERSTONE.get()), this.name((Item)OccultismItems.CHALK_BLACK.get()), this.name((Item)OccultismItems.CHALK_BLACK_IMPURE.get()), this.name((Item)OccultismItems.CHALK_BLUE.get()), this.name((Item)OccultismItems.CHALK_BLUE_IMPURE.get()), this.name((Item)OccultismItems.CHALK_BROWN.get()), this.name((Item)OccultismItems.CHALK_BROWN_IMPURE.get()), this.name((Item)OccultismItems.CHALK_CYAN.get()), this.name((Item)OccultismItems.CHALK_CYAN_IMPURE.get()), this.name((Item)OccultismItems.CHALK_YELLOW.get()), this.name((Item)OccultismItems.CHALK_YELLOW_IMPURE.get()), this.name((Item)OccultismItems.CHALK_GRAY.get()), this.name((Item)OccultismItems.CHALK_GRAY_IMPURE.get()), this.name((Item)OccultismItems.CHALK_GREEN.get()), this.name((Item)OccultismItems.CHALK_GREEN_IMPURE.get()), this.name((Item)OccultismItems.CHALK_LIGHT_BLUE.get()), this.name((Item)OccultismItems.CHALK_LIGHT_BLUE_IMPURE.get()), this.name((Item)OccultismItems.CHALK_LIGHT_GRAY.get()), this.name((Item)OccultismItems.CHALK_LIGHT_GRAY_IMPURE.get()), this.name((Item)OccultismItems.CHALK_LIME.get()), this.name((Item)OccultismItems.CHALK_LIME_IMPURE.get()), this.name((Item)OccultismItems.CHALK_MAGENTA.get()), this.name((Item)OccultismItems.CHALK_MAGENTA_IMPURE.get()), this.name((Item)OccultismItems.CHALK_ORANGE.get()), this.name((Item)OccultismItems.CHALK_ORANGE_IMPURE.get()), this.name((Item)OccultismItems.CHALK_PINK.get()), this.name((Item)OccultismItems.CHALK_PINK_IMPURE.get()), this.name((Item)OccultismItems.CHALK_PURPLE.get()), this.name((Item)OccultismItems.CHALK_PURPLE_IMPURE.get()), this.name((Item)OccultismItems.CHALK_RED.get()), this.name((Item)OccultismItems.CHALK_RED_IMPURE.get()), this.name((Item)OccultismItems.CHALK_WHITE.get()), this.name((Item)OccultismItems.CHALK_WHITE_IMPURE.get()), this.name((Item)OccultismItems.COPPER_DUST.get()), this.name((Item)OccultismItems.CRUELTY_ESSENCE.get()), this.name((Item)OccultismItems.CRUSHED_BLACKSTONE.get()), this.name((Item)OccultismItems.CRUSHED_BLUE_ICE.get()), this.name((Item)OccultismItems.CRUSHED_CALCITE.get()), this.name((Item)OccultismItems.CRUSHED_END_STONE.get()), this.name((Item)OccultismItems.CRUSHED_ICE.get()), this.name((Item)OccultismItems.CRUSHED_PACKED_ICE.get()), this.name((Item)OccultismItems.CURSED_HONEY.get()), this.name((Item)OccultismItems.DATURA.get()), this.name((Item)OccultismItems.DATURA_SEEDS.get()), this.name((Item)OccultismItems.DEBUG_WAND.get()), this.name((Item)OccultismItems.DEMONIC_MEAT.get()), this.name((Item)OccultismItems.DEMONS_DREAM_ESSENCE.get()), this.name((Item)OccultismItems.DICTIONARY_OF_SPIRITS.get()), this.name((Item)OccultismItems.DRAGONYST_DUST.get()), this.name((Item)OccultismItems.ECHO_DUST.get()), this.name((Item)OccultismItems.EMERALD_DUST.get()), this.name((Item)OccultismItems.FAMILIAR_RING.get()), this.name((Item)OccultismItems.GOLD_DUST.get()), this.name((Item)OccultismItems.GRAY_PASTE.get()), this.name((Item)OccultismItems.IESNIUM_DUST.get()), this.name((Item)OccultismItems.IESNIUM_INGOT.get()), this.name((Item)OccultismItems.IESNIUM_NUGGET.get()), this.name((Item)OccultismItems.INFUSED_LENSES.get()), this.name((Item)OccultismItems.IRON_DUST.get()), this.name((Item)OccultismItems.LAPIS_DUST.get()), this.name((Item)OccultismItems.LENS_FRAME.get()), this.name((Item)OccultismItems.LENSES.get()), this.name((Item)OccultismItems.MAGIC_LAMP_EMPTY.get()), this.name((Item)OccultismItems.MARID_ESSENCE.get()), this.name((Item)OccultismItems.MINING_DIMENSION_CORE_PIECE.get()), this.name((Item)OccultismItems.NATURE_PASTE.get()), this.name((Item)OccultismItems.NETHERITE_DUST.get()), this.name((Item)OccultismItems.NETHERITE_SCRAP_DUST.get()), this.name((Item)OccultismItems.OBSIDIAN_DUST.get()), this.name((Item)OccultismItems.OTHERSTONE_FRAME.get()), this.name((Item)OccultismItems.OTHERSTONE_TABLET.get()), this.name((Item)OccultismItems.OTHERWORLD_ASHES.get()), this.name((Item)OccultismItems.OTHERWORLD_ESSENCE.get()), this.name((Item)OccultismItems.PURIFIED_INK.get()), this.name((Item)OccultismItems.REPAIR_ICON.get()), this.name((Item)OccultismItems.RESEARCH_FRAGMENT_DUST.get()), this.name((Item)OccultismItems.RESURRECT_ICON.get()), this.name((Item)OccultismItems.RITUAL_SATCHEL_T1.get()), this.name((Item)OccultismItems.RITUAL_SATCHEL_T2.get()), this.name((Item)OccultismItems.RAW_IESNIUM.get()), this.name((Item)OccultismItems.RAW_SILVER.get()), this.name((Item)OccultismItems.SATCHEL.get()), this.name((Item)OccultismItems.SILVER_DUST.get()), this.name((Item)OccultismItems.SILVER_INGOT.get()), this.name((Item)OccultismItems.SILVER_NUGGET.get()), this.name((Item)OccultismItems.SOUL_SHARD_ITEM.get()), this.name((Item)OccultismItems.SPIRIT_ATTUNED_GEM.get()), this.name((Item)OccultismItems.SPIRIT_ATTUNED_PICKAXE_HEAD.get()), this.name(OccultismBlocks.SPIRIT_CAMPFIRE.asItem()), this.name(OccultismBlocks.SPIRIT_LANTERN.asItem()), this.name((Item)OccultismItems.STORAGE_REMOTE_INERT.get()), this.name((Item)OccultismItems.TABOO_BOOK.get()), this.name((Item)OccultismItems.TALLOW.get()), this.name((Item)OccultismItems.WITHERITE_DUST.get())}) {
            this.registerItemGenerated(item, item);
        }
    }

    private void registerItemHandheld() {
        String[] items;
        for (String item : items = new String[]{this.name((Item)OccultismItems.BUTCHER_KNIFE.get()), this.name((Item)OccultismItems.IESNIUM_PICKAXE.get()), this.name((Item)OccultismItems.INFUSED_PICKAXE.get())}) {
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", this.modLoc("item/" + item));
        }
    }

    private void registerItemFromBlock() {
        String[] items;
        for (String item : items = new String[]{this.name(OccultismBlocks.CHISELED_OTHERSTONE_BRICKS.asItem()), this.name(OccultismBlocks.CRACKED_OTHERSTONE_BRICKS.asItem()), this.name(OccultismBlocks.DIMENSIONAL_MINESHAFT.asItem()), this.name(OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.asItem()), this.name(OccultismBlocks.IESNIUM_BLOCK.asItem()), this.name(OccultismBlocks.IESNIUM_ORE.asItem()), this.name(OccultismBlocks.LARGE_CANDLE.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_WHITE.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_LIGHT_GRAY.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_GRAY.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_BLACK.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_BROWN.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_RED.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_ORANGE.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_YELLOW.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_LIME.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_GREEN.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_CYAN.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_BLUE.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_LIGHT_BLUE.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_PINK.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_MAGENTA.asItem()), this.name(OccultismBlocks.LARGE_CANDLE_PURPLE.asItem()), this.name(OccultismBlocks.OTHERCOBBLESTONE.asItem()), this.name(OccultismBlocks.OTHERCOBBLESTONE_SLAB.asItem()), this.name(OccultismBlocks.OTHERCOBBLESTONE_STAIRS.asItem()), this.name(OccultismBlocks.OTHERPLANKS.asItem()), this.name(OccultismBlocks.OTHERPLANKS_FENCE_GATE.asItem()), this.name(OccultismBlocks.OTHERPLANKS_PRESSURE_PLATE.asItem()), this.name(OccultismBlocks.OTHERPLANKS_SLAB.asItem()), this.name(OccultismBlocks.OTHERPLANKS_STAIRS.asItem()), this.name(OccultismBlocks.OTHERSTONE.asItem()), this.name(OccultismBlocks.OTHERSTONE_BRICKS.asItem()), this.name(OccultismBlocks.OTHERSTONE_BRICKS_SLAB.asItem()), this.name(OccultismBlocks.OTHERSTONE_BRICKS_STAIRS.asItem()), this.name(OccultismBlocks.OTHERSTONE_PEDESTAL.asItem()), this.name(OccultismBlocks.OTHERSTONE_PRESSURE_PLATE.asItem()), this.name(OccultismBlocks.OTHERSTONE_SLAB.asItem()), this.name(OccultismBlocks.OTHERSTONE_STAIRS.asItem()), this.name(OccultismBlocks.OTHERWORLD_LEAVES.asItem()), this.name(OccultismBlocks.OTHERWORLD_LOG.asItem()), this.name(OccultismBlocks.OTHERWORLD_WOOD.asItem()), this.name(OccultismBlocks.POLISHED_OTHERSTONE.asItem()), this.name(OccultismBlocks.POLISHED_OTHERSTONE_SLAB.asItem()), this.name(OccultismBlocks.POLISHED_OTHERSTONE_STAIRS.asItem()), this.name(OccultismBlocks.RAW_IESNIUM_BLOCK.asItem()), this.name(OccultismBlocks.RAW_SILVER_BLOCK.asItem()), this.name(OccultismBlocks.SACRIFICIAL_BOWL.asItem()), this.name(OccultismBlocks.SILVER_BLOCK.asItem()), this.name(OccultismBlocks.SILVER_ORE.asItem()), this.name(OccultismBlocks.SILVER_ORE_DEEPSLATE.asItem()), this.name(OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.asItem()), this.name(OccultismBlocks.STORAGE_STABILIZER_TIER1.asItem()), this.name(OccultismBlocks.STORAGE_STABILIZER_TIER2.asItem()), this.name(OccultismBlocks.STORAGE_STABILIZER_TIER3.asItem()), this.name(OccultismBlocks.STORAGE_STABILIZER_TIER4.asItem()), this.name(OccultismBlocks.STRIPPED_OTHERWORLD_LOG.asItem()), this.name(OccultismBlocks.STRIPPED_OTHERWORLD_WOOD.asItem())}) {
            ((ItemModelBuilder)this.getBuilder(item)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + item)));
        }
    }

    private void registerItemMiners() {
        String[] items;
        for (String item : items = new String[]{this.name((Item)OccultismItems.MINER_AFRIT_DEEPS.get()), this.name((Item)OccultismItems.MINER_DEBUG_UNSPECIALIZED.get()), this.name((Item)OccultismItems.MINER_DJINNI_ORES.get()), this.name((Item)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()), this.name((Item)OccultismItems.MINER_MARID_MASTER.get()), this.name((Item)OccultismItems.MINER_ANCIENT_ELDRITCH.get())}) {
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("item/magic_lamp"));
        }
    }
}

