/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.config;

import net.neoforged.neoforge.common.ModConfigSpec;

public class OccultismServerConfig {
    public final StorageSettings storage;
    public final SpiritJobSettings spiritJobs;
    public final RitualSettings rituals;
    public final ItemSettings itemSettings;
    public final ModConfigSpec spec;

    public OccultismServerConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.storage = new StorageSettings(builder);
        this.spiritJobs = new SpiritJobSettings(builder);
        this.rituals = new RitualSettings(builder);
        this.itemSettings = new ItemSettings(builder);
        this.spec = builder.build();
    }

    public static class StorageSettings {
        public final ModConfigSpec.IntValue stabilizerTier1AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier1AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue stabilizerTier2AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier2AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue stabilizerTier3AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier3AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue stabilizerTier4AdditionalMaxItemTypes;
        public final ModConfigSpec.LongValue stabilizerTier4AdditionalMaxTotalItemCount;
        public final ModConfigSpec.IntValue controllerMaxItemTypes;
        public final ModConfigSpec.LongValue controllerMaxTotalItemCount;
        public final ModConfigSpec.BooleanValue unlinkWormholeOnBreak;

        public StorageSettings(ModConfigSpec.Builder builder) {
            builder.comment("Storage Settings").push("storage");
            this.stabilizerTier1AdditionalMaxItemTypes = builder.comment("The amount of additional slots the storage stabilizer tier 1 provides. 1 Slot holds one item type.").defineInRange("stabilizerTier1AdditionalMaxItemTypes", 64, 0, Integer.MAX_VALUE);
            this.stabilizerTier1AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier1AdditionalMaxTotalItemCount", 512000L, 0L, Integer.MAX_VALUE);
            this.stabilizerTier2AdditionalMaxItemTypes = builder.comment("The amount of slots the storage stabilizer tier 2 provides.").defineInRange("stabilizerTier2AdditionalMaxItemTypes", 128, 0, Integer.MAX_VALUE);
            this.stabilizerTier2AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier2AdditionalMaxTotalItemCount", 1024000L, 0L, Integer.MAX_VALUE);
            this.stabilizerTier3AdditionalMaxItemTypes = builder.comment("The amount of slots the storage stabilizer tier 3 provides.").defineInRange("stabilizerTier3AdditionalMaxItemTypes", 256, 0, Integer.MAX_VALUE);
            this.stabilizerTier3AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier3AdditionalMaxTotalItemCount", 2048000L, 0L, Integer.MAX_VALUE);
            this.stabilizerTier4AdditionalMaxItemTypes = builder.comment("The amount of slots the storage stabilizer tier 4 provides.").defineInRange("stabilizerTier4AdditionalMaxItemTypes", 512, 0, Integer.MAX_VALUE);
            this.stabilizerTier4AdditionalMaxTotalItemCount = builder.comment("The amount by which the stabilizer increases the maximum total item count the controller can hold. This is not per slot but the total amount of all items combined.").defineInRange("stabilizerTier4AdditionalMaxTotalItemCount", 4096000L, 0L, Long.MAX_VALUE);
            this.controllerMaxItemTypes = builder.comment("The amount of slots the storage actuator provides.").defineInRange("controllerMaxItemTypes", 128, 0, Integer.MAX_VALUE);
            this.controllerMaxTotalItemCount = builder.comment("The stack size the storage actuator uses.").defineInRange("controllerMaxTotalItemCount", 256000L, 0L, Long.MAX_VALUE);
            this.unlinkWormholeOnBreak = builder.comment("True to use the configured controllerStackSize for all items, instead of the stack sizes provided by item type (such as 16 for ender pearls, 64 for iron ingot). WARNING: Setting this to false may have a negative impact on performance.").define("unlinkWormholeOnBreak", false);
            builder.pop();
        }
    }

    public static class SpiritJobSettings {
        public final ModConfigSpec.DoubleValue tier1CrusherTimeMultiplier;
        public final ModConfigSpec.DoubleValue tier2CrusherTimeMultiplier;
        public final ModConfigSpec.DoubleValue tier3CrusherTimeMultiplier;
        public final ModConfigSpec.DoubleValue tier4CrusherTimeMultiplier;
        public final ModConfigSpec.DoubleValue tier1CrusherOutputMultiplier;
        public final ModConfigSpec.DoubleValue tier2CrusherOutputMultiplier;
        public final ModConfigSpec.DoubleValue tier3CrusherOutputMultiplier;
        public final ModConfigSpec.DoubleValue tier4CrusherOutputMultiplier;
        public final ModConfigSpec.IntValue drikwingFamiliarSlowFallingSeconds;
        public final ModConfigSpec.IntValue crusherResultPickupDelay;
        public final ModConfigSpec.IntValue blacksmithFamiliarUpgradeCost;
        public final ModConfigSpec.IntValue blacksmithFamiliarUpgradeCooldown;
        public final ModConfigSpec.DoubleValue blacksmithFamiliarRepairChance;

        public SpiritJobSettings(ModConfigSpec.Builder builder) {
            builder.comment("Spirit Job Settings").push("spirit_job");
            this.drikwingFamiliarSlowFallingSeconds = builder.comment("The duration for the slow falling effect applied by a drikwing.").defineInRange("drikwingFamiliarSlowFallingSeconds", 15, 0, Integer.MAX_VALUE);
            this.tier1CrusherTimeMultiplier = builder.comment("The multiplier to each crushing recipe's crushing_time for Tier 1 (Foliot) Crusher Spirits.").defineInRange("tier1CrusherTimeMultiplier", 2.0, 0.0, Double.MAX_VALUE);
            this.tier2CrusherTimeMultiplier = builder.comment("The multiplier to each crushing recipe's crushing_time for Tier 2 (Djinni) Crusher Spirits.").defineInRange("tier2CrusherTimeMultiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.tier3CrusherTimeMultiplier = builder.comment("Currently unused. The multiplier to each crushing recipe's crushing_time for Tier 3 (Afrit) Crusher Spirits.").defineInRange("tier3CrusherTimeMultiplier", 0.5, 0.0, Double.MAX_VALUE);
            this.tier4CrusherTimeMultiplier = builder.comment("Currently unused. The multiplier to each crushing recipe's crushing_time for Tier 4 (Marid) Crusher Spirits.").defineInRange("tier4CrusherTimeMultiplier", 0.2, 0.0, Double.MAX_VALUE);
            this.tier1CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 1 (Foliot) Crusher Spirits.").defineInRange("tier1CrusherOutputMultiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.tier2CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 2 (Djinni) Crusher Spirits.").defineInRange("tier2CrusherOutputMultiplier", 1.5, 0.0, Double.MAX_VALUE);
            this.tier3CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 3 (Afrit) Crusher Spirits.").defineInRange("tier3CrusherOutputMultiplier", 2.0, 0.0, Double.MAX_VALUE);
            this.tier4CrusherOutputMultiplier = builder.comment("The multiplier to each crushing recipe's output count for Tier 4 (Marid) Crusher Spirits.").defineInRange("tier4CrusherOutputMultiplier", 3.0, 0.0, Double.MAX_VALUE);
            this.crusherResultPickupDelay = builder.comment("The minimum ticks before a crusher can pick up an item it dropped. Default is 3 Seconds = 3 * 20 Ticks.").defineInRange("crusherResultPickupDelay", 60, 0, Integer.MAX_VALUE);
            this.blacksmithFamiliarRepairChance = builder.comment("The chance for a blacksmith familiar to repair an item (by 2 durability) whenever stone is picked up. 1.0 = 100%, 0.0 = 0%.").defineInRange("blacksmithFamiliarRepairChance", 0.05, 0.0, Double.MAX_VALUE);
            this.blacksmithFamiliarUpgradeCost = builder.comment("The amount of iron required for a blacksmith familiar to upgrade another familiar.").defineInRange("blacksmithFamiliarUpgradeCost", 18, 0, Integer.MAX_VALUE);
            this.blacksmithFamiliarUpgradeCooldown = builder.comment("The cooldown for a blacksmith familiar to upgrade another familiar.").defineInRange("blacksmithFamiliarUpgradeCooldown", 400, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class RitualSettings {
        public final ModConfigSpec.BooleanValue enableClearWeatherRitual;
        public final ModConfigSpec.BooleanValue enableRainWeatherRitual;
        public final ModConfigSpec.BooleanValue enableThunderWeatherRitual;
        public final ModConfigSpec.BooleanValue enableDayTimeRitual;
        public final ModConfigSpec.BooleanValue enableNightTimeRitual;
        public final ModConfigSpec.BooleanValue enableRemainingIngredientCountMatching;
        public final ModConfigSpec.DoubleValue ritualDurationMultiplier;

        public RitualSettings(ModConfigSpec.Builder builder) {
            builder.comment("Ritual Settings").push("rituals");
            this.enableClearWeatherRitual = builder.comment("Enables the ritual to clear rainy weather.").define("enableClearWeatherRitual", true);
            this.enableRainWeatherRitual = builder.comment("Enables the ritual to start rainy weather.").define("enableRainWeatherRitual", true);
            this.enableThunderWeatherRitual = builder.comment("Enables the ritual to start a thunderstorm.").define("enableThunderWeatherRitual", true);
            this.enableDayTimeRitual = builder.comment("Enables the ritual to set time to day.").define("enableDayTimeRitual", true);
            this.enableNightTimeRitual = builder.comment("Enables the ritual to set time to night.").define("enableNightTimeRitual", true);
            this.enableRemainingIngredientCountMatching = builder.comment("If enabled, rituals are interrupted if *more* ingredients are present than needed. This should usually be disabled, but can improve performance if (very very) many rituals are running.").define("enableRemainingIngredientCountMatching", false);
            this.ritualDurationMultiplier = builder.comment("Set a value below 1.0 to speed up rituals. Please ensure to use a preceding 0 for values below 1.0, e.g. '0.05' instead of '.05', otherwise Nightconfig (NeoForge's config sytem) will reset the value to 1.0.").defineInRange("ritualDurationMultiplier", 1.0, 0.05, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class ItemSettings {
        public final ModConfigSpec.BooleanValue anyOreDivinationRod;
        public final ModConfigSpec.BooleanValue minerOutputBeforeBreak;

        public ItemSettings(ModConfigSpec.Builder builder) {
            builder.comment("Item Settings").push("items");
            this.anyOreDivinationRod = builder.comment("Allow the Divining Rod to attune to any ore").define("anyOreDivinationRod", false);
            this.minerOutputBeforeBreak = builder.comment("Miners head to the output in the Dimensional Mineshaft before it breaks").define("minerOutputBeforeBreak", false);
            builder.pop();
        }
    }
}

