/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool.ritual_satchel;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.MultiblockPreviewData;
import com.klikli_dev.modonomicon.api.multiblock.TriPredicate;
import com.klikli_dev.modonomicon.multiblock.matcher.AnyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.DisplayOnlyMatcher;
import com.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.klikli_dev.occultism.common.container.satchel.SatchelInventory;
import com.klikli_dev.occultism.common.item.tool.ChalkItem;
import com.klikli_dev.occultism.common.item.tool.ritual_satchel.PentacleData;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSendPreviewedPentacle;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class RitualSatchelItem
extends Item {
    private final Map<UUID, PentacleData> targetPentacles = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectArrayMap());

    public RitualSatchelItem(Item.Properties properties) {
        super(properties);
    }

    public Map<UUID, PentacleData> targetPentacles() {
        return this.targetPentacles;
    }

    public void setTargetPentacle(UUID player, ResourceLocation multiblock, BlockPos anchor, Rotation facing, BlockPos target, long timeWhenAdded) {
        this.targetPentacles.put(player, new PentacleData(multiblock, anchor, facing, target, timeWhenAdded));
    }

    protected void openMenu(ServerPlayer player, ItemStack stack) {
        int selectedSlot = player.getInventory().selected;
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, unused) -> (AbstractContainerMenu)this.containerFactory().apply((Object)id, (Object)playerInventory, (Object)this.getInventory(player, stack), (Object)selectedSlot), stack.getDisplayName()), buffer -> buffer.writeVarInt(selectedSlot));
    }

    public Container getInventory(ServerPlayer player, ItemStack stack) {
        return new SatchelInventory(stack, 36);
    }

    protected boolean tryPlaceBlockForMatcher(UseOnContext context, Multiblock.SimulateResult targetMatcher) {
        if (targetMatcher.getStateMatcher().getType().equals((Object)AnyMatcher.TYPE) || targetMatcher.getStateMatcher().getType().equals((Object)DisplayOnlyMatcher.TYPE)) {
            return false;
        }
        TriPredicate statePredicate = targetMatcher.getStateMatcher().getStatePredicate();
        ComponentItemHandler inventory = new ComponentItemHandler((MutableDataComponentHolder)context.getItemInHand(), DataComponents.CONTAINER, 36);
        if (!context.getLevel().getBlockState(context.getClickedPos().above()).isAir()) {
            return false;
        }
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            BlockState blockStateToPlace = null;
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.getBlock();
                BlockPlaceContext blockPlaceContext = blockItem.updatePlacementContext(new BlockPlaceContext(context));
                if (blockPlaceContext == null) continue;
                blockStateToPlace = block.getStateForPlacement(blockPlaceContext);
            } else {
                block = stack.getItem();
                if (block instanceof ChalkItem) {
                    ChalkItem chalkItem = (ChalkItem)block;
                    ChalkGlyphBlock chalkBlock = chalkItem.getGlyphBlock().get();
                    blockStateToPlace = chalkBlock.getStateForPlacement(new BlockPlaceContext(context));
                }
            }
            if (blockStateToPlace == null || !statePredicate.test((Object)context.getLevel(), (Object)targetMatcher.getWorldPosition(), blockStateToPlace)) continue;
            stack.useOn(new UseOnContext(context.getLevel(), context.getPlayer(), context.getHand(), stack, context.getHitResult()));
            inventory.setStackInSlot(i, stack);
            return true;
        }
        return false;
    }

    protected InteractionResult useOnClientSide(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        MultiblockPreviewData preview = ModonomiconAPI.get().getCurrentPreviewMultiblock();
        if (preview == null || !preview.isAnchored()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.occultism.ritual_satchel.no_preview_in_world").withStyle(ChatFormatting.YELLOW), true);
            return InteractionResult.PASS;
        }
        Pair simulation = preview.multiblock().simulate(level, preview.anchor(), preview.facing(), false, false);
        Optional<Multiblock.SimulateResult> targetMatcher = ((Collection)simulation.getSecond()).stream().filter(p -> p.getWorldPosition().equals((Object)pos)).findFirst();
        if (targetMatcher.isEmpty() || targetMatcher.get().getStateMatcher().getType() == AnyMatcher.TYPE || targetMatcher.get().getStateMatcher().getType() == DisplayOnlyMatcher.TYPE) {
            player.sendSystemMessage((Component)Component.translatable((String)"item.occultism.ritual_satchel.no_preview_block_targeted").withStyle(ChatFormatting.YELLOW));
            return InteractionResult.PASS;
        }
        Networking.sendToServer(new MessageSendPreviewedPentacle(preview.multiblock().getId(), preview.anchor(), preview.facing(), pos));
        return InteractionResult.SUCCESS;
    }

    protected abstract Function4<Integer, Inventory, Container, Integer, AbstractContainerMenu> containerFactory();

    protected abstract InteractionResult useOnServerSide(UseOnContext var1);

    public boolean isFoil(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(hand));
        }
        if (!player.isShiftKeyDown()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(hand));
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openMenu(serverPlayer, stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (context.getLevel().isClientSide() && context.getPlayer().isShiftKeyDown()) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!context.getLevel().isClientSide() && context.getPlayer().isShiftKeyDown()) {
                this.openMenu(serverPlayer, context.getItemInHand());
                return InteractionResult.SUCCESS;
            }
        }
        if (context.getLevel().isClientSide) {
            return this.useOnClientSide(context);
        }
        return this.useOnServerSide(context);
    }
}

