/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool.ritual_satchel;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.multiblock.matcher.AnyMatcher;
import com.klikli_dev.modonomicon.multiblock.matcher.DisplayOnlyMatcher;
import com.klikli_dev.occultism.common.container.satchel.RitualSatchelT2Container;
import com.klikli_dev.occultism.common.item.tool.ritual_satchel.PentacleData;
import com.klikli_dev.occultism.common.item.tool.ritual_satchel.RitualSatchelItem;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class MultiBlockRitualSatchelItem
extends RitualSatchelItem {
    public MultiBlockRitualSatchelItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected Function4<Integer, Inventory, Container, Integer, AbstractContainerMenu> containerFactory() {
        return RitualSatchelT2Container::new;
    }

    @Override
    protected InteractionResult useOnClientSide(UseOnContext context) {
        if (context.getLevel().getBlockState(context.getClickedPos()).is((Block)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get())) {
            return InteractionResult.SUCCESS;
        }
        return super.useOnClientSide(context);
    }

    protected InteractionResult collectPentacle(UseOnContext context) {
        List<Pair> pentacles = context.getLevel().getRecipeManager().getAllRecipesFor((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().collect(Collectors.toMap(r -> ((RitualRecipe)r.value()).getPentacle().getId(), r -> ((RitualRecipe)r.value()).getPentacle(), (existing, replacement) -> existing)).values().stream().map(pentacle -> Pair.of((Object)pentacle, (Object)pentacle.validate(context.getLevel(), context.getClickedPos()))).filter(p -> p.getSecond() != null).toList();
        ComponentItemHandler inventory = new ComponentItemHandler((MutableDataComponentHolder)context.getItemInHand(), DataComponents.CONTAINER, 36);
        for (Pair pentacle2 : pentacles) {
            Pair simulation = ((Multiblock)pentacle2.getFirst()).simulate(context.getLevel(), context.getClickedPos(), (Rotation)pentacle2.getSecond(), false, false);
            for (Multiblock.SimulateResult targetMatcher : (Collection)simulation.getSecond()) {
                BlockState blockState;
                if (targetMatcher.getStateMatcher().getType().equals((Object)AnyMatcher.TYPE) || targetMatcher.getStateMatcher().getType().equals((Object)DisplayOnlyMatcher.TYPE) || (blockState = context.getLevel().getBlockState(targetMatcher.getWorldPosition())).isAir() || !blockState.is(OccultismTags.Blocks.PENTACLE_MATERIALS)) continue;
                BlockEntity blockEntity = context.getLevel().getBlockEntity(targetMatcher.getWorldPosition());
                List drops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)context.getLevel()), (BlockPos)targetMatcher.getWorldPosition(), (BlockEntity)blockEntity, null, (ItemStack)ItemStack.EMPTY);
                context.getLevel().setBlock(targetMatcher.getWorldPosition(), Blocks.AIR.defaultBlockState(), 3);
                for (ItemStack drop : drops) {
                    ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)drop, (boolean)false);
                    if (remainder.isEmpty()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)context.getPlayer(), (ItemStack)remainder);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected InteractionResult useOnServerSide(UseOnContext context) {
        if (context.getLevel().getBlockState(context.getClickedPos()).is((Block)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get())) {
            return this.collectPentacle(context);
        }
        PentacleData targetPentacle = this.targetPentacles().get(context.getPlayer().getUUID());
        if (targetPentacle == null || targetPentacle.timeWhenAdded() < context.getLevel().getGameTime() - 5L) {
            return InteractionResult.FAIL;
        }
        if (!targetPentacle.target().equals((Object)context.getClickedPos())) {
            return InteractionResult.FAIL;
        }
        Multiblock multiblock = ModonomiconAPI.get().getMultiblock(targetPentacle.multiblock());
        Pair simulation = multiblock.simulate(context.getLevel(), targetPentacle.anchor(), targetPentacle.facing(), false, false);
        boolean placedAnything = false;
        for (Multiblock.SimulateResult targetMatcher : (Collection)simulation.getSecond()) {
            UseOnContext localContext = new UseOnContext(context.getPlayer(), context.getHand(), new BlockHitResult(targetMatcher.getWorldPosition().getCenter(), context.getClickedFace(), targetMatcher.getWorldPosition(), false));
            if (!this.tryPlaceBlockForMatcher(localContext, targetMatcher)) continue;
            placedAnything = true;
        }
        if (!placedAnything) {
            context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.occultism.ritual_satchel.no_valid_item_in_satchel").withStyle(ChatFormatting.YELLOW), true);
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip"), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(pStack))}));
    }
}

