/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.possessed.horde;

import com.klikli_dev.occultism.registry.OccultismTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.level.Level;

public class WildStrayEntity
extends Stray {
    public WildStrayEntity(EntityType<? extends Stray> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Stray.createAttributes().add(Attributes.MAX_HEALTH, 45.0).add(Attributes.ARMOR, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        TagKey<EntityType<?>> wildTrialTag = OccultismTags.Entities.WILD_TRIAL;
        Entity trueSource = source.getEntity();
        if (trueSource != null && trueSource.getType().is(wildTrialTag)) {
            return true;
        }
        Entity immediateSource = source.getDirectEntity();
        if (immediateSource != null && immediateSource.getType().is(wildTrialTag)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    protected boolean isSunBurnTick() {
        return false;
    }
}

