/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.possessed.horde;

import com.klikli_dev.occultism.common.entity.possessed.horde.WildBoggedEntity;
import com.klikli_dev.occultism.common.entity.possessed.horde.WildHuskEntity;
import com.klikli_dev.occultism.common.entity.possessed.horde.WildSlimeEntity;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.TextUtil;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;

public class PossessedStrongBreezeEntity
extends Breeze {
    public PossessedStrongBreezeEntity(EntityType<? extends Breeze> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Breeze.createAttributes().add(Attributes.MAX_HEALTH, 300.0);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        double offsetZ;
        double offsetX;
        Object entity;
        int i;
        for (i = 0; i < 7; ++i) {
            entity = (WildHuskEntity)OccultismEntities.WILD_HUSK.get().create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, (float)level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
        }
        for (i = 0; i < 7; ++i) {
            entity = (WildBoggedEntity)OccultismEntities.WILD_BOGGED.get().create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, (float)level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
        }
        for (i = 0; i < 7; ++i) {
            entity = (WildSlimeEntity)OccultismEntities.WILD_SLIME.get().create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, (float)level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            ((WildSlimeEntity)((Object)entity)).setSize(8, true);
            level.addFreshEntity((Entity)entity);
        }
        return super.finalizeSpawn(level, difficultyIn, reason, spawnDataIn);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        TagKey<EntityType<?>> wildTrialTag = OccultismTags.Entities.WILD_TRIAL;
        Entity trueSource = source.getEntity();
        if (trueSource != null && trueSource.getType().is(wildTrialTag)) {
            return true;
        }
        Entity immediateSource = source.getDirectEntity();
        if (immediateSource != null && immediateSource.getType().is(wildTrialTag)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }
}

