/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.phys.Vec3;

public abstract class ChangeWeatherJob
extends SpiritJob {
    protected int currentChangeTicks;
    protected int requiredChangeTicks;

    public ChangeWeatherJob(SpiritEntity entity, int requiredChangeTicks) {
        super(entity);
        this.requiredChangeTicks = requiredChangeTicks;
    }

    @Override
    public void onInit() {
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < 5; ++i) {
            ((ServerLevel)this.entity.level()).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.entity.getX() + this.entity.level().getRandom().nextGaussian(), this.entity.getY() + 0.5 + this.entity.level().getRandom().nextGaussian(), this.entity.getZ() + this.entity.level().getRandom().nextGaussian(), 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void update() {
        super.update();
        ++this.currentChangeTicks;
        if (!this.entity.swinging) {
            this.entity.swing(InteractionHand.MAIN_HAND);
        }
        if (this.entity.level().getGameTime() % 2L == 0L) {
            ((ServerLevel)this.entity.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.entity.getX(), this.entity.getY() + 0.5, this.entity.getZ(), 3, 0.5, 0.0, 0.0, 0.0);
        }
        if (this.currentChangeTicks == this.requiredChangeTicks) {
            this.changeWeather();
            LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.entity.level());
            lightningboltentity.moveTo(Vec3.atBottomCenterOf((Vec3i)this.entity.blockPosition()));
            lightningboltentity.setVisualOnly(true);
            this.entity.die(this.entity.damageSources().lightningBolt());
            this.entity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt("currentChangeTicks", this.currentChangeTicks);
        compound.putInt("requiredChangeTicks", this.requiredChangeTicks);
        return super.writeJobToNBT(compound, provider);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound, HolderLookup.Provider provider) {
        super.readJobFromNBT(compound, provider);
        this.currentChangeTicks = compound.getInt("currentChangeTicks");
        this.requiredChangeTicks = compound.getInt("requiredChangeTicks");
    }

    public abstract void changeWeather();
}

