/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.ServerLevelData;

public abstract class ChangeTimeJob
extends SpiritJob {
    protected int currentChangeTicks;
    protected int requiredChangeTicks;
    protected long newTime;

    public ChangeTimeJob(SpiritEntity entity, int requiredChangeTicks) {
        super(entity);
        this.requiredChangeTicks = requiredChangeTicks;
    }

    @Override
    public void onInit() {
        this.newTime = this.getNewTime();
        if (!this.isEnabled()) {
            this.entity.getOwner().sendSystemMessage(this.getDisabledMessage());
            this.finishChangeTime();
        }
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < 5; ++i) {
            ((ServerLevel)this.entity.level()).sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.entity.getX() + this.entity.level().getRandom().nextGaussian(), this.entity.getY() + 0.5 + this.entity.level().getRandom().nextGaussian(), this.entity.getZ() + this.entity.level().getRandom().nextGaussian(), 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void update() {
        super.update();
        ++this.currentChangeTicks;
        if (!this.entity.swinging) {
            this.entity.swing(InteractionHand.MAIN_HAND);
        }
        if (this.entity.level().getGameTime() % 2L == 0L) {
            ((ServerLevel)this.entity.level()).sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.entity.getX(), this.entity.getY() + 0.5, this.entity.getZ(), 3, 0.5, 0.0, 0.0, 0.0);
        }
        if (this.isEnabled()) {
            this.updateTime();
        }
        if (this.currentChangeTicks == this.requiredChangeTicks) {
            this.finishChangeTime();
        }
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt("currentChangeTicks", this.currentChangeTicks);
        compound.putInt("requiredChangeTicks", this.requiredChangeTicks);
        compound.putLong("newTime", this.newTime);
        return super.writeJobToNBT(compound, provider);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound, HolderLookup.Provider provider) {
        super.readJobFromNBT(compound, provider);
        this.currentChangeTicks = compound.getInt("currentChangeTicks");
        this.requiredChangeTicks = compound.getInt("requiredChangeTicks");
        this.newTime = compound.getLong("newTime");
    }

    public void updateTime() {
        ServerLevelData level = (ServerLevelData)this.entity.level().getLevelData();
        long remainingTime = this.newTime - level.getDayTime();
        int remainingTicks = Math.max(this.requiredChangeTicks - this.currentChangeTicks, 1);
        long timeChange = remainingTime / (long)remainingTicks;
        long interpolatedTime = level.getDayTime() + timeChange;
        if (interpolatedTime >= this.newTime) {
            interpolatedTime = this.newTime;
        }
        level.setDayTime(interpolatedTime);
    }

    public void finishChangeTime() {
        this.entity.level().playSound(null, this.entity.blockPosition(), SoundEvents.BEACON_ACTIVATE, SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.entity.die(this.entity.damageSources().fellOutOfWorld());
        this.entity.remove(Entity.RemovalReason.DISCARDED);
    }

    public abstract long getNewTime();

    public abstract Component getDisabledMessage();

    public abstract boolean isEnabled();
}

