/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.FairyFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEffects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class MummyFamiliarEntity
extends FamiliarEntity {
    private static final ResourceLocation DAMAGE_BONUS = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"mummy_damage_bonus");
    private static final int MAX_FIGHT_TIMER = 5;
    private int fightPose;
    private int fightTimer;
    private Vec3 capowPos;
    private Vec3 capowOffset;
    private Vec3 capowOffset0;

    public MummyFamiliarEntity(EntityType<? extends MummyFamiliarEntity> type, Level level) {
        super(type, level);
        this.capowOffset = this.capowOffset0 = Vec3.ZERO;
        this.capowPos = this.capowOffset0;
        this.fightPose = -1;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createAttributes().add(Attributes.ATTACK_DAMAGE, 9.0).add(Attributes.FOLLOW_RANGE, 30.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 4.0f, 1.0f));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
        this.targetSelector.addGoal(0, (Goal)new FairyFamiliarEntity.SetAttackTargetGoal(this));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.fightPose != -1) {
            this.capowOffset0 = this.capowOffset;
            if (this.fightTimer++ == 5) {
                this.fightTimer = 0;
                ++this.fightPose;
                if (this.fightPose == 3) {
                    this.fightPose = -1;
                }
                this.capowPos = new Vec3(this.randNum(2.0), -this.random.nextDouble(), this.randNum(2.0));
            }
            this.capowOffset = new Vec3(this.randNum(0.1), this.randNum(0.1), this.randNum(0.1));
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setCrown(this.getRandom().nextDouble() < 0.1);
        this.setTooth(this.getRandom().nextBoolean());
        this.setHeka(this.getRandom().nextBoolean());
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public void swing(InteractionHand pHand, boolean pUpdateSelf) {
        super.swing(pHand, pUpdateSelf);
        this.fightPose = 0;
        this.fightTimer = 0;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance(OccultismEffects.MUMMY_DODGE, 300, 0, false, false));
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    private double randNum(double size) {
        return (this.random.nextDouble() - 0.5) * size;
    }

    public float getCapowAlpha(float partialTicks) {
        return ((float)(5 - this.fightTimer) - partialTicks) / 5.0f;
    }

    public Vec3 getCapowPosition(float partialTicks) {
        return this.capowPos.add(this.capowOffset0.add(this.capowOffset0.subtract(this.capowOffset).scale((double)partialTicks)));
    }

    public int getFightPose() {
        return this.fightPose;
    }

    @Override
    public void blacksmithUpgrade() {
        super.blacksmithUpgrade();
        AttributeModifier damage = new AttributeModifier(DAMAGE_BONUS, 3.0, AttributeModifier.Operation.ADD_VALUE);
        if (!this.getAttribute(Attributes.ATTACK_DAMAGE).hasModifier(DAMAGE_BONUS)) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).addPermanentModifier(damage);
        }
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasCrown()) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    public boolean hasCrown() {
        return this.hasVariant(0);
    }

    private void setCrown(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasHeka() {
        return this.hasVariant(1);
    }

    private void setHeka(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasTooth() {
        return this.hasVariant(2);
    }

    private void setTooth(boolean b) {
        this.setVariant(2, b);
    }
}

