/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.ResizableFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.ShubNiggurathFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public class GoatFamiliarEntity
extends ResizableFamiliarEntity {
    private int shakeHeadTimer;

    public GoatFamiliarEntity(EntityType<? extends GoatFamiliarEntity> type, Level level) {
        super((EntityType<? extends ResizableFamiliarEntity>)type, level);
    }

    public GoatFamiliarEntity(Level worldIn, boolean hasRing, boolean hasBeard, byte size, LivingEntity owner) {
        this((EntityType<? extends GoatFamiliarEntity>)OccultismEntities.GOAT_FAMILIAR.get(), worldIn);
        this.setRing(hasRing);
        this.setBeard(hasBeard);
        this.setSize(size);
        this.setFamiliarOwner(owner);
    }

    public static void ringBell(FamiliarEntity entity) {
        LivingEntity owner = entity.getFamiliarOwner();
        if (owner == null || !entity.hasBlacksmithUpgrade()) {
            return;
        }
        entity.playSound(SoundEvents.BELL_BLOCK, 1.0f, 1.0f);
        for (Mob e2 : entity.level().getEntitiesOfClass(Mob.class, entity.getBoundingBox().inflate(30.0), e -> e.isAlive() && e.getClassification(false) == MobCategory.MONSTER)) {
            e2.setTarget(owner);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            --this.shakeHeadTimer;
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (super.hurt(pSource, pAmount)) {
            if (pSource.getEntity() != null) {
                GoatFamiliarEntity.ringBell(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (!compound.contains("variants")) {
            this.setRing(compound.getBoolean("hasRing"));
        }
    }

    public boolean hasRing() {
        return this.hasVariant(0);
    }

    private void setRing(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasBeard() {
        return this.hasVariant(1);
    }

    private void setBeard(boolean b) {
        this.setVariant(1, b);
    }

    public boolean isBlack() {
        return this.hasVariant(2);
    }

    private void setBlack(boolean b) {
        this.setVariant(2, b);
    }

    public boolean hasRedEyes() {
        return this.hasVariant(3);
    }

    private void setRedEyes(boolean b) {
        this.setVariant(3, b);
    }

    public boolean hasEvilHorns() {
        return this.hasVariant(4);
    }

    private void setEvilHorns(boolean b) {
        this.setVariant(4, b);
    }

    @Override
    protected InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        boolean isInTransformationBiome;
        ItemStack stack = playerIn.getItemInHand(hand);
        boolean bl = isInTransformationBiome = this.isInTransformationBiome((Entity)playerIn) || this.isInTransformationBiome((Entity)this);
        if (this.isTransformItem(stack) && playerIn == this.getFamiliarOwner()) {
            if (isInTransformationBiome) {
                if (stack.is(Tags.Items.DYES_BLACK)) {
                    this.setBlack(true);
                } else if (stack.getItem() == Items.ENDER_EYE) {
                    this.setRedEyes(true);
                } else if (stack.getItem() == Items.FLINT) {
                    this.setEvilHorns(true);
                }
                if (this.shouldTransform()) {
                    ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger((LivingEntity)playerIn, FamiliarTrigger.Type.SHUB_NIGGURATH_SUMMON);
                    this.transform();
                }
                if (!this.level().isClientSide) {
                    stack.shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            this.shakeHeadTimer = 20;
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(playerIn, hand);
    }

    private void transform() {
        if (this.level().isClientSide) {
            float scale = this.getScale();
            for (int i = 0; i < 30; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getRandomX(scale), this.getRandomY() * (double)scale, this.getRandomZ(scale), 0.0, 0.0, 0.0);
            }
        } else {
            ShubNiggurathFamiliarEntity shubNiggurath = new ShubNiggurathFamiliarEntity(this.level(), this);
            this.level().addFreshEntity((Entity)shubNiggurath);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    boolean isTransformItem(ItemStack stack) {
        return stack.is(Tags.Items.DYES_BLACK) && !this.isBlack() || stack.getItem() == Items.FLINT && !this.hasEvilHorns() || stack.getItem() == Items.ENDER_EYE && !this.hasRedEyes();
    }

    boolean shouldTransform() {
        return this.isBlack() && this.hasRedEyes() && this.hasEvilHorns();
    }

    private boolean isInTransformationBiome(Entity entity) {
        return this.level().getBiome(entity.blockPosition()).is(OccultismTags.ALLOWS_SHUB_NIGGURRATH_TRANSFORMATION);
    }

    public float getNeckYRot(float pPartialTick) {
        if (this.shakeHeadTimer <= 0) {
            return 0.0f;
        }
        return Mth.sin((float)(((float)this.shakeHeadTimer - pPartialTick) / 20.0f * (float)Math.PI * 5.0f)) * (float)Math.toRadians(30.0);
    }
}

