/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageFairySupport;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismParticles;
import com.klikli_dev.occultism.util.FamiliarUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class FairyFamiliarEntity
extends FamiliarEntity
implements FlyingAnimal {
    private static final EntityDataAccessor<Integer> MAGIC_TARGET = SynchedEntityData.defineId(FairyFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final float ANIMATION_HEIGHT_SPEED = 0.2f;
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    private int saveCooldown = 0;
    private int supportAnim;

    public FairyFamiliarEntity(EntityType<? extends FairyFamiliarEntity> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(PathType.WALKABLE, -1.0f);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.noCulling = true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createAttributes().add(Attributes.FLYING_SPEED, 0.4).add(Attributes.MAX_HEALTH, 18.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MAGIC_TARGET, (Object)-1);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasFlower()) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(3, (Goal)new MagicGoal(this));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 4.0f, 1.0f));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
        this.goalSelector.addGoal(8, (Goal)new SupportGoal(this));
        this.targetSelector.addGoal(0, (Goal)new SetAttackTargetGoal(this));
    }

    protected PathNavigation createNavigation(Level pLevel) {
        FlyingPathNavigation navigator = new FlyingPathNavigation(this, (Mob)this, pLevel){

            public void tick() {
                super.tick();
                BlockPos pos = this.mob.blockPosition().below();
                BlockState below = this.level.getBlockState(pos);
                if (below.isAir()) {
                    if (this.mob.yya < 0.0f) {
                        this.mob.setYya(this.mob.yya * 0.9f);
                    }
                    if (this.mob.getDeltaMovement().y < 0.0) {
                        this.mob.setDeltaMovement(this.mob.getDeltaMovement().multiply(1.0, 0.9, 1.0));
                    }
                }
            }

            public boolean isStableDestination(BlockPos pos) {
                BlockState state = this.level.getBlockState(pos);
                BlockState below = this.level.getBlockState(pos.below());
                return state.isAir() && below.isAir();
            }
        };
        return navigator;
    }

    public void tick() {
        super.tick();
        if (this.isSitting()) {
            this.setDeltaMovement(Vec3.ZERO);
            this.yBodyRot = this.yBodyRotO;
        }
        if (this.saveCooldown > 0) {
            --this.saveCooldown;
        }
        this.partyParticle();
        if (!this.level().isClientSide && this.getTarget() == null) {
            this.setMagicTarget(null);
        }
        if (this.level().isClientSide && this.hasMagicTarget()) {
            this.yBodyRot = 0.0f;
            this.yBodyRotO = 0.0f;
            this.magicParticle();
        }
        if (this.supportAnim > 0) {
            --this.supportAnim;
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        SpawnGroupData data = super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
        this.setTeeth(this.getRandom().nextBoolean());
        this.setLeftHanded(this.getRandom().nextBoolean());
        this.setFlower(this.getRandom().nextDouble() < 0.1);
        return data;
    }

    public float getSupportAnim(float partialTicks) {
        if (this.supportAnim == 0) {
            return 0.0f;
        }
        return ((float)(20 - this.supportAnim) + partialTicks) / 20.0f;
    }

    public float getAnimationHeight(float partialTicks) {
        return Mth.cos((float)(((float)this.tickCount + partialTicks) * 0.2f)) * 0.1f + 0.12f;
    }

    public float getWingRot(float partialTicks) {
        return Mth.cos((float)(((float)this.tickCount + partialTicks) * 0.2f * 3.0f));
    }

    private float getPartyArmArg(float partialTicks) {
        return ((float)this.tickCount + partialTicks) * 0.2f;
    }

    public float getPartyArmRotX(float partialTicks) {
        return Mth.cos((float)this.getPartyArmArg(partialTicks)) * FamiliarUtil.toRads(40.0f) - FamiliarUtil.toRads(90.0f);
    }

    public float getPartyArmRotY(float partialTicks) {
        return Mth.sin((float)this.getPartyArmArg(partialTicks)) * FamiliarUtil.toRads(40.0f);
    }

    public boolean isNoGravity() {
        return true;
    }

    private ParticleOptions createParticle() {
        return FamiliarUtil.isChristmas() ? (ParticleOptions)OccultismParticles.SNOWFLAKE.get() : new DustParticleOptions(new Vector3f(0.9f, 0.9f, 0.5f), 1.0f);
    }

    private void magicParticle() {
        Vec3 pos = this.getMagicPosition(1.0f);
        this.level().addParticle(this.createParticle(), pos.x, pos.y + 1.0, pos.z, 0.0, 0.0, 0.0);
    }

    private void partyParticle() {
        if (!this.level().isClientSide || !this.isPartying() || this.tickCount % 2 != 0) {
            return;
        }
        Vec3 right = Vec3.directionFromRotation((float)0.0f, (float)this.yBodyRot).yRot(FamiliarUtil.toRads(-90.0f));
        Vec3 armVector = new Vec3(0.0, -0.4, 0.0).xRot(this.getPartyArmRotX(0.0f)).yRot(-this.getPartyArmRotY(0.0f) + FamiliarUtil.toRads(-this.yBodyRot + 180.0f));
        Vec3 pos = this.position().add(right.scale(0.2 * (double)(this.isLeftHanded() ? -1 : 1))).add(0.0, 0.7 + (double)this.getAnimationHeight(0.0f), 0.0).add(armVector);
        this.level().addParticle(this.createParticle(), pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
    }

    public Vec2 getMagicRadiusAngle(float partialTicks) {
        Entity target = this.getMagicTarget();
        if (target == null) {
            return Vec2.ZERO;
        }
        float radius = target.getBbWidth() * 1.2f;
        float angle = ((float)this.tickCount + partialTicks) * 0.1f;
        return new Vec2(radius, angle);
    }

    public Vec3 getMagicPosition(float partialTicks) {
        Entity target = this.getMagicTarget();
        if (target == null) {
            return null;
        }
        Vec3 targetPos = target.getPosition(partialTicks).add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
        Vec2 radiusAngle = this.getMagicRadiusAngle(partialTicks);
        Vec3 offset = new Vec3((double)(Mth.cos((float)radiusAngle.y) * radiusAngle.x), 0.0, (double)(Mth.sin((float)radiusAngle.y) * radiusAngle.x));
        return targetPos.add(offset);
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return Collections.emptyList();
    }

    @Override
    public void curioTick(LivingEntity wearer) {
        if (this.saveCooldown > 0) {
            --this.saveCooldown;
        }
    }

    public boolean hasTeeth() {
        return this.hasVariant(0);
    }

    private void setTeeth(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasFlower() {
        return this.hasVariant(1);
    }

    private void setFlower(boolean b) {
        this.setVariant(1, b);
    }

    public Entity getMagicTarget() {
        int id = (Integer)this.entityData.get(MAGIC_TARGET);
        if (id < 0) {
            return null;
        }
        return this.level().getEntity(id);
    }

    private void setMagicTarget(Entity entity) {
        int id = entity == null ? -1 : entity.getId();
        this.entityData.set(MAGIC_TARGET, (Object)id);
    }

    public boolean hasMagicTarget() {
        return this.getMagicTarget() != null;
    }

    public boolean saveFamiliar(IFamiliar familiar) {
        if (this.saveCooldown > 0 || this.isSitting()) {
            return false;
        }
        this.saveCooldown = 400;
        if (!familiar.getFamiliarEntity().level().isClientSide) {
            Networking.sendToTracking((Entity)this, new MessageFairySupport(this.getId(), familiar.getFamiliarEntity().getId()));
        }
        return true;
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (!pSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && this.getMagicTarget() != null) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    protected AABB getAttackBoundingBox() {
        AABB aabb;
        Entity entity = this.getVehicle();
        if (entity != null) {
            AABB aabb1 = entity.getBoundingBox();
            AABB aabb2 = this.getBoundingBox();
            aabb = new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
        } else {
            aabb = this.getBoundingBox();
        }
        return aabb.inflate(DEFAULT_ATTACK_REACH * 3.0, 0.0, DEFAULT_ATTACK_REACH * 3.0);
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource p_147189_) {
        return false;
    }

    public void push(Entity pEntity) {
        if (this.hasMagicTarget()) {
            return;
        }
        super.push(pEntity);
    }

    protected void doPush(Entity pEntity) {
        if (this.hasMagicTarget()) {
            return;
        }
        super.doPush(pEntity);
    }

    public boolean isPickable() {
        return !this.hasMagicTarget();
    }

    public void startSupportAnimation() {
        this.supportAnim = 20;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    private static class MagicGoal
    extends MeleeAttackGoal {
        private final FairyFamiliarEntity fairy;
        private int attackTimer;

        public MagicGoal(FairyFamiliarEntity fairy) {
            super((PathfinderMob)fairy, 1.8, true);
            this.fairy = fairy;
        }

        public void start() {
            super.start();
            this.attackTimer = 10;
        }

        public void stop() {
            super.stop();
            this.fairy.setMagicTarget(null);
        }

        protected boolean canPerformAttack(LivingEntity pEntity) {
            return this.mob.isWithinMeleeAttackRange(pEntity);
        }

        protected void checkAndPerformAttack(LivingEntity pEnemy) {
            --this.attackTimer;
            if (this.canPerformAttack(pEnemy)) {
                this.fairy.setMagicTarget((Entity)pEnemy);
                if (this.attackTimer <= 0) {
                    this.attackTimer = 10;
                    LivingEntity owner = this.fairy.getFamiliarOwner();
                    if (owner != null) {
                        pEnemy.hurt(this.fairy.damageSources().mobAttack(owner), 3.0f);
                        pEnemy.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 1));
                        List allies = this.fairy.level().getEntitiesOfClass(LivingEntity.class, this.fairy.getBoundingBox().inflate(7.0), e -> e != this.fairy && e instanceof IFamiliar && ((IFamiliar)e).getFamiliarOwner() == owner);
                        allies.add(owner);
                        for (LivingEntity ally : allies) {
                            ally.heal(3.0f);
                            ((ServerLevel)this.fairy.level()).sendParticles((ParticleOptions)ParticleTypes.HEART, ally.getX(), ally.getY() + (double)ally.getBbHeight(), ally.getZ(), 1, 0.0, 0.0, 0.0, 1.0);
                        }
                    }
                }
            } else {
                this.fairy.setMagicTarget(null);
            }
        }
    }

    private static class SupportGoal
    extends Goal {
        private static final int DURATION = 200;
        private final FairyFamiliarEntity fairy;
        private final Map<UUID, Integer> cooldowns;

        private SupportGoal(FairyFamiliarEntity fairy) {
            this.fairy = fairy;
            this.cooldowns = new HashMap<UUID, Integer>();
        }

        public boolean canUse() {
            return !this.fairy.isSitting() && this.fairy.getFamiliarEntity() != null;
        }

        public void tick() {
            for (Map.Entry<UUID, Integer> entry : this.cooldowns.entrySet()) {
                if (entry.getValue() <= 0) continue;
                this.cooldowns.put(entry.getKey(), entry.getValue() - 1);
            }
            if (this.fairy.tickCount % 5 != 0) {
                return;
            }
            LivingEntity owner = this.fairy.getFamiliarOwner();
            if (owner == null) {
                return;
            }
            List familiars = this.fairy.level().getEntitiesOfClass(Mob.class, this.fairy.getBoundingBox().inflate(10.0), e -> e != this.fairy && e instanceof IFamiliar && ((IFamiliar)e).getFamiliarOwner() == owner);
            for (Mob familiar : familiars) {
                boolean gaveSupport;
                UUID id = familiar.getUUID();
                if (!this.cooldowns.containsKey(id)) {
                    this.cooldowns.put(id, 0);
                }
                if (this.cooldowns.get(id) != 0) continue;
                boolean bl = gaveSupport = familiar.isOnFire() && familiar.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200));
                if (familiar.isInWater() && familiar.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 200))) {
                    gaveSupport = true;
                }
                if (!familiar.isNoGravity() && familiar.fallDistance > 3.0f && familiar.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 200))) {
                    gaveSupport = true;
                }
                if (familiar.getNavigation().isInProgress() && familiar.getNavigation().getTargetPos().distSqr((Vec3i)familiar.blockPosition()) > 100.0 && familiar.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200))) {
                    gaveSupport = true;
                }
                if (familiar.getLastHurtByMob() != null && familiar.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200))) {
                    gaveSupport = true;
                }
                if (!gaveSupport) continue;
                Networking.sendToTracking((Entity)this.fairy, new MessageFairySupport(this.fairy.getId(), familiar.getId()));
                this.cooldowns.put(id, 200);
            }
        }
    }

    public static class SetAttackTargetGoal
    extends TargetGoal {
        private final FamiliarEntity entity;
        private int timestamp;

        public SetAttackTargetGoal(FamiliarEntity entity) {
            super((Mob)entity, false);
            this.entity = entity;
        }

        public boolean canUse() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (owner == null) {
                return false;
            }
            if (owner.distanceToSqr((Entity)this.entity) >= 400.0) {
                return false;
            }
            if (this.timestamp == owner.getLastHurtMobTimestamp()) {
                return false;
            }
            LivingEntity target = owner.getLastHurtMob();
            return target != null && !(target instanceof Player) && !(target instanceof IFamiliar);
        }

        public boolean canContinueToUse() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            return super.canContinueToUse() && owner != null && owner.distanceToSqr((Entity)this.entity) < 400.0;
        }

        public void start() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (owner == null) {
                return;
            }
            this.entity.setTarget(owner.getLastHurtMob());
            this.timestamp = owner.getLastHurtMobTimestamp();
            super.start();
        }
    }
}

