/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.DevilFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.GreedyFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.ThrownSwordEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.registry.OccultismEntities;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class DragonFamiliarEntity
extends FamiliarEntity {
    public static final int MAX_PET_TIMER = 40;
    private static final int GREEDY_INCREMENT = 6000;
    private final float colorOffset = this.getRandom().nextFloat() * 2.0f;
    private int greedyTimer;
    private int flyingTimer;
    private int flyingTimer0;
    private int wingspan;
    private int wingspan0;
    private int petTimer = 40;

    public DragonFamiliarEntity(EntityType<? extends DragonFamiliarEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createAttributes().add(Attributes.ARMOR, 25.0);
    }

    public Vec3 getPassengerRidingPosition(Entity pEntity) {
        return super.getPassengerRidingPosition(pEntity).subtract(0.0, 0.4, 0.0);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasFez()) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setFez(this.getRandom().nextDouble() < 0.1);
        this.setEars(this.getRandom().nextDouble() < 0.5);
        this.setArms(this.getRandom().nextDouble() < 0.5);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean hasSword() {
        return this.hasBlacksmithUpgrade() && !this.swinging;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new GreedyFamiliarEntity.FindItemGoal(this){

            @Override
            public boolean canUse() {
                return super.canUse() && DragonFamiliarEntity.this.getPassengers().stream().anyMatch(e -> e instanceof GreedyFamiliarEntity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new FetchGoal(this));
        this.goalSelector.addGoal(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.goalSelector.addGoal(6, (Goal)new DevilFamiliarEntity.AttackGoal(this, 5.0f){

            @Override
            public boolean canUse() {
                return super.canUse() && !DragonFamiliarEntity.this.hasBlacksmithUpgrade();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new ThrowSwordGoal(this, 100.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void swing(InteractionHand handIn, boolean updateSelf) {
        super.swing(handIn, updateSelf);
        this.swingTime = -14;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public float getAttackProgress(float partialTicks) {
        return Mth.lerp((float)(((float)(this.swingTime + 14) + partialTicks) / 20.0f), (float)0.0f, (float)1.0f);
    }

    public int getPetTimer() {
        return this.petTimer;
    }

    public void tick() {
        super.tick();
        if (this.greedyTimer > 0) {
            --this.greedyTimer;
        }
        if (!this.onGround()) {
            Vec3 motion = this.getDeltaMovement();
            if (motion.y < 0.0) {
                motion = motion.multiply(1.0, 0.5, 1.0);
                this.setDeltaMovement(motion);
            }
        }
        if (!this.isEffectiveAi()) {
            this.flyingTimer0 = this.flyingTimer++;
            this.wingspan0 = this.wingspan;
            if (this.onGround()) {
                this.wingspan -= 5;
                if (this.wingspan < 0) {
                    this.wingspan = 0;
                }
            } else {
                this.wingspan += 5;
                if (this.wingspan > 30) {
                    this.wingspan = 30;
                }
            }
            if (this.petTimer < 40) {
                ++this.petTimer;
            }
        }
    }

    public float getFlyingTimer(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.flyingTimer0, (float)this.flyingTimer);
    }

    public float getWingspan(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.wingspan0, (float)this.wingspan);
    }

    @Override
    protected InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (this.hasStick()) {
            ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)new ItemStack((ItemLike)Items.STICK));
            this.setStick(false);
            return InteractionResult.sidedSuccess((!this.isEffectiveAi() ? 1 : 0) != 0);
        }
        if (stack.is(Tags.Items.NUGGETS_GOLD)) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(this.getFamiliarOwner(), FamiliarTrigger.Type.DRAGON_NUGGET);
            this.greedyTimer += 6000;
            if (this.isEffectiveAi()) {
                stack.shrink(1);
            } else {
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getX(), this.getY() + 1.0, this.getZ(), 0.0, 0.0, 0.0);
            }
            return InteractionResult.sidedSuccess((!this.isEffectiveAi() ? 1 : 0) != 0);
        }
        if (stack.isEmpty() && playerIn.isShiftKeyDown()) {
            this.petTimer = 0;
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger((LivingEntity)playerIn, FamiliarTrigger.Type.DRAGON_PET);
            return InteractionResult.sidedSuccess((!this.isEffectiveAi() ? 1 : 0) != 0);
        }
        return super.mobInteract(playerIn, hand);
    }

    public boolean hasFez() {
        return this.hasVariant(0);
    }

    private void setFez(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasEars() {
        return this.hasVariant(1);
    }

    private void setEars(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasArms() {
        return this.hasVariant(2);
    }

    private void setArms(boolean b) {
        this.setVariant(2, b);
    }

    public boolean hasStick() {
        return this.hasVariant(3);
    }

    private void setStick(boolean b) {
        this.setVariant(3, b);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("greedyTimer", this.greedyTimer);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (!compound.contains("variants")) {
            this.setFez(compound.getBoolean("hasFez"));
            this.setEars(compound.getBoolean("hasEars"));
            this.setArms(compound.getBoolean("hasArms"));
            this.setStick(compound.getBoolean("hasStick"));
        }
        this.greedyTimer = compound.getInt("greedyTimer");
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance(OccultismEffects.DRAGON_GREED, 300, this.greedyTimer > 0 ? 1 : 0, false, false));
    }

    public float getEyeColorR(float partialTicks) {
        return Math.abs(Mth.sin((float)(((float)this.tickCount + partialTicks + 5.0f) / 20.0f + this.colorOffset))) * 0.8f + 0.2f;
    }

    public float getEyeColorG(float partialTicks) {
        return Math.abs(Mth.sin((float)(((float)this.tickCount + partialTicks + 10.0f) / 30.0f + this.colorOffset))) * 0.8f + 0.2f;
    }

    public float getEyeColorB(float partialTicks) {
        return Math.abs(Mth.sin((float)(((float)this.tickCount + partialTicks) / 40.0f + this.colorOffset))) * 0.8f + 0.2f;
    }

    private static class FetchGoal
    extends Goal {
        private final DragonFamiliarEntity dragon;
        private ItemEntity stick;

        public FetchGoal(DragonFamiliarEntity dragon) {
            this.dragon = dragon;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.stick = this.findStick();
            return this.stick != null && !this.dragon.hasStick();
        }

        public boolean canContinueToUse() {
            return this.stick != null && !this.dragon.hasStick();
        }

        public void start() {
            this.dragon.getNavigation().moveTo((Entity)this.stick, 1.2);
        }

        public void stop() {
            this.dragon.getNavigation().stop();
            this.stick = null;
        }

        public void tick() {
            if (this.stick == null || !this.stick.isAlive()) {
                this.stick = this.findStick();
                if (this.stick == null) {
                    return;
                }
            }
            this.dragon.getNavigation().moveTo((Entity)this.stick, 1.2);
            if (this.stick.distanceToSqr((Entity)this.dragon) < 3.0) {
                this.dragon.setStick(true);
                ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(this.dragon.getFamiliarOwner(), FamiliarTrigger.Type.DRAGON_FETCH);
                this.stick.getItem().shrink(1);
                this.stick = null;
            }
        }

        private ItemEntity findStick() {
            List sticks = this.dragon.level().getEntitiesOfClass(ItemEntity.class, this.dragon.getBoundingBox().inflate(8.0), e -> e.getItem().getItem() == Items.STICK && e.isAlive());
            return sticks.isEmpty() ? null : (ItemEntity)sticks.get(0);
        }
    }

    private static class ThrowSwordGoal
    extends DevilFamiliarEntity.AttackGoal {
        public ThrowSwordGoal(FamiliarEntity entity, float range) {
            super(entity, range);
        }

        @Override
        public boolean canUse() {
            return super.canUse() && this.entity.hasBlacksmithUpgrade();
        }

        @Override
        protected void attack(List<LivingEntity> enemies) {
            if (enemies.isEmpty()) {
                return;
            }
            Entity enemy = (Entity)enemies.get(this.entity.getRandom().nextInt(enemies.size()));
            ThrownSwordEntity sword = new ThrownSwordEntity((EntityType<? extends ThrownSwordEntity>)((EntityType)OccultismEntities.THROWN_SWORD_TYPE.get()), this.entity.level());
            sword.setOwner((Entity)this.entity.getFamiliarOwner());
            double x = this.entity.getX();
            double y = this.entity.getEyeY();
            double z = this.entity.getZ();
            double xDir = enemy.getX() - x;
            double yDir = enemy.getY() + (double)enemy.getBbHeight() - y;
            double zDir = enemy.getZ() - z;
            sword.setPos(x, y, z);
            sword.shoot(xDir, yDir, zDir, 0.5f, 3.0f);
            this.entity.level().addFreshEntity((Entity)sword);
        }
    }
}

